@extends('layouts.master')
 
@section('title') Nouveau Creancier @stop
 
@section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
    <!-- Datatable -->
    {!! Html::style('css/dataTables.bootstrap.css'); !!} 
    {!! Html::style('css/buttons.bootstrap.css'); !!} 
@stop

@section('content')
 

<div class="container-fluid {!! (isset($mandat))?'col-lg-8':'col-lg-max col-lg-offset-1' !!}"> 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h2><i class='fa fa-banque'></i>Nouveau Creancier</h2>
 
    {!! Form::open(['creancier' => 'form', 'url' => '/tiers/creanciers', 'class' => 'form-horizontal']) !!}
    {!! Form::hidden('mode_frame',(isset($mandat)?true:false),['id'=>'mode_frame']); !!}
    {!! Form::hidden('num_creancier', '', ['id'=>'num_creancier']) !!}

    <div class="col-xs-6" style="padding-left:0px">
        {!! Form::label('origine', 'Origine') !!}
        {!! 
        Form::select(
            'origine',
            [''=>' ','BEN'=>'Bénéficiaires','EMP' => 'Employeurs','CRE' => 'Créanciers','AUT' => 'Autre'],
            null,
            ['class' => 'selectpicker','data-width' => "100%",'id'=>'origine']
        ) 
            
        !!}
        <script type="text/javascript">
        $(function() {
            $('.form-group').hide();
            //$('.identifiants').attr('readonly','true');
            set_origine();
            function set_origine() {
                var origine_value=$("#origine option:selected").val();
                if(origine_value!='AUT')  $('.identifiants').attr('readonly','true');
                $('#creancier_beneficiaire').hide();
                $('#creancier_employeur').hide();
                $('#creancier_creancier').hide();
                $('.form-group').show();
                if(origine_value=='BEN') $('#creancier_beneficiaire').show();
                if(origine_value=='EMP') $('#creancier_employeur').show();  
                if(origine_value=='CRE') $('#creancier_creancier').show();
                if(origine_value=='AUT') {
                    $('.identifiants').removeAttr('readonly');}

                if(origine_value=='') {
                    $('.form-group').hide();
                    $('.identifiants').attr('readonly','true');
                }
            }

            $("#origine").change(function() {
                $('#num_creancier').val('');
                $('#nom').val('');
                $('#prenom').val('');
                $('#datenaiss').val('');
                $('#compte').val('');
                $('#bqcle_creancier').val('');
                set_origine();
            });

        });
        </script>
    </div>

        
    <div class="form-group">
        <div id='creancier_beneficiaire'>
            <div class="col-xs-5">
                {!! Form::label('creancier_benef', 'Créancier (bénéficiaire') !!}
                {!! Form::text('creancier_benef', null, ['id'=>'creancier_benef','placeholder' => "Numéro de créancier"
                    , 'class' => 'form-control']) !!}
            </div>
                <script type="text/javascript">
                $(function() {
                    $("#creancier_benef").autocomplete({
                        source: "{!! url('auto_creancier_beneficiaire') !!}",
                        minLength: 2,
                        select: function(event, ui) {
                            $('#num_creancier').val(ui.item.beneficiaire_id);
                            $('#nom').val(ui.item.beneficiaire_nom);
                            $('#prenom').val(ui.item.prenom);
                            var datenaiss=ui.item.datenaiss;
                            $('#compte').val(ui.item.compte);
                            $('select[id="bqcle_creancier"]').val(ui.item.banque_id);
                            $('.selectpicker').selectpicker('refresh');
                            //MEF de la date de naissance
                            var annee=datenaiss.substr(0,4);
                            var mois=datenaiss.substr(5,2);
                            var jour=datenaiss.substr(8,2);
                            $('#datenaiss').val(jour+"/"+mois+"/"+annee);

                        },
                        close: function(event, ui) {
                            
                        }
                    });    
                });
            </script>
        </div>

        <div id='creancier_employeur'>
            <div class="col-xs-5">
                {!! Form::label('creancier_emp', 'Créancier (Employeur') !!}
                {!! Form::text('creancier_emp', null, ['id'=>'creancier_emp','placeholder' => "Numéro de créancier"
                    , 'class' => 'form-control']) !!}
            </div>
                <script type="text/javascript">
                $(function() {
                    $("#creancier_emp").autocomplete({
                        source: "{!! url('auto_creancier_employeur') !!}",
                        minLength: 2,
                        select: function(event, ui) {
                            $('#num_creancier').val(ui.item.employeur_id);
                            $('#nom').val(ui.item.employeur_nom);
                            $('#prenom').val('');
                            $('#datenaiss').val('');
                            $('#compte').val(ui.item.compte);
                            $('#bqcle_creancier').val(ui.item.banque_id);
                            $('.selectpicker').selectpicker('refresh');
                        },
                        close: function(event, ui) {
                            
                        }
                    });    
                });
            </script>
        </div>

        <div id='creancier_creancier'>
            <div class="col-xs-6">
                {!! Form::label('creancier_cre', 'Créancier (Employeur') !!}
                {!! Form::text('creancier_cre', null, ['id'=>'creancier_cre','placeholder' => "Numéro de créancier"
                    , 'class' => 'form-control']) !!}
            </div>
                <script type="text/javascript">
                $(function() {
                    $("#creancier_cre").autocomplete({
                        source: "{!! url('auto_creancier_creancier') !!}",
                        minLength: 2,
                        select: function(event, ui) {
                            $('#num_creancier').val(ui.item.creancier_id);
                            $('#nom').val(ui.item.creancier_nom);
                            $('#prenom').val(ui.item.prenom);
                            var datenaiss=ui.item.datenaiss;
                            if(datenaiss.length>=10) {
                                //MEF de la date de naissance
                                var annee=datenaiss.substr(0,4);
                                var mois=datenaiss.substr(5,2);
                                var jour=datenaiss.substr(8,2);
                            }
                            $('#datenaiss').val(jour+"/"+mois+"/"+annee);
                            $('#compte').val(ui.item.compte);
                            $('#bqcle_creancier').val(ui.item.banque_id);
                            $('.selectpicker').selectpicker('refresh');
                        },
                        close: function(event, ui) {
                            
                        }
                    });    
                });
            </script>
        </div>
    </div>      
    
        
    <div class="form-group">
        <div class="col-xs-6">
            {!! Form::label('nom', 'Nom') !!}
            {!! Form::text('nom', null, ['id'=>'nom', 'class' => 'form-control identifiants']) !!}
        </div>

        <div class="col-xs-3">
            {!! Form::label('prenom', 'Prénom') !!}
            {!! Form::text('prenom', null, ['id'=>'prenom','class' => 'form-control identifiants']) !!}
        </div>

        <div class="col-xs-3">
            {!! Form::label('datenaiss', 'DateNaiss.') !!}
            <div class='input-group date' id='datepicker_datenaiss'>
                {!! Form::text('datenaiss', '', ['id'=>'datenaiss','placeholder' => 'Date', 'class' => 'form-control']) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                <script type="text/javascript">
                    $(function () {
                        $('#datepicker_datenaiss').datepicker({
                            format: "dd/mm/yyyy",
                            language: "fr",
                            autoclose: true
                        });
                    });
                </script>
            </div>
        </div>
    </div>



    <div class="form-group">

        <div class="col-xs-2">
            {!! Form::label('idmandat', 'N°mandat') !!}
            {!! Form::text('idmandat', (isset($mandat)?$mandat->id:null), 
            ['placeholder' => "Numéro de mandat", isset($mandat)?'readonly':'','class' => 'form-control']) !!}
        </div>

        <div class="col-xs-8">
            {!! Form::label('idimp_mdt', 'N°Imputation') !!}
            {!! 
            Form::select(
                'idimp_mdt',
                $imputations,
                $imputation,
                ['id'=>'typepmt','class' => 'selectpicker','data-width' => "100%"]
            ) 
                
            !!}
        </div>
    </div>

    <div class="form-group">
        <div class="col-xs-3">
            {!! Form::label('bqcle_creancier', 'Banque') !!}
            {!! Form::select(
                'bqcle_creancier',
                array(""=>" ")+DB::table('banques')->where('active','=','1')->orderby(db::raw("nom"))->pluck(db::raw("CONCAT(id,' ',nom) as nom"), 'id')->toArray(),
                '',
                ['id'=>'bqcle_creancier',
                    'class' => 'selectpicker',
                    'data-width' => "100%"
                ]) 
            !!}
        </div>
        <div class="col-xs-3">
            {!! Form::label('compte', 'Compte') !!}
            {!! Form::text('compte', null, ['placeholder' => "Compte", 'class' => 'form-control']) !!}
        </div>
        <div class="col-xs-2">
            {!! Form::label('montant', 'Montant') !!}
            {!! Form::text('montant', null, ['placeholder' => "Montant", 'class' => 'form-control']) !!}
        </div>
        <div class="col-xs-3">
            {!! Form::label('typepmt', 'Type de paiement') !!}
            {!! 
            Form::select(
                'typepmt',
                [''=>' ','BAN'=>'Banque','ESP' => 'Espèces','CHQ' => 'Chèque','TRE' => 'Trésor'],
                null,
                ['id'=>'typepmt','class' => 'selectpicker','data-width' => "100%"]
            ) 
                
            !!}
        </div>
    </div>


    <div class='form-group'>
        <div class="col-xs-9">
        {!! Form::label('obs', 'Observations') !!}
        {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']) !!}
        </div>
    </div>


    <div class='form-group'>
        <div class="col-sm-9">
            {!! Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>


    {!! Form::close() !!}
</div>
 

@stop

