@extends('layouts.master')
 
@section('title') Mise à jour d'un Creancier @stop
 
@section('content')
 
<div class="col-lg-max col-lg-offset-1">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h2><i class='fa fa-banque'></i> Mise à jour du Creancier {!! str_pad($creancier->id, 6, "0", STR_PAD_LEFT) !!}</h2>
 
    {!! Form::model($creancier, ['creancier' => 'form'
        , 'url' => '/tiers/creanciers/' . $creancier->id, 'method' => 'PUT', 'class' => 'form-horizontal']) !!}
    {!! Form::hidden('mode_frame',(isset($mandat)?true:false),['id'=>'mode_frame']); !!}

    <div class="form-group">
        <div class="col-xs-2">
            {!! Form::label('num_creancier', 'N°Créancier') !!}
            {!! Form::text('num_creancier', $creancier->num_creancier, ['placeholder' => "Numéro de créancier", 'class' => 'form-control']) !!}
        </div>

        <div class="col-xs-4">
            {!! Form::label('nom', 'Nom') !!}
            {!! Form::text('nom', $creancier->nom, ['placeholder' => "Nom", 'class' => 'form-control']) !!}
        </div>

        <div class="col-xs-2">
            {!! Form::label('prenom', 'Prénom') !!}
            {!! Form::text('prenom', $creancier->prenom, ['placeholder' => "Prénom", 'class' => 'form-control']) !!}
        </div>

        <div class="col-xs-3">
            {!! Form::label('datenaiss', 'Date de naissance') !!}
            <div class='input-group date' id='datepicker_datenaiss'>
                {!! Form::text('datenaiss', $creancier->datenaiss, ['placeholder' => 'Date', 'class' => 'form-control']) !!}
                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                <script type="text/javascript">
                    $(function () {
                        $('#datepicker_datenaiss').datepicker({
                            format: "dd/mm/yyyy",
                            language: "fr",
                            autoclose: true
                        });
                    });
                </script>
            </div>
        </div>
    </div>



    <div class="form-group">
        <div class="col-xs-2">
            {!! Form::label('idmandat', 'N°mandat') !!}
            {!! Form::text('idmandat', (isset($mandat)?$mandat->id:null), 
            ['placeholder' => "Numéro de mandat", isset($mandat)?'readonly':'','class' => 'form-control']) !!}
        </div>
        <div class="col-xs-8">
            {!! Form::label('idimp_mdt', 'N°Imputation') !!}
            {!! 
            Form::select(
                'idimp_mdt',
                $imputations,
                $creancier->idimp_mdt,
                ['id'=>'typepmt','class' => 'selectpicker','data-width' => "100%"]
            ) 
                
            !!}
        </div>
    </div>


    <div class="form-group">
        <div class="col-xs-4">
            {!! Form::label('bqcle_creancier', 'Banque') !!}
            {!! Form::select(
                'bqcle_creancier',
                array(""=>" ")+DB::table('banques')->orderby(db::raw("nom"))->pluck(db::raw("CONCAT(id,' ',nom) as nom"), 'id')->toArray(),
                $creancier->bqcle_creancier,
                ['id'=>'bqcle_creancier',
                    'class' => 'selectpicker',
                    'data-width' => "100%"
                ]) 
            !!}
        </div>
        <div class="col-xs-3">
            {!! Form::label('compte', 'Compte') !!}
            {!! Form::text('compte', $creancier->compte, ['placeholder' => "Compte", 'class' => 'form-control']) !!}
        </div>
        <div class="col-xs-2">
            {!! Form::label('montant', 'Montant') !!}
            {!! Form::text('montant', $creancier->montant, ['placeholder' => "Montant", 'class' => 'form-control']) !!}
        </div>
        <div class="col-xs-2">
            {!! Form::label('typepmt', 'Type de paiement') !!}
            {!! 
            Form::select(
                'typepmt',
                ['BAN'=>'Banque','ESP' => 'Espèces','CHQ' => 'Chèque','TRE' => 'Trésor'],
                $creancier->typepmt,
                ['class' => 'selectpicker','data-width' => "100%"]
            ) 
                
            !!}
        </div>
    </div>


    <div class='form-group'>
        <div class="col-xs-8">
        {!! Form::label('obs', 'Observations') !!}
        {!! Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']) !!}
        </div>
    </div>


    <div class="col-sm-9">
        <div class='form-group'><br/>
            {!! Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']) !!}
        </div>
    </div>
    {!! Form::close() !!}
</div>
 

@stop