@include('forms.fbncheader')
@include('forms.fdatatables')


<div style="background-color:rgba(46,139,87,.2);"  
    class="col-lg-max col-lg-offset-1 container-fluid">

    <div style="padding-left:0px" class="col-lg-max">
         <div class="row" style="">   
            <div class="col-xs-1" style="padding-left:0px;">
               {!! Html::image("img/creancier.png", 
                    "Mandatements", array( 'width'=>'100%',
                        "style"=>"padding:4px" ))
                !!} 
            </div>
            <div class="col-xs-10" style="padding-left:0px;">
                <h1 style="margin-top:2px;">
                    Créanciers
                </h1>
            </div>
        </div>

        <div class="row col-xs-2">
            {!! Form::label('annes', 'Années du mandat :' ) !!}
            {!! Form::select('exercice',$exercices,$exercice,
                [
                    'id' => 'exercice_id','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;'
                ]
            ) 
            !!}
            <script>
                $(document).ready(function() {
                    $('#exercice_id').on('change', function() {
                        location.href="{!! url('/tiers/creanciers_annee/') !!}/"
                            +$('#exercice_id').val();
                    });
                });
            </script>
        </div>
    </div>

      
             
    <div class='col-lg-max' style="padding-top:5px">
        <div class="">
            <table id="_table" style="background-color:white" 
                class="table table-striped table-bordered table-hover" width="100%">
                <thead>
                    <tr>
                        <th width='1%' nowrap>Id</th>
                        <th width='1%' nowrap>N°Creancier</th>
                        <th >Nom</th>
                        <th width='1%'>Date de naissance</th>
                        <th width='1%'>banque</th>
                        <th width='1%'>Compte</th>
                        <th width='1%'>Montant</th>
                        <th width='1%'>IdMandat</th>
                        <th width='1%'>DateMandat</th>
                        <!-- <th width='1%'>Observations</th> -->
                        <th width='1%'>TypePmt</th>
                        <th width='1%'>IdImputation</th>
                        <th width='1%'></th>
                    </tr>
                </thead>
     
                <tbody>
                    @foreach ($creanciers as $creancier)
                    <?php
                        $imputation=App\Models\Imputation::find($creancier->id);
                        $mandat=App\Models\Mandat::find($creancier->idmandat);
                    ?>
                    <tr class="clickable-row" data-href="{!! url('tiers/creanciers/'.$creancier->id) !!}">
                        <td style='color:lightgrey;'>{!! str_pad($creancier->id,5,'0',STR_PAD_LEFT) !!}</td>
                        <td>{!! str_pad($creancier->num_creancier,5,'0',STR_PAD_LEFT) !!}</td>
                        <td>
                            @if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                <a href="{!! url('tiers/creanciers/'.$creancier->id)!!}" 
                                    class="" style="margin-right: 3px;">
                            @endif
                            {!! $creancier->nomcomplet !!}
                            @if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                </a>
                            @endif 
                        </td>
                        <td align="center">{!! $creancier->datenaiss !!}</td>
                        <td>{!! $creancier->bqcle_creancier !!}</td>
                        <td>{!! $creancier->compte !!}</td>
                        <td>{!! $creancier->montant !!}</td>
                        <td>
                            @if($user->can("MDT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('mandatements/mandats/'.$creancier->idmandat)!!}" 
                                class="various fancybox.iframe " style="margin-right: 3px;">
                                {!! str_pad($creancier->idmandat,6,'0',STR_PAD_LEFT) !!}
                            </a>
                            @endif 
                        </td>
                        <td>{!! $mandat->date_sai !!}</td>
                        <!-- <td>{!! $creancier->obs !!}</td> -->
                        <td>{!! $creancier->typepmt !!}</td>
                        <td align="center">
                            @if($user->can("IMP_VISU") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('mandatements/imputations/'.$creancier->idimp_mdt)!!}" 
                                class="various fancybox.iframe " style="margin-right: 3px;">
                                {!! str_pad($creancier->idimp_mdt,6,'0',STR_PAD_LEFT) !!}
                            </a>
                            @endif 
                        <td>
                        @if($user->can("CRE_MAJ") || $user->HasRole("ADMINISTRATEUR"))
                            <a href="{!! url('tiers/creanciers/'.$creancier->id.'/edit') !!}" class="btn btn-info pull-left" style="margin-right: 3px;">Modifier</a>
                        @endif 
                        @if($user->can("CRE_SUP")|| $user->HasRole("ADMINISTRATEUR"))      
                            {!! Form::open(['url' => '/tiers/creanciers/' . $creancier->id, 'method' => 'DELETE']) !!}
                            {!! Form::submit('Supprimer', ['class' => 'btn btn-danger'])!!}
                            {!! Form::close() !!}
                        @endif 
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            @if($user->can("CRE_VISU") || $user->HasRole("ADMINISTRATEUR"))
                <script>
                //jQuery(document).ready(function($) {
                //    $(".clickable-row").click(function() {
                //        window.document.location = $(this).data("href");
                //    });
                //});
                </script>
            @endif
        </div>

    </div>
</div>

</body></html>

<script type="text/javascript">
    $(".various").fancybox({
        //maxWidth    : 800,
        //maxHeight   : 600,
        fitToView   : true,
        width       : '85%',
        height      : '70%',
        //autoSize    : true,
        //autoScale   : true,
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
    });
</script>

@include('forms.fdatatables_script')