@extends('layouts.master')
 
@section('title') Consultation d'un Creancier @stop
 
@section('content')
 

 @section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
@stop


<div class="col-lg-max col-lg-offset-1" style="{!! ($frame)?'margin-top:-30px':'' !!}">
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h2><i class='fa fa-banque'></i>Consultation du Creancier {!! str_pad($creancier->id, 6, "0", STR_PAD_LEFT) !!}</h2>
 
    {!! Form::model($creancier, ['creancier' => 'form'
        , 'url' => '/tiers/creanciers/' . $creancier->id, 'method' => 'PUT', 'class' => 'form-horizontal']) !!}

    <div class="tab-content">

        <div class="form-group">
            <div class="col-xs-2">
                {!! Form::label('num_creancier', 'N°Créancier') !!}
                {!! Form::text('num_creancier', $creancier->num_creancier, 
                ['readonly', 'class' => 'form-control']) !!}
            </div>

            <div class="col-xs-4">
                {!! Form::label('nom', 'Nom') !!}
                {!! Form::text('nom', $creancier->nom, ['readonly', 'class' => 'form-control']) !!}
            </div>

            <div class="col-xs-3">
                {!! Form::label('prenom', 'Prénom') !!}
                {!! Form::text('prenom', $creancier->prenom, ['readonly','class' => 'form-control']) !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('datenaiss', 'Date de naissance') !!}
                {!! Form::text('datenaiss', $creancier->datenaiss, ['readonly', 'class' => 'form-control']) !!}
            </div>
        </div>

        <fieldset value="Mandat">
            <legend>Mandat</legend>
            <div class="alert bg-danger">
                <div class="form-group bg-danger">
                    <div class="col-xs-2">
                        {!! Form::label('idmandat', 'N°Mandat') !!}
                        {!! Form::text('idmandat', $creancier->idmandat, ['readonly', 'class' => 'form-control']) !!}
                    </div>

                    <div class="col-xs-2">
                        {!! Form::label('date_sai', 'Date de mandat') !!}
                        {!! Form::text('date_sai', $mandat->date_sai, ['readonly', 'class' => 'form-control']) !!}
                    </div>

                    <div class="col-xs-1">
                        {!! Form::label('statut', 'Statut') !!}
                        {!! Form::text('statut', $mandat->statut, ['readonly', 'class' => 'form-control']) !!}
                    </div>

                
                    <div class="col-xs-6">
                        {!! Form::label('idimp_mdt', 'Imputation') !!}
                        {!! 
                        Form::select(
                            'idimp_mdt',
                            $imputations,
                            $creancier->idimp_mdt,
                            ['id'=>'typepmt','class' => 'selectpicker','data-width' => "100%","disabled"]
                        ) 
                            
                        !!}
                    </div>
                    <!--
                    <div class="col-xs-3" style="padding-top:20px">
                    <a href="{!! url('mandatements/mandats').'/'.$mandat->id !!}" class="btn btn-warning"
                        target="_blank">Consulter le Mandat</a>
                    </div>
                -->
                </div>
            </div>

        <fieldset>


        <fieldset value="Mandat">
            <legend>Règlement</legend>
            <div class="alert bg-success">
                <div class="form-group">
                    <div class="col-xs-3">
                        {!! Form::label('bqcle_creancier', 'Banque') !!}
                        {!! Form::select(
                            'bqcle_creancier',
                            array(""=>" ")+DB::table('banques')->orderby(db::raw("nom"))->pluck(db::raw("CONCAT(id,' ',nom) as nom"), 'id')->toArray(),
                            $creancier->bqcle_creancier,
                            ['id'=>'bqcle_creancier',
                                'class' => 'selectpicker',
                                'data-width' => "100%",'disabled'=>'disabled'
                            ]) 
                        !!}
                    </div>
                    <div class="col-xs-3">
                        {!! Form::label('compte', 'Compte') !!}
                        {!! Form::text('compte', $creancier->compte, 
                        ['readonly', 'class' => 'form-control']) !!}
                    </div>

                    <div class="col-xs-2">
                        {!! Form::label('montant', 'Montant') !!}
                        {!! Form::text('montant', $creancier->montant, 
                        ['readonly', 'class' => 'form-control']) !!}
                    </div>


                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::label('typepmt', 'Type de paiement') !!}
                            {!! 
                            Form::select(
                                'typepmt',
                                ['BAN'=>'Banque','ESP' => 'Espèces','CHQ' => 'Chèque','TRE' => 'Trésor'],
                                $creancier->typepmt,
                                ['class' => 'selectpicker','data-width' => "100%",'disabled']
                            ) 
                                
                            !!}
                        </div>
                    </div>
                </div>
            </div>
        </fieldset>



        <div class='form-group'>
            <div class="col-xs-7">
            {!! Form::label('obs', 'Observations') !!}
            {!! Form::textarea('obs', null, ['readonly','class' => 'form-control', 'rows'=>'2']) !!}
            </div>
        </div>

    </div>


    @if(!$frame)
    <div class="col-sm-9">
        <div class='form-group'><br/>
            <a href="{!! url('/tiers/creanciers') !!} ">
            {!! Form::button('Retour', ['class' => 'btn btn-warning']) !!}
            </a>
        </div>
    </div>
    @endif
    {!! Form::close() !!}
</div>
 

@stop

@section('scripts')
    {!! Html::script('js/jquery.fancybox.js') !!}

    <script type="text/javascript">
    $(document).ready(function() {        
        $(".various").fancybox({
            //maxWidth    : 800,
            //maxHeight   : 600,
            fitToView   : false,
            width       : '85%',
            height      : '85%',
            autoSize    : false,
            autoScale   : false,
            closeClick  : false,
            openEffect  : 'none',
            closeEffect : 'none'
        });


    });
    </script>
@stop