@extends('layouts.master')
@section('title')
    Consultation d'un Employeur
@stop
@section('styles')
    {!! Html::style('css/jquery.fancybox.css') !!} 
    {!! Html::style('css/jquery.fancybox-buttons.css') !!} 
    <!-- Datatable -->
    {!! Html::style('css/dataTables.bootstrap.css'); !!} 
    {!! Html::style('css/buttons.bootstrap.css'); !!} 
@stop

@section('content')
<div class='col-lg-10 col-lg-offset-1' style="margin-top:-20px">
    <h1><i class='fa fa-employeur'></i>Fiche Employeur <small>{!! $employeur->nom !!}</small></h1>
 
    {!! Form::model($employeur, ['employeur' => 'form', 'url' => '/tiers/employeurs/' . $employeur->id,  'class' => 'form-horizontal']) !!}

    <ul class="nav nav-tabs">
        <li class="active"><a href="#nom" data-toggle="tab">Nom - Statut</a></li>
        <li><a href="#employes" data-toggle="tab">Employes</a></li>
        <li><a href="#adresse" data-toggle="tab">Contact</a></li>
        <li><a href="#banque" data-toggle="tab">Banque</a></li>
        <li><a href="#cotisations" data-toggle="tab">Cotisations</a></li>
        <li><a href="#controles" data-toggle="tab">Contrôles</a></li>
    </ul>

    <script>
        $('#myTab a').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
        })

        $('a[data-toggle="tab"]').on('shown', function (e) {
        e.target // activated tab
        e.relatedTarget // previous tab
        })
    </script>

    <br/>
    <div class="tab-content">
        <!-- ------------------------------------- ONGLET NOM ------------------------------- -->
            <div class="tab-pane active" id="nom">

                <div class="col-md-12 bg-success">
                    <div class="form-group">
                        <div class="col-md-10">
                            {!! Form::label('nom', 'Nom') !!}
                            {!! Form::text('nom', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-4">
                            {!! Form::label('numrc', 'Numéro RC') !!}
                            {!! Form::text('numrc', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>

                        <!--
                        <div class="col-md-2">
                            {!! Form::label('nbsal', 'Nombre de salariés') !!}
                            {!! Form::text('nbsal', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                        -->

                        <div class="col-md-3">
                            <label for="nbsalcalc">Nb salariés <small>(au 1er Janvier)</small></label>
                            {!! Form::text('nbsalcalc', $employeur->NbEmployes, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>

                        

                        <div class="col-md-2">
                            {!! Form::label('statut', 'Statut') !!}
                            <br/>
                                {!! 
                                Form::select(
                                    'statut',
                                    App\Models\MyApp::STATUTS_ENTREPRISE,
                                    $employeur->statut,
                                    [
                                        'disabled','class' => 'selectpicker',
                                    ]
                                ) 
                            !!}
                        </div>
                    </div>  

                    <div class="form-group">
                        <div class="col-md-4">
                            {!! Form::label('date_deb', 'Début d\'activité') !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_deb'>
                                        {!! Form::text('date_deb', $employeur->date_deb, ['disabled' => 'true', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            {!! Form::label('date_fin', 'Fin d\'activité') !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_fin'>
                                        {!! Form::text('date_fin', $employeur->date_fin, ['disabled' => 'true', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-sm-9">
                        <div class='form-group'>
                            {!! Form::label('verrou', 'Verrou') !!}
                            {!! Form::checkbox('verrou', null, ['disabled' => 'true','class' => 'form-control']) !!}
                        </div>
                    </div>

                    <div class="col-md-9">
                            <div class='form-group'>
                                {!! Form::label('observation', 'Observations') !!}
                                {!! Form::textarea('observation', null, ['disabled' => 'true', 'class' => 'form-control', 'rows'=>'8']) !!}
                            </div>
                    </div>
                </div>
            </div>

        <!-- ------------------------------------- ONGLET EMPLOYES ------------------------------- -->
            <div class="tab-pane" id="employes">
                <div class="form-group">
                    <div class="col-md-12 bg-info" style="padding:14px">
                        <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th >Année</th>
                                    <th >Employé</th>
                                    <th class="sum" width='5%'>Jan</th>
                                    <th width='5%'>Fév</th>
                                    <th width='5%'>Mar</th>
                                    <th width='5%'>Avr</th>
                                    <th width='5%'>Mai</th>
                                    <th width='5%'>Jui</th>
                                    <th width='5%'>Jui</th>
                                    <th width='5%'>Aou</th>
                                    <th width='5%'>Sep</th>
                                    <th width='5%'>Oct</th>
                                    <th width='5%'>Nov</th>
                                    <th width='5%'>Déc</th>
                                </tr>
                            </thead>

                            <tbody>
                                @foreach ($salaires as $salaire)
                                <tr>
                                    <td>{!! $salaire->benum !!}</td>
                                    <td>{!! $salaire->annee !!}</td>
                                    <td nowrap>{!! $salaire->beneficiaire_nom !!}</td>
                                    <td nowrap align='right'>{!! $salaire->jan !!}</td>
                                    <td nowrap align='right'>{!! $salaire->fev !!}</td>
                                    <td nowrap align='right'>{!! $salaire->mar !!}</td>
                                    <td nowrap align='right'>{!! $salaire->avr !!}</td>
                                    <td nowrap align='right'>{!! $salaire->mai !!}</td>
                                    <td nowrap align='right'>{!! $salaire->jun !!}</td>
                                    <td nowrap align='right'>{!! $salaire->jui !!}</td>
                                    <td nowrap align='right'>{!! $salaire->aou !!}</td>
                                    <td nowrap align='right'>{!! $salaire->sep !!}</td>
                                    <td nowrap align='right'>{!! $salaire->oct !!}</td>
                                    <td nowrap align='right'>{!! $salaire->nov !!}</td>
                                    <td nowrap align='right'>{!! $salaire->dec !!}</td>
                                </tr>
                                @endforeach
                            </tbody>
                 
                        </table>
                    </div>


                    @if( $user->can("SAL_MAJ") || $user->HasRole("ADMINISTRATEUR") )
                    <a href="{!! url('recouvrement/salaire_annee/'.$employeur->id) !!}" 
                        class="btn btn-success" target="_blank"
                        style="margin-right: 3px;">Gestion des salaires</a>
                    @endif 
                </div>
            </div>


        <!-- ------------------------------------- ONGLET CONTACTS ------------------------------- -->
            <div class="tab-pane" id="adresse">
                <div class="col-md-12 bg-success" style="padding:14px">
                    <div class="form-group">
                        <div class="col-md-9">
                            {!! Form::label('adresse', 'Adresse') !!}
                            {!! Form::textarea('adresse', null, ['disabled' => 'true', 'class' => 'form-control', 'rows'=>'2']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-2">
                            {!! Form::label('cp', 'Code Postal') !!}
                            {!! Form::text('cp', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>

                        <div class="col-md-4">
                            {!! Form::label('district', 'District - Zone') !!}
                            {!! Form::text('district', $employeur->district, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>

                        <div class="col-md-4">
                            {!! Form::label('ile', 'Ile') !!}
                            {!! Form::text('ile', $employeur->ile_libelle, ['disabled' => 'true', 'class' => 'form-control']) !!}               
                        </div>
                    </div>
                </div>


                <div class="col-md-12 bg-info" style="padding:10px">
                    <legend>Contact 1 / Responsable</legend>
                    <div class="form-group">
                        <div class="col-md-4">
                            {!! Form::label('responsable', 'Nom') !!}
                            {!! Form::text('responsable', null, ['disabled' => 'true', 'class' => 'form-control'] )!!}
                        </div>

                        <div class="col-md-4">
                            {!! Form::label('email', 'Email') !!}
                            {!! Form::email('email', null, ['disabled' => 'true', 'class' => 'form-control'] )!!}
                        </div>

                        <div class="col-md-2">
                            {!! Form::label('tel', 'Téléphone') !!}
                            {!! Form::text('tel', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>

                        <div class="col-md-2">
                            {!! Form::label('fax', 'Fax') !!}
                            {!! Form::text('fax', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-md-12 bg-warning" style="padding:10px">
                    <legend>Contact 2</legend>
                    <div class="form-group">
                        <div class="col-md-4">
                            {!! Form::label('contact_nom', 'Nom') !!}
                            {!! Form::text('contact_nom', null, ['disabled' => 'true', 'class' => 'form-control'] )!!}
                        </div>

                        <div class="col-md-4">
                            {!! Form::label('contact_email', 'Email') !!}
                            {!! Form::email('contact_email', null, ['disabled' => 'true', 'class' => 'form-control'] )!!}
                        </div>

                        <div class="col-md-2">
                            {!! Form::label('contact_tel', 'Téléphone') !!}
                            {!! Form::text('contact_tel', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
            </div>


        <!-- ------------------------------------- ONGLET BANQUE ------------------------------- -->
            <div class="tab-pane" id="banque">
                <div class="col-md-12 bg-success" style="padding:14px">
                    <div class="form-group">
                        <div class="col-md-6">
                            {!! Form::label('banque_id', 'Banque') !!}
                            <div class="input-group">
                                <div class="input-group-addon" id="ref_banque">{!! $employeur->banque_id !!}</div>
                                    {!!Form::text('banque', $employeur->NomBanque, ['disabled' => 'true', 'class' => 'form-control']) !!}
                                </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-6">
                            {!! Form::label('compte', 'Compte') !!}
                            {!!Form::text('compte', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-6">
                            {!! Form::label('iban', 'IBAN') !!}
                            {!!Form::text('iban', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>
                
                    <div class="form-group">
                        <div class="col-md-2">
                            {!! Form::label('secteur', 'Secteur') !!}
                             {!!Form::text('secteur', $employeur->secteur, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>
                </div>
            </div>


        <!-- ------------------------------------- ONGLET COTISATIONS ------------------------------- -->
            <div class="tab-pane" id="cotisations">
              <div class="col-md-12 bg-info" style="padding:14px">
                    <div class="form-group">
                        <div class="col-xs-12">
                            {!! Form::label('mode_cotis', 'Mode de cotisation :&nbsp;&nbsp;&nbsp;') !!}
                            {!! Form::radio('mode_cotis', 'value1', ($employeur->mode_cotis == '1')) !!} Trimestrielles&nbsp;
                            {!! Form::radio('mode_cotis', 'value2', ($employeur->mode_cotis == '2'))!!} Mensuelles&nbsp;

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::label('der_cotis', 'Dernière&nbsp;cotisation') !!}
                            <div class="input-group">
                                {!! Form::text('der_cotis', null, ['disabled' => 'true','class' => 'form-control']) !!}
                                <div class="input-group-addon">CFP</div>
                            </div>
                        </div>

                        <div class="col-xs-2">
                            {!! Form::label('der_mois', 'Mois concerné') !!}
                            <div class="input-group">
                                <div class='input-group date' id='datepicker_der_mois'>
                                        {!! Form::text('der_mois', $employeur->der_mois, ['disabled' => 'true', 'class' => 'form-control']) !!}
                                </div>
                            </div>
                        </div>

                        <div class="col-xs-3">
                            {!! Form::label('soldei', 'Solde antérieur') !!}
                            <div class="input-group">
                            {!! Form::text('soldei', null, ['disabled' => 'true','class' => 'form-control']) !!}
                            <div class="input-group-addon">CFP</div>
                            </div>
                        </div>
                    </div>


                    <div class="form-group">
                        <div class="col-xs-2">
                            {!! Form::label('date_med', 'Dernière MED') !!}
                            <div class='input-group date' id='datepicker_date_med'>
                                    {!! Form::text('date_med', $employeur->date_med, ['disabled' => 'true', 'class' => 'form-control']) !!}
                            </div>
                        </div>

                        <div class="col-xs-2">
                            {!! Form::label('date_maj', 'Dernière MAJ') !!}
                            <div class='input-group date' id='datepicker_date_maj'>
                                    {!! Form::text('date_maj', $employeur->date_maj, ['disabled' => 'true', 'class' => 'form-control']) !!}
                            </div>
                        </div>

                        <div class="col-md-2">
                            {!! Form::label('date_cont', 'Date du contentieux') !!}
                            <div class='input-group date' id='datepicker_date_cont'>
                                    {!! Form::text('date_cont', $employeur->date_cont, ['disabled' => 'true', 'class' => 'form-control']) !!}
                            </div>
                        </div>

                        <div class="col-md-3">
                            {!! Form::label('nom_cont', 'Libellé') !!}
                            {!! Form::text('nom_cont', null, ['disabled' => 'true', 'class' => 'form-control']) !!}
                        </div>
                    </div>
              

                    <legend>Liste des cotisations (2 dernières années)</legend>
                    <div class="form-group" align="center">
                        <div class="table-responsive col-lg-12" style="">
                            <table id="_table_cotisation" style="background-color:white" class="table table-condensed table-striped table-bordered" width="100%" >
                                <thead>
                                    <tr>
                                        <th width='1%'>Exercice</th>
                                        <th width='10%'>Date</th>
                                        <th width='10%'>CLR</th> 
                                        <th width='10%'>CCPF</th>
                                        <th width='10%'>Débit</th>
                                        <th width='10%'>Crédit</th>
                                        <th width='10%'>Mois</th>
                                        <th width='1%'>Nb&nbsp;Mois</th>
                                        <th width='1%'>Bord.&nbsp;Pub</th>
                                        <th width='1%'>Bord.&nbsp;Pri</th>
                                        <th width='10%'>Date&nbsp;encais.</th>
                                        <th width='10%'>Date&nbsp;Dépôt.</th>
                                        <th width='50px'>&nbsp;</th>
                                    </tr>
                                </thead>
                     
                                <tbody>
                                    @foreach ($cotisations as $cotisation)
                                    <tr>
                                        <td align="center">{!! $cotisation->exercice !!}</td>
                                        <td align="center">{!! $cotisation->date !!}</td>
                                        <td align="right">{!! $cotisation->clr !!}</td>
                                        <td align="right">{!! $cotisation->ccpf !!}</td>
                                        <td align="right">{!! $cotisation->debit !!}</td>
                                        <td align="right">{!! $cotisation->credit !!}</td>
                                        <td align="center">{!! $cotisation->mois !!}</td>
                                        <td align="center">{!! $cotisation->nbmois !!}</td>
                                        <td>{!! $cotisation->bdx !!}</td>
                                        <td>{!! $cotisation->bdx_prive !!}</td>
                                        <td align="center">{!! $cotisation->encais_date !!}</td>
                                        <td align="center">{!! $cotisation->date_depot !!}</td>
                                        <td nowrap>
                                        @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                        <a href="{!! url('recouvrement/cotisations/'.$cotisation->id) !!}" 
                                            class="various fancybox.iframe btn btn-warning" 
                                            style="margin-right: 3px;">Détail</a>
                                        @endif  
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                     
                            </table>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <a href="javascript:" 
                            id='btn_ajout_enfant' 
                            onclick="$('#dialog-percotis').dialog( 'open' );return false;" 
                            class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Bordereau de cotisation</a>

                            <a href="{!! url('cotisations_attestation_regul/'.$employeur->id) !!}" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation de régularité</a>

                            <a href="{!! url('cotisations_attestation_pmtech/'.$employeur->id) !!}" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation de paiement échelonné</a>

                            <!--
                            <a href="{!! url('cotisations_attestation/'.$employeur->id) !!}" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation</a>
                        -->

                            <a href="{!! url('cotisations_attestation_simple/'.$employeur->id) !!}" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation simple</a>

                            <a href="{!! url('cotisations_attestation_cotisation/'.$employeur->id) !!}" 
                            id=''  class="btn btn-info" 
                            target="_blank">Attestation de Situation</a>
                        </div>
                    </div>
                </div>
            </div>  

        <!-- ------------------------------------- ONGLET CONTROLES ------------------------------- -->
            <div class="tab-pane" id="controles">
                <div class="col-md-12 bg-info" style="padding:14px">
                    <legend>Liste des controles</legend>
                    <div class="form-group">
                        <div class="table-responsive col-lg-12">
                            @if(count($controles)>0)
                            <table style="background-color:white" id="_table" class="table table-condensed table-striped table-bordered" width="90%" >
                                <thead>
                                    <tr>
                                        <th width='1%'>N°</th>
                                        <th width='1%'>Contrôle</th>
                                        <th width='10%'>Agent1</th>
                                        <th width='10%'>Agent2</th> 
                                        <th width='10%'>Validation</th>
                                        <th width='10%'>Observations</th>
                                        <th width='200px'>&nbsp</th>
                                    </tr>
                                </thead>
                     
                                <tbody>
                                @foreach ($controles as $controle)
                                <tr>
                                    <td style="color:grey">{!! $controle->id !!}</td>
                                    <td align="center">{!! $controle->date_cont !!}</td>
                                    <td align="center">{!! $controle->agent1 !!}</td>
                                    <td align="right">{!! $controle->agent2 !!}</td>
                                    <td align="right">{!! $controle->date_valid !!}</td>
                                    <td align="right">{!! $controle->observations !!}</td>
                                    <td nowrap>
                                    @if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR"))
                                        <a href="{!! url('recouvrement/controles/show_box/'.$controle->id) !!}" 
                                            class="various fancybox.iframe btn btn-warning" 
                                            style="margin-right: 3px;">Détail</a>
                                    @endif 
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @else
                            <h2><small><i>Aucun contrôle</i></small></h2>
                        @endif
                    </div>
                </div>
            </div>  
        </div>


        <div id="dialog-percotis" title="Période">
            {!! Form::label('per_cotis', 'Veuillez saisir la période de cotisation') !!}
            {!! Form::select('annee_cotis',$exercices,date('Y')-1,
                [
                    'id' => 'annee_cotis','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'
                ]) 
            !!}
            <br/><br/>
            {!! 
                Form::select(
                    'tri_cotis',[""=>"Choisissez un trimestre",
                        "T1"=>"1er trimestre","T2"=>"2e trimestre","T3"=>"3e trimestre","T4"=>"4e trimestre"],
                    "",
                    [   'id'=>'tri_cotis',
                        'class' => 'form-control selectpicker'
                        ,'data-width' => "100%",
                    ]
                )  
            !!}
            <br/><br/>
            {!! Form::text('per_cotis', null, ['placeholder' => 'Libellé de la période', 
                'class' => 'form-control','id'=>'per_cotis']) !!}
        </div>


        {!! Form::close() !!}
 
    </div>
</div>
@stop


@section('scripts')
    {!! Html::script('js/magicsuggest.js') !!}
    {!! Html::script('js/jquery.fancybox.js') !!}
    <!-- {!! Html::script('js/jquery.dataTables.editable.js') !!}  -->
    @include('tiers.employeurs.scripts_employeur');

    <!-- Datatable  -->
    {!! Html::script('js/jquery.dataTables.js'); !!}
    {!! Html::script('js/dataTables.bootstrap.js'); !!}

    <!-- Datatable Button --> 
    {!! Html::script('js/dataTables.buttons.js'); !!}
    {!! Html::script('js/buttons.bootstrap.js'); !!}
    {!! Html::script('js/buttons.html5.js'); !!}
    {!! Html::script('js/buttons.print.js'); !!}
    {!! Html::script('js/jszip.min.js'); !!}
    {!! Html::script('js/pdfmake.min.js'); !!}
    {!! Html::script('js/vfs_fonts.js'); !!}
    {!! Html::script('js/buttons.colVis.min.js'); !!}

    {!! Html::script('js/moment.min.js'); !!}
    {!! Html::script('js/datetime-moment.js'); !!}
@stop


