@extends('layouts.master')
 
@section('title') Nouvel enfant @stop
 
@section('content')
 
<div class='col-lg-10 col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h1><i class='fa fa-banque'></i> Nouvel enfant</h1>
 
    {!! Form::open(['enfant' => 'form', 'url' => '/tiers/enfants', 'class' => 'form-horizontal']) !!}
    {!! Form::hidden('mode_frame',(isset($beneficiaire)?true:false),['id'=>'mode_frame']); !!}


<div class="tab-content">

        <div class="form-group">
            <div class="col-md-4">
                    {!! Form::label('nom', 'NOM') !!}
                    {!! Form::text('nom', null, ['placeholder' => 'Nom', 'class' => 'form-control text-uppercase']) !!}
            </div>
            <div class="col-md-4">
                    {!! Form::label('prenom', 'PRENOM') !!}
                    {!! Form::text('prenom', null, ['placeholder' => 'Prénom', 'class' => 'form-control']) !!}
            </div>
        </div>




        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('datenais', 'DATE DE NAISSANCE') !!}
                <div class="input-group">
                    <div class='input-group date' id='datepicker_datenaiss'>
                            {!! Form::text('datenais', '', ['placeholder' => 'Date de naissance', 'class' => 'form-control']) !!}
                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_datenaiss').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('sexe', 'SEXE') !!}
                <br/>
                {!! Form::select(
                        'sexe',
                        ['M'=>'Masculin','F' => 'Feminin'],
                        null,['class' => 'selectpicker']) 
                !!}
            </div>

            <div class="col-md-2">
                {!! Form::label('certif', 'Certificat') !!}
                <br/>
                {!! Form::select(
                        'certif',
                        ['0' => '0', '1' => '1', '2' => '2', '3' => '3', '4' => '4', '9' => '9'],
                        null,['class' => 'selectpicker']) 
                !!}
            </div>
        </div>

       
    <br/>
   <fieldset>
       <legend>Parents / Responsables</legend>

         <div class="form-group">
                <div class="col-md-4">
                    {!! Form::label('responsable', 'Responsable') !!}
                    <div class="input-group">
                        {!! Form::text('responsable',
                            (isset($beneficiaire)?$beneficiaire->nom_complet:null), 
                            ['placeholder' => 'Responsable', 'id' => 'responsable'
                            , 'class' => 'form-control'
                            , isset($beneficiaire)?'readonly':'' ,
                            ])
                            !!}
                        <div class="input-group-addon" id='parents1_addon'>
                            {!! (isset($beneficiaire)?$beneficiaire->id:null) !!}
                        </div>
                    </div>
                    {!! Form::hidden('parents1', (isset($beneficiaire)?$beneficiaire->id:null), ['id' => 'parents1']) !!}
                </div>

                <div class="col-md-4">
                    {!! Form::label('compte_p', 'Compte du responsable') !!}
                    {!!  Form::text('compte_p', null, ['placeholder' => 'Compte du responsable', 'class' => 'form-control']) !!}
                </div>
         </div>

        <br/>
         <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('conjoint', 'Conjoint') !!}
                <div class="input-group">
                    {!!Form::text('conjoint', null, ['placeholder' => 'Conjoint', 'class' => 'form-control']) !!}
                    <div class="input-group-addon" id='parents2_addon'></div>
                </div>
                {!! Form::hidden('parents2', null, ['id' => 'parents2']) !!}
            </div>

            <div class="col-md-4">
                {!! Form::label('compte_m', 'Compte du conjoint') !!}
                {!!  Form::text('compte_m', null, ['placeholder' => 'Compte du conjoint', 'class' => 'form-control']) !!}
            </div>
        </div>
    </fieldset>


         <div class="form-group">
            <div class="col-md-4">
                {!! Form::label('verrou', 'VERROU') !!}
                {!! Form::checkbox('verrou', null, ['class' => 'form-control']) !!}
            </div>
        </div>


    <br/>
   <fieldset>
       <legend>Observations</legend>
         <div class="form-group">
            <div class="col-md-8">
                    {!!  Form::textarea('obs', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'3']) !!}
            </div>
        </div>
    </fieldset>
 </div>   



<br/>

    <div class='form-group'>
        {!! Form::submit('Enregistrer', ['class' => 'btn btn-primary','id'=>'enregistrer']) !!}
    </div>
 
    {!! Form::close() !!}
 
</div>


<script type="text/javascript">

        $(function() {

            $("#responsable").autocomplete({
                source: "{!! url('auto_responsable') !!}",
                minLength: 2,
                select: function(event, ui) {
                    $('#responsable').val(ui.item.value);
                    $('#parents1').val(ui.item.id);
                    $('#parents1_addon').html(ui.item.id);
                },
                close: function(event, ui) {
                    //alert('a');
                }
            });    
        });


        $(function() {
            $("#conjoint").autocomplete({
                source: "{!! url('auto_responsable') !!}",
                minLength: 2,
                select: function(event, ui) {
                    $('#conjoint').val(ui.item.value);
                    $('#parents2').val(ui.item.id);
                    $('#parents2_addon').html(ui.item.id);
                },
                close: function(event, ui) {
                    
                }
            });    
        });


</script>

@stop