@extends('layouts.master')
 
@section('title') Mise à jour enfant  @stop
 
@section('content')
 
<div class='col-lg-8 col-lg-offset-1'>
 
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
 
    <h2><i class='fa fa-user'></i>Enfant : {!! $enfant->nom_complet !!}</h2>
 
    {!! Form::model($enfant, ['enfant' => 'form', 'url' => '/tiers/enfants/' . $enfant->id, 'method' => 'PUT', 'class' => 'form-horizontal']) !!}
    {!! Form::hidden('mode_frame',(isset($beneficiaire)?true:false),['id'=>'mode_frame']); !!}

    <div class="tab-content">
        <br/>
        <div class='form-group'>
            <div class="col-xs-3">
                {!! Form::label('id', "N°".str_pad($enfant->id, 6, "0", STR_PAD_LEFT)) !!}
                </div>
            </div>
         </div>

        <div class='form-group'>
            <div class="col-xs-4">
                {!! Form::label('nom', 'NOM') !!}
                {!! Form::text('nom',null, [
                    'class' => 'form-control', 'placeholder'=>'Nom','readonly'=>'true']) !!}
            </div>

            <div class="col-xs-4">
                {!! Form::label('prenom', 'PRENOM') !!}
                {!!Form::text('prenom', null, [
                    'class' => 'form-control', 'placeholder'=>'Prénom','readonly'=>'true']) !!}
            </div>
        </div>

        <div class='form-group'>
            <div class="col-xs-3">
                {!! Form::label('datenais', 'Date de naissance') !!}
                <div class='input-group date' id='datepicker_datenais'>
                    {!! Form::text('datenais', $enfant->datenais, 
                        ['placeholder' => 'Date de naissance', 'class' => 'form-control','readonly'=>'true']) !!}
                </div>
            </div>


            <div class="col-xs-3">
            {!! Form::label('lieunaiss', 'Lieu de naissance') !!}
            {!!Form::text('lieunaiss', null, [
                'class' => 'form-control', 'placeholder'=>'Lieu de naissance','readonly'=>'true']) !!}
            </div>

            <div class="col-xs-2">
                {!! Form::label('sexe', 'Sexe') !!}
                {!! 
                Form::select(
                    'sexe',
                    ['M'=>'Masculin','F' => 'Feminin'],
                    $enfant->sexe,
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%",'disabled'=>'true'
                    ]
                ) 
                    
                !!}
            </div>
        </div>

        <div class='form-group'>
            <div class="col-xs-1">
            {!! Form::label('certif', 'Certificat') !!}
            <br/>
                {!! 
                Form::select(
                    'certif',
                    ['0' => '0', '1' => '1', '2' => '2', '3' => '3', '4' => '4', '9' => '9'],
                    $enfant->certif,
                    [
                        'class' => 'selectpicker'
                        ,'data-width' => "100%",'disabled'=>'true'
                    ]
                ) 
            !!}
            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-4">
                {!! Form::label('verrou', 'Verrou  ') !!}
                {!! Form::checkbox('verrou', null, ['class' => 'form-control','readonly'=>'true']) !!}
            </div>
        </div>


        <fieldset style="padding:5px;">
            <legend class="h2" style="margin:0px;"><small>Responsable parental</small></legend>
            <div class="form-group bg-success" style="padding:10px;margin:5px;">
                <div class="col-xs-2">
                {!! Form::label('parents1', 'Réf.') !!}
                {!! Form::text('parents1',null, [
                    'class' => 'form-control','placeholder' => 'Référence','readonly'=>'true']) !!}
                </div>
                <div class="col-xs-5">
                {!! Form::label('nom_parent1', 'Nom') !!}
                {!! Form::text('nom_parent1',null, [
                    'class' => 'form-control', 'readonly'=>'true','readonly'=>'true']) !!}
                </div>

                <div class="col-xs-3">
                {!! Form::label('compte_p', 'Compte bancaire') !!}
                {!! Form::text('compte_p',null, [
                    'class' => 'form-control','placeholder' => 'Compte bancaire','readonly'=>'true']) !!}
                </div>
            </div>
        </fieldset>
          

        <fieldset style="padding:5px;">
            <legend class="h2" style="margin:0px;"><small>Conjoint</small></legend>
            <div class="form-group bg-info" style="padding:10px;margin:5px;">
                <div class="col-xs-2">
                    {!! Form::label('parents2', 'Réf.') !!}
                    {!! Form::text('parents2',null, [
                        'class' => 'form-control','placeholder' => 'Référence','readonly'=>'true']) !!}
                </div>
                <div class="col-xs-5">
                    {!! Form::label('nom_parent2', 'Nom') !!}
                    {!! Form::text('nom_parent2',null, [
                        'class' => 'form-control', 'readonly'=>'true']) !!}
                </div>

                <div class="col-xs-3">
                {!! Form::label('compte_m', 'Compte bancaire') !!}
                {!! Form::text('compte_m',null, [
                    'class' => 'form-control','placeholder' => 'Compte bancaire','readonly'=>'true']) !!}
                </div>
            </div>
        </fieldset>

            <br/>

        <fieldset style="padding:5px;">
            <legend class="h2" style="margin:0px;"><small>Observations</small></legend>
            <div class="form-group" style="padding:10px;margin:5px;">

                {!! Form::textarea('obs', null, [
                    'class' => 'form-control', 'rows'=>'2','placeholder'=>'Observations','readonly'=>'true']) !!}
            </div>
        </fieldset>


     </div>    


     <div class='form-group'>
        <div class="col-sm-9 col-lg-offset-1">
        {!! Form::submit('Fermer', ['class' => 'btn btn-primary','id'=>'close']) !!}
        </div>
    </div>

    {!! Form::close() !!}
 
</div>
 
 <br> <br>



@stop