<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/logout', 'App\Http\Controllers\Auth\LoginController@logout');
Auth::routes();

//Route::get('change_profil',array('as' => 'change_profile' , 'uses' => 'Auth\ChangeProfilController@newprofil'));
//Route::put('change_profil',array('as' => 'change_profile' , 'uses' => 'Auth\ChangeProfilController@changeprofil'));

Route::get('accueil', array('as' => 'accueil', 'uses'=>'App\Http\Controllers\HomeController@index')); // Liste formulaires


Route::get('/', function () {
    return view('welcome');
});


Route::get('/action/newprofil', 'App\Http\Controllers\RolesController@newprofil');
Route::get('/action/profil_origine', 'App\Http\Controllers\RolesController@origine_profil');
Route::post('/action/changeprofil', 'App\Http\Controllers\RolesController@changeprofil');


Route::get('/home', 'App\Http\Controllers\HomeController@index')->name('home');

Route::get('accueil_spec/{type}', array('as' => 'accueil_spec', 'uses'=>'App\Http\Controllers\HomeController@index_spec'));


/* ***** PARAMETRES ***** */
Route::resource('/param/parametres', 'App\Http\Controllers\ParametresController');
Route::resource('/param/benef_statuts', 'App\Http\Controllers\BenefstatutsController');
Route::resource('/param/benef_types', 'App\Http\Controllers\BeneftypesController');

/* ***** ACCES / USERS / ROLES / PERMISSIONS ***** */
Route::resource('/acces/users', 'App\Http\Controllers\UsersController');
Route::delete('/acces/users/delete/{id}','App\Http\Controllers\UsersController@destroy');
Route::resource('/acces/roles', 'App\Http\Controllers\RolesController');
Route::get('/acces/roles_det', 'App\Http\Controllers\RolesController@index_det');
Route::resource('/acces/permissions', 'App\Http\Controllers\PermissionsController');
Route::get('/acces/roles_tableau', 'App\Http\Controllers\RolesController@index_tableau');
Route::get('/acces/role_tableau_filtre/{id}', 'App\Http\Controllers\RolesController@index_tableau');

/* ***** BENEFICIAIRES ***** */
Route::get('/tiers/beneficiaires/limit/{param?}', 'App\Http\Controllers\BeneficiairesController@index');
Route::resource('/tiers/beneficiaires', 'App\Http\Controllers\BeneficiairesController');

Route::get('/tiers/beneficiaires_statut/{beneficiaire_id}/{type_liste}', 'App\Http\Controllers\BeneficiairesController@show_s');
Route::get('/tiers/beneficiaires_statut/{beneficiaire_id}/{type_liste}/edit', 'App\Http\Controllers\BeneficiairesController@edit_s');
Route::get('/tiers/beneficiaires_statut/{beneficiaire_id}/{type_liste}/{onglet_actif?}/edit', 'App\Http\Controllers\BeneficiairesController@edit_s');


Route::get('auto_responsable', 'App\Http\Controllers\BeneficiairesController@autocomplete_conjoint');
Route::get('auto_conjoint', 'App\Http\Controllers\BeneficiairesController@autocomplete_conjoint');


/* ***** ENFANTS ***** */
Route::resource('/tiers/enfants', 'App\Http\Controllers\EnfantsController');
Route::get('/tiers/enfants/limit/{param}', 'App\Http\Controllers\EnfantsController@index');
Route::get('/tiers/enfants/limit/enfants/create', 'App\Http\Controllers\EnfantsController@create');

Route::get('enfants_create_avec_benef/{beneficiaire_id}', 'App\Http\Controllers\EnfantsController@create_avec_benef');
Route::get('enfants_edit_avec_benef/{id}/{beneficiaire_id}', 'App\Http\Controllers\EnfantsController@edit_avec_benef');
Route::get('/tiers/enfants_in/{param}', 'App\Http\Controllers\EnfantsController@index_in');
Route::post('/tiers/enfants_in/{param}', 'App\Http\Controllers\EnfantsController@index_in');


/* ***** EMPLOYEURS ***** */
Route::resource('/tiers/employeurs', 'App\Http\Controllers\EmployeursController');
Route::get('/tiers/employeurs_statut/{statut}', 'App\Http\Controllers\EmployeursController@index');
Route::get('/autocomplete_employeur', array('as' => 'autocomplete_employeur', 'uses'=>'App\Http\Controllers\EmployeursController@autocomplete_employeur'));



/* ***** BANQUES ***** */
Route::resource('/tiers/banques', 'App\Http\Controllers\BanquesController');
Route::get('/autocomplete_banque', array('as' => 'autocomplete_banque', 'uses'=>'App\Http\Controllers\BanquesController@autocomplete_banque'));

/* ***** SECTEURS ***** */
Route::resource('/param/secteurs', 'App\Http\Controllers\SecteursController');
Route::get('/param/secteurs_edition', 'App\Http\Controllers\Editions\EditionSecteur@secteur_entreprise');


/* ***** COTISATIONS ***** */
Route::resource('recouvrement/cotisations', 'App\Http\Controllers\CotisationsController');
Route::get('recouvrement/cotisation_annee/{employeur_id?}/{exercice?}/{affiche_tout?}', 'App\Http\Controllers\CotisationsController@index');
Route::post('/recouvrement/cotisation_saisie_filtre', 'App\Http\Controllers\CotisationsController@index_filtre');



Route::get('recouvrement/cotisation_employe/{employeur_id}', 'App\Http\Controllers\CotisationsController@index_employeur');
Route::get('recouvrement/cotisations/create/{employeur_id}', 'App\Http\Controllers\CotisationsController@create');
Route::get('recouvrement/cotisations/delete/{cotisation_id}/{exercice?}', 'App\Http\Controllers\CotisationsController@destroy');
Route::get('recouvrement/cotisations/show_box/{cotisation_id}', 'App\Http\Controllers\CotisationsController@show_box');
Route::get('recouvrement/cotisations_encours', 'App\Http\Controllers\CotisationsController@index_encours');
Route::get('recouvrement/cotisations_encaiss/{cotisation_id}', 'App\Http\Controllers\CotisationsController@encaissement');
Route::put('recouvrement/cotisations_encaiss/{cotisation_id}', 'App\Http\Controllers\CotisationsController@update_encaiss');
Route::get('recouvrement/cotisations_encaissees/{exercice?}', 'App\Http\Controllers\CotisationsController@index_encaissees');
Route::get('recouvrement/cotisation_encaissees_annee/{exercice?}', 'App\Http\Controllers\CotisationsController@index_encaissees');
Route::post('recouvrement/cotisation_encaissees_annee', 'App\Http\Controllers\CotisationsController@index_encaissees_post');
//
Route::get('recouvrement/nouveau_reglement/{employeur_id?}', 'App\Http\Controllers\CotisationsController@index');
Route::get('recouvrement/cotisations_employeur_exercice/{employeur_id}/{exercice?}/{date?}','App\Http\Controllers\CotisationsController@index_cotis_emp_exercice');
Route::get('recouvrement/cotisations_employeur_cumule/{employeur_id}/{exercice?}/{date?}','App\Http\Controllers\CotisationsController@index_cotis_emp_cumule');



Route::get('cotisations_bordereau_cotisation/{employeur_id}/{annee}/{trimestre}/{periode?}', 'App\Http\Controllers\Editions\EditionsCotisationsBordereau@bordereau');
Route::get('cotisations_attestation_regul/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttRegu@attestation_regul');
Route::get('cotisations_attestation_pmtech/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttPmtEch@attestation_pmtech');
Route::get('cotisations_attestation/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAtt@attestation_normale');
Route::get('cotisations_attestation_simple/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttSimple@attestation_simple');
Route::get('cotisations_attestation_cotisation/{employeur_id}', 'App\Http\Controllers\Editions\EditionsCotisationsAttSituation@attestation_situation');
Route::get('cotisations_recu/{cotisation_id}', 'App\Http\Controllers\Editions\EditionsCotisationsRecu@recu');
Route::get('cotisations_ordre/{cotisation_id}', 'App\Http\Controllers\Editions\EditionsCotisationsOrdre@ordre');


//Reglements
Route::post('reglement_lettrage', 'App\Http\Controllers\CotisationsController@store_reglement_lettrage');
Route::post('reglement_simple', 'App\Http\Controllers\CotisationsController@store_reglement');
Route::get('reglement_pointage/{employeur_id?}/{exercice?}/{affiche_tout?}', 'App\Http\Controllers\CotisationsController@pointage');
Route::put('reglement_pointage/{employeur_id?}/{exercice?}/{affiche_tout?}', 'App\Http\Controllers\CotisationsController@lettrer');
Route::get('pointage_encaissement/{cotisation_id}', 'App\Http\Controllers\CotisationsController@encaissement_compta');


Route::get('recouvrement/reglement_create/{employeur_id?}/{exercice?}', 'App\Http\Controllers\CotisationsController@reglement_create');

Route::put('recouvrement/cotisations_lettrage/{employeur_id?}/{exercice?}/{cotisations?}', 'App\Http\Controllers\CotisationsController@lettrage_bef');

Route::get('recouvrement/cotisations_lettrage/{employeur_id?}/{exercice?}/{cotisations?}', 'App\Http\Controllers\CotisationsController@lettrage');



/* ***** SALAIRES ***** */
Route::get('recouvrement/salaire_employe/{beneficiaire_id}/{employeur_id}', 'App\Http\Controllers\SalairesController@index_beneficiaire_employeur');
Route::get('recouvrement/salaire_annee/{employeur_id?}/{beneficiaire_id?}/{exercice?}', 'App\Http\Controllers\SalairesController@index');
Route::get('recouvrement/salaires/create/{beneficiaire_id}/{employeur_id}', 'App\Http\Controllers\SalairesController@create');
Route::delete('recouvrement/salaires/{id}/{employeur_id?}/{beneficiaire_id?}/{exercice?}','App\Http\Controllers\SalairesController@destroy');
Route::get('salaire_secteurs_iframe/{secteur}/{date}', 'App\Http\Controllers\SalairesController@index_iframe_secteur');


Route::resource('recouvrement/salaires', 'App\Http\Controllers\SalairesController');
Route::get('/salaire/liquidation/{beneficiaire_id}', 'App\Http\Controllers\EditionsPrestationsController@salaire_liquidation');
Route::get('salaire_liquidation/{beneficiaire_id}', 'App\Http\Controllers\Editions\EditionSalaires@liquidation');
Route::get('salaire_imprime/{beneficiaire_id}', 'App\Http\Controllers\Editions\EditionSalaires@imprime_salaires');
Route::get('/salaire/liquidation_simulation/{beneficiaire_id}', 'App\Http\Controllers\EditionsPrestationsController@salaire_simulation_liquidation');
Route::post('/salaire/liquidation/{beneficiaire_id}', 'App\Http\Controllers\EditionsPrestationsController@salaire_simulation_liquidation');


/* ***** VERSEMENTS ***** */

/* Brouillon */
Route::get('versements_generation_b/{type}', 'App\Http\Controllers\VersementsBrouillonController@generation');
Route::post('versements_generation_b/{type}', 'App\Http\Controllers\VersementsBrouillonController@set_generation_brouillon');
Route::get('versements_encours/{type}', 'App\Http\Controllers\VersementsBrouillonController@index');

Route::resource('prestations/versements_brouillon', 'App\Http\Controllers\VersementsBrouillonController');
Route::post('prestations/versements_brouillon', 'App\Http\Controllers\VersementsController@update_brouillon');
Route::get('versements_brouillon_print/{type}', 'App\Http\Controllers\EditionsVersementsController@imprimer_brouillon');

Route::get('versements_export_fichier_complet/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier_complet');
Route::post('versements_export_fichier_complet/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier_complet');


Route::get('versements_export_fichier/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier');
Route::post('versements_export_fichier/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier');

Route::get('versements_export_fichier_BWF_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier_BWFTP');
Route::post('versements_export_fichier_BWF_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier_BWFTP');

Route::get('versements_export_fichier_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@index_export_fichier_TP');
Route::post('versements_export_fichier_TP/{type}/{num_imp}', 'App\Http\Controllers\Editions\ExportVersementsController@export_fichier_TP');

Route::get('versements_print/{type}/{num_imp}', 'App\Http\Controllers\EditionsVersementsController@imprimer_definitif');





/* RAZ */
Route::get('raz_rappel/{type}/{nbraz?}', 'App\Http\Controllers\VersementsRAZController@index');
Route::post('raz_rappel/{type}', 'App\Http\Controllers\VersementsRAZController@raz_rappel');

Route::get('maj_certificats_etrangers/{type}/{nbraz?}', 'App\Http\Controllers\VersementsRAZController@index_certificats_etrangers');
Route::get('maj_certificats/{type}/{nbraz?}/{etrangers?}', 'App\Http\Controllers\VersementsRAZController@index_certificats');
Route::post('maj_certificats/{type}', 'App\Http\Controllers\VersementsRAZController@maj_certificats');
Route::post('maj_certificats_etrangers/{type}', 'App\Http\Controllers\VersementsRAZController@maj_certificats_etrangers');
Route::get('maj_certificats_info/{type}/{etrangers?}', 'App\Http\Controllers\VersementsRAZController@info_certificats');


/* versements définitifs */
Route::get('versements/{type}/{num_imp?}', 'App\Http\Controllers\VersementsController@index');
Route::get('prestations/versement_employe/{employeur_id}', 'App\Http\Controllers\VersementsController@index_employeur');
Route::get('prestations/versement_annee/{employeur_id?}', 'App\Http\Controllers\VersementsController@index');
Route::get('alprestationsloc/versements/create/{employeur_id}', 'App\Http\Controllers\VersementsController@create');


//Historiqye fiche bénéficiaire
Route::get('versements_historique/{beneficiaire_id}', 'App\Http\Controllers\VersementsHGController@index');

Route::get('versements_imprime/{beneficiaire_id}', 'App\Http\Controllers\Editions\EditionVersements@imprime_versements');
Route::get('versements_generation_def/{type}', 'App\Http\Controllers\VersementsController@generation_definitive');
Route::post('versements_generation_def/{type}', 'App\Http\Controllers\VersementsController@set_generation_definitive');


//Réajustements
Route::get('retraites/reajustement', 'App\Http\Controllers\RetraitesController@reajustement_index');
Route::post('retraites/reajustement_simulation', 'App\Http\Controllers\RetraitesController@simulation_index');
Route::post('retraites/reajustement_validation', 'App\Http\Controllers\RetraitesController@validation');



/* ***** COMPTABIBILE ***** */
Route::resource('compta/plan', 'App\Http\Controllers\PlanController');
Route::get('/compta/plan_annee/{exercice?}', 'App\Http\Controllers\PlanController@index');
Route::get('compta_plan_visu/{plan_id}/{exercice?}', 'App\Http\Controllers\PlanController@show');
Route::resource('compta/journal', 'App\Http\Controllers\JournauxController');
Route::get('compta/journal_ltd/{exercice}/{compte}', 'App\Http\Controllers\JournauxController@index_ltd');
Route::get('compta/journal_compense/{list_ecritures?}', 'App\Http\Controllers\JournauxController@create_compense');

Route::get('compta/journal_exercice/{exercice}', 'App\Http\Controllers\JournauxController@index');
Route::get('api_get_budget_plan/{plan_id}', 'App\Http\Controllers\PlanController@api_get_budget');
Route::get('compta_plan/{categ}/{exercice?}','App\Http\Controllers\Editions\EditionPlan@Edition_plan');
Route::get('compta_grandlivre/{compte}/{exercice?}','App\Http\Controllers\Editions\EditionGrandLivre@Edition_grandlivre');
Route::get('auto_compte_compta', 'App\Http\Controllers\JournauxController@auto_compte_compta');

Route::get('compta/bilan/{categ}', 'App\Http\Controllers\BilansController@index');
Route::get('compta_bilan/{categ}/{exercice?}','App\Http\Controllers\Editions\EditionBilan@Edition_bilan');


Route::get('compta/compte_resultat/{categ?}','App\Http\Controllers\CompteResultatController@index');
Route::get('compta/tableau_amortissement/{categ?}','App\Http\Controllers\TableauAmortissementController@index');

/* ***** BORDEREAUX ***** */
Route::resource('editions_aidessociales', 'App\Http\Controllers\Editions\BordereauxAidesSociales');



Route::get('/alloc/versements_retraite', 'App\Http\Controllers\VersementsController@retraite');




/* Mandatements */
Route::resource('/mandatements/mandats', 'App\Http\Controllers\MandatsController');
Route::get('/mandatements/mandats_annee/{exercice?}', 'App\Http\Controllers\MandatsController@index');
Route::get('/mandatements/generation', 'App\Http\Controllers\MandatsController@index_generation');

// Transfert Trésor */
Route::get('mandatements_settransfert/{id}/{exercice?}', 'App\Http\Controllers\MandatsController@set_transfert');
Route::get('mandatements_unsettransfert/{id}/{exercice?}', 'App\Http\Controllers\MandatsController@unset_transfert');
Route::get('mandats_export_fichier_TP', 'App\Http\Controllers\Editions\ExportMandatsController@index_export_fichier_TP');
Route::post('mandats_export_fichier_TP', 'App\Http\Controllers\Editions\ExportMandatsController@export_fichier_TP');

//
Route::resource('/tiers/creanciers', 'App\Http\Controllers\CreanciersController');
Route::get('/tiers/creanciers_annee/{exercice?}', 'App\Http\Controllers\CreanciersController@index');
Route::get('creancier_show_frame/{creancier_id}', 'App\Http\Controllers\CreanciersController@show_frame');
Route::get('creancier_create_avec_mandat/{mandat_id}', 'App\Http\Controllers\CreanciersController@create_avec_mandat');
Route::get('creancier_edit_avec_mandat/{id}/{mandat_id}', 'App\Http\Controllers\CreanciersController@edit_avec_mandat');
Route::get('auto_creancier_beneficiaire', 'App\Http\Controllers\CreanciersController@autocomplete_creancier_beneficiaire');
Route::get('auto_creancier_employeur', 'App\Http\Controllers\CreanciersController@autocomplete_creancier_employeur');
Route::get('auto_creancier_creancier', 'App\Http\Controllers\CreanciersController@autocomplete_creancier_creancier');


Route::resource('/mandatements/imputations', 'App\Http\Controllers\ImputationsController');
Route::get('/mandatements/imputations_annee/{exercice?}', 'App\Http\Controllers\ImputationsController@index');
Route::get('imputations_show_frame/{imputation_id}', 'App\Http\Controllers\ImputationsController@show_frame');
Route::get('imputation_create_avec_mandat/{mandat_id}', 'App\Http\Controllers\ImputationsController@create_avec_mandat');
Route::get('imputation_edit_avec_mandat/{id}/{mandat_id}', 'App\Http\Controllers\ImputationsController@edit_avec_mandat');

//1-OK
Route::get('mandat_imputation/{mandat_id}/{imputation_id?}', 'App\Http\Controllers\Editions\EditionMandatImputation@mandat_imputation');
//2-OK
Route::get('mandat_ordre_pmt_imp/{mandat_id}/{imputation_id?}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatOrdrePmtImputation@mandat_ordre_pmt_imp');
Route::get('mandat_ordre_pmt_imp_nom/{mandat_id}/{nom_creancier?}', 'App\Http\Controllers\Editions\EditionMandatOrdrePmtImputation@mandat_ordre_pmt_imp_nom');

//3-OK
Route::get('mandat_mandat_pmt_imp/{mandat_id}/{imputation_id?}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatPaiement@mandat_mandat_pmt');

//4-A FAIRE
Route::get('mandat_bordereau_rglmt/{creancier_id}', 'App\Http\Controllers\Editions\EditionsMandatsBordereauRglmt@mandat_bordereau_rglmt');

//5-OK
Route::get('mandat_mandat_pmt_cre/{mandat_id}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatPaiement@mandat_mandat_pmt');

//6-A FAIRE
Route::get('mandat_mandat_annulation/{mandat_id}/{imputation_id?}/{creancier_id?}', 'App\Http\Controllers\Editions\EditionMandatAnnulation@mandat_mandat_annulation');



/* PAS OK */


/* ***** CONTROLE-RECOUVREMENT ***** */
Route::get('recouvrement/bordereaux/{annee?}/{bdx_id?}/{pupri?}', 'App\Http\Controllers\RecouvrementController@index_bordereaux');
Route::get('recouvrement/bordereaux_liste/{annee?}', 'App\Http\Controllers\RecouvrementController@index_bordereaux_liste');
Route::get('recouvrement/bordereaux_val/{type_val}/{bdx_id}/{type}/{annee}', 'App\Http\Controllers\RecouvrementController@valider');
Route::get('bordereaux_etat/{bdx_id}/{type}/{annee}', 'App\Http\Controllers\Editions\BordereauEtatRecapitulatif@impression_bordereau');
Route::get('recouvrement/rappels', 'App\Http\Controllers\RecouvrementController@index_rappel');
Route::get('recouvrement/emails', 'App\Http\Controllers\RecouvrementController@index_emails');
Route::get('recouvrement_showmails/{employeur_id}', 'App\Http\Controllers\RecouvrementController@show_emails');

Route::post('recouvrement_sendmail/{employeur_id}', 'App\Http\Controllers\RecouvrementController@sendmail');
Route::get('recouvrement_sendmail/{employeur_id}', 'App\Http\Controllers\RecouvrementController@saisie_email');
Route::get('recouvrement_email_sent/{employeur_id}', 'App\Http\Controllers\RecouvrementController@saisie_email');


Route::get('recouvrement/controle_employe/{employeur_id}', 'App\Http\Controllers\ControlesController@index_employeur');
Route::get('recouvrement/controle_annee/{employeur_id?}', 'App\Http\Controllers\ControlesController@index');
Route::get('recouvrement/controles/create/{employeur_id}', 'App\Http\Controllers\ControlesController@create');
Route::resource('recouvrement/controles', 'App\Http\Controllers\ControlesController');
Route::get('recouvrement/controles/show_box/{controle_id}', 'App\Http\Controllers\ControlesController@show_box');




/* CONTROLE UPLOAD FILES */
Route::get('recouvrement/controles/addpiece/{controle_id}', 'App\Http\Controllers\ControlesController@add_piece');
Route::post('/uploadfile','App\Http\Controllers\UploadFileController@showUploadFile');
Route::get('/upload/delete/{upload_id}', 'App\Http\Controllers\UploadFileController@destroy');

Route::get('recouvrement/med_prepa/{exercice?}', 'App\Http\Controllers\RecouvrementController@index_med');
Route::get('recouvrement/med_create/{employeur_id}', 'App\Http\Controllers\MedController@create');
Route::resource('recouvrement/med', 'App\Http\Controllers\MedController');
Route::get('recouvrement/med_print/{med_id}', 'App\Http\Controllers\Editions\EditionsRecouvrementMED@impression_med');

Route::get('recouvrement/reste_a_payer', 'App\Http\Controllers\RecouvrementController@index_resteapayer');
Route::get('recouvrement/reste_a_payer_annee/{exercice?}/{date_obs?}', 'App\Http\Controllers\RecouvrementController@index_resteapayer_annee');

Route::get('recouvrement/taxe_office/{exercice?}','App\Http\Controllers\RecouvrementTaxationController@index');


/* PARAMETRES */
Route::get('/param/importations', 'App\Http\Controllers\ImportationController@index');
Route::get('/param/hyperfile', 'App\Http\Controllers\ImportationController@index_hyper');
Route::post('/param/load_table', array('as'=>'param.load_table', 'uses' =>'App\Http\Controllers\ImportationController@load'));
Route::post('/param/load_odbc_table', array('as'=>'param.load_odbc_table', 'uses' =>'App\Http\Controllers\ImportationController@load_odbc'));
Route::post('/param/load_txt_table', array('as'=>'param.load_txt_table', 'uses' =>'App\Http\Controllers\ImportationController@load_txt'));

Route::get('api_importe/{origine}/{path}/{destination}', 'App\Http\Controllers\ImportationController@importe');
Route::get('attestation_edition/{beneficiaire_id}/{statut}/{modele}/{annee?}', 'App\Http\Controllers\Editions\EditionsAttestationsController@imprime');


/* ***** STATISTIQUES ***** */
Route::get('/stats/tdb/{benef_type}', 'App\Http\Controllers\StatistiquesController@index_tdb');
Route::get('/stats/tdb_nbenfant/{benef_type}/{annee?}/{mois?}', 'App\Http\Controllers\StatistiquesController@index_periode_tdb');
Route::get('/stats/graph/{type}', 'App\Http\Controllers\StatistiquesController@graph_tdb');
Route::get('/stats/secteur', 'App\Http\Controllers\StatistiquesController@index_secteurs');
Route::get('/stats/secteur_general/{date?}', 'App\Http\Controllers\StatistiquesController@index_secteurs_gene');
Route::get('/stats/salaires/{exercice?}/{mois?}', 'App\Http\Controllers\StatistiquesController@index_salaries');
Route::get('/stats/optimind/{annee?}', 'App\Http\Controllers\StatistiquesController@index_optimind');


Route::get('api_nb_aidesocales', 'App\Http\Controllers\StatistiquesController@getApiNbAideSocial');
Route::get('api_nb_aidesocales_data', 'App\Http\Controllers\StatistiquesController@getApiNbAideSocialData');

Route::get('api_nb_allocations', 'App\Http\Controllers\StatistiquesController@getApiAllocations');
Route::get('api_nb_allocations_data', 'App\Http\Controllers\StatistiquesController@getApiAllocationsData');

Route::get('api_nb_retraites', 'App\Http\Controllers\StatistiquesController@getApiNbRetraites');
Route::get('api_nb_retraites_data', 'App\Http\Controllers\StatistiquesController@getApiNbRetraitesData');

//ANALYSES DATA
Route::get('/analyses/benef_doublons', 'App\Http\Controllers\AnalysesController@index_benef_doublons');
Route::get('/analyses/histo_rib', 'App\Http\Controllers\AnalysesController@index_histo_rib');
Route::get('/analyses/salaires/{annee?}', 'App\Http\Controllers\AnalysesController@index_salaires');



/* ********* LOGS ********** */
Route::get('/log_user/{usr_id}', 'App\Http\Controllers\LogsController@index_user');

/* ********* LOGS SALAIRES ********** */
Route::get('/log_salaires/{id_salaire}', 'App\Http\Controllers\LogsSalairesController@index_salaires');
Route::get('/log_salaires/{annee?}/{employeur_id?}', 'App\Http\Controllers\LogsSalairesController@index_historique');



/* ***** TESTS ***** */
Route::get('test', 'App\Http\Controllers\TestController@index');
Route::get('test_form', 'App\Http\Controllers\TestController@index_form');
Route::get('/test_editon', 'App\Http\Controllers\Editions\BordereauEtatRecapitulatif@impression_bordereau');
Route::get('mail', 'App\Http\Controllers\HomeController@mail');




