
 
<?php $__env->startSection('title'); ?> Mise à jour d'un Mandat <?php $__env->stopSection(); ?>
 
<?php $__env->startSection('content'); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo Html::style('css/jquery.fancybox.css'); ?> 
    <?php echo Html::style('css/jquery.fancybox-buttons.css'); ?> 
<?php $__env->stopSection(); ?>
 
<div class="col-lg-max col-lg-offset-1">
 
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
 
    <h1><i class='fa fa-banque'></i> Mandat <small>Mise à jour</small></h1>
 
    <?php echo Form::model($mandat, ['id'=>'form','mandat' => 'form'
        , 'url' => '/mandatements/mandats/' . $mandat->id, 'method' => 'PUT', 'class' => 'form-horizontal']); ?>


        <?php echo Form::hidden('refresh',false,['id'=>'refresh']); ?>

        <?php echo Form::hidden('delete_imputation',0,['id'=>'delete_imputation']); ?>

        <?php echo Form::hidden('delete_creancier',0,['id'=>'delete_creancier']); ?>

    <div class="tab-content">
        <div class="form-group">
            <div class="col-md-2">
                <div class="has-success has-feedback">
                    <div class="input-group">
                        <span class="input-group-addon">N°</span>
                        <input readonly="readonly" type="text" class="form-control" name="id" id="id" 
                        value='<?php echo str_pad($mandat->id, 6, "0", STR_PAD_LEFT); ?>' />
                    </div>
               </div>
           </div>
        </div>

        <div class="form-group">
            <div class="col-md-1">
                <?php echo Form::label('exercice', 'Exercice'); ?>

                <?php echo Form::text('exercice', $mandat->exercice, ['placeholder' => "Exercice", 'class' => 'form-control']); ?>

            </div>

            <div class="col-md-2">
                <?php echo Form::label('date_sai', 'Date'); ?>

                <div class="input-group">
                    <div class='input-group date' id='datepicker_date_sai'>
                        <?php echo Form::text('date_sai', $mandat->date_sai, ['placeholder' => 'Date', 'class' => 'form-control']); ?>

                        <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                        <script type="text/javascript">
                            $(function () {
                                $('#datepicker_date_sai').datepicker({
                                    format: "dd/mm/yyyy",
                                    language: "fr",
                                    autoclose: true
                                });
                            });
                        </script>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <?php echo Form::label('statut_mdt', 'Statut'); ?>

                <?php echo Form::select(
                    'statut_mdt',
                    ['ANN'=>'Annulé','ENC' => 'En-cours','REJ' => 'Rejeté','VAL' => 'Validé'],
                    $mandat->statut_mdt,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ); ?>

            </div>


            <div class="col-md-2">
                <?php echo Form::label('type', 'Type'); ?>

                <?php echo Form::select(
                    'type',
                    ['P'=>'Paiement','A' => 'Annulation'],
                    $mandat->type,
                    ['class' => 'selectpicker','data-width' => "100%"]
                ); ?>

            </div>
        </div>

        <div class='form-group'>
            <div class="col-md-6">
            <?php echo Form::label('observation', 'Observations'); ?>

            <?php echo Form::textarea('observation', null, ['placeholder' => 'Observations', 'class' => 'form-control', 'rows'=>'2']); ?>

            </div>
        </div>


        <div class="col-md-8 bg-success" >  
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Directeur</i></b></legend>
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_valid_dir'>
                            <?php echo Form::text('date_valid_dir', $mandat->date_valid_dir, ['placeholder' => 'Date', 'class' => 'form-control']); ?>

                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_valid_dir').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <?php echo Form::label('observation_dir', 'Observations'); ?>

                    <?php echo Form::textarea('observation_dir', null, ['placeholder' => 'Observations du Directeur'
                    , 'class' => 'form-control', 'rows'=>'2']); ?>

                </div>

            </div>
        </div>


        <div class="col-md-8 bg-info" >
            <div class='form-group'  style="padding-top:0px">
                <div class="col-md-3">
                    <legend style="margin:0px"><b><i> Comptable</b></i></legend>
                    <div class="input-group">
                        <div class='input-group date' id='datepicker_date_valid'>
                            <?php echo Form::text('date_valid', $mandat->date_valid, ['placeholder' => 'Date de validation', 'class' => 'form-control']); ?>

                            <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>
                            <script type="text/javascript">
                                $(function () {
                                    $('#datepicker_date_valid').datepicker({
                                        format: "dd/mm/yyyy",
                                        language: "fr",
                                        autoclose: true
                                    });
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="col-md-8">
                    <?php echo Form::label('observation_val', 'Observations'); ?>

                    <?php echo Form::textarea('observation_val', null, ['placeholder' => 'Observations de la Comptabilité'
                    , 'class' => 'form-control', 'rows'=>'2']); ?>

                </div>

            </div>
        </div>

        <!-- IMPUTATIONS -->
        <div class="row">
            <div class="col-xs-8 " >
                <h4>Imputations</h4>
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th width='1%'>Compte</th>
                                <th >Désignation</th>
                                <th width='1%'>Montant</th>
                                <th width='1%'>Type</th>
                                <th >Observations</th>
                                <th  width='1%'>
                                    <?php if($user->can("IMP_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        <a href="<?php echo url('imputation_create_avec_mandat/'.$mandat->id); ?>" 
                                        id='btn_ajout_imputation' 
                                        class="box_imput fancybox.iframe btn btn-success" 
                                        target="_blank">Ajouter une Imputation</a>
                                    <?php endif; ?>
                                </th>
                            </tr>
                        </thead>
             
                        <?php if(isset($imputations)): ?> 
                        <tbody>
                            <?php $__currentLoopData = $imputations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imputation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo $imputation->id; ?></td>
                                <td align='center'><?php echo $imputation->cpt_imp; ?></td>
                                <td ><?php echo $imputation->designation; ?></td>
                                <td align='center'><?php echo $imputation->montant; ?></td>
                                <td align='center'><?php echo $imputation->type_imp; ?></td>
                                <td ><?php echo $imputation->obs; ?></td>
                                <td >
                                    <a href="<?php echo url('imputations_show_frame/'.$imputation->id); ?>" 
                                        class="box_imput fancybox.iframe btn btn-warning" 
                                        id='btn_visu_imputation' 
                                        style="margin-right: 3px;">Consulter</a>

                                <?php if($user->can("IMP_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    <a href="<?php echo url('imputation_edit_avec_mandat/'.$imputation->id.'/'.$mandat->id); ?>" 
                                        id='btn_maj_imputation' class="box_imput fancybox.iframe btn btn-primary" 
                                        style="margin-right: 3px;">Modifier</a>    
                                <?php endif; ?> 

                                <?php if($user->can("IMP_SUP") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    <a href="javascript::" 
                                        onclick="delete_imputation();"
                                        class="btn btn-danger" 
                                        style="margin-right: 3px;">Supprimer</a>    
                                <?php endif; ?> 

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>


        <!-- CREANCIERS -->
        <div class="row">
            <div class="col-xs-8 " >
                <h4>Créanciers</h4>
                    <table id="_table" class="table table-condensed table-striped table-bordered">
                        <thead>
                            <tr>
                                <th width='1%'>N°</th>
                                <th nowrap width='1%'>N°Imput.</th>
                                <th nowrap width='1%'>N°Bénéf.</th>
                                
                                <th >Nom</th>
                                <th width='20%'>Banque</th>
                                <th width='1%'>Compte</th>
                                <th width='1%' >Montant</th>
                                <th  width='1%'>
                                    <?php if($user->can("CRE_AJO") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        <a href="<?php echo url('creancier_create_avec_mandat/'.$mandat->id); ?>" 
                                        id='btn_ajout_creancier' 
                                        class="box_creancier fancybox.iframe btn btn-success" 
                                        target="_blank">Ajouter un creancier</a>
                                    <?php endif; ?>
                                </th>
                            </tr>
                        </thead>
             
                        <?php if(isset($creanciers)): ?> 
                        <tbody>
                            <?php $__currentLoopData = $creanciers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $creancier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td align='center' style='font-style:italic;color:lightgrey'><?php echo $creancier->id; ?></td>
                                <td align='center'><?php echo $creancier->idimp_mdt; ?></td>
                                <td align='center'><?php echo $creancier->num_creancier; ?></td>
                                
                                <td nowrap><?php echo $creancier->nom_complet; ?></td> 
                                <td nowrap align='center'><?php echo ($creancier->bqcle_creancier==0)?"":$creancier->bqcle_creancier."-".$creancier->banque; ?></td>
                                <td align='center'><?php echo $creancier->compte; ?></td>
                                <td align='right'><?php echo $creancier->montant; ?></td>
                                <td nowrap>
                                    <a href="<?php echo url('creancier_show_frame/'.$creancier->id); ?>" 
                                        class="box_creancier fancybox.iframe btn btn-warning" 
                                        id='btn_visu_imputation' 
                                        style="margin-right: 3px;">Consulter</a>

                                <?php if($user->can("CRE_MAJ") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    <a href="<?php echo url('creancier_edit_avec_mandat/'.$creancier->id.'/'.$mandat->id); ?>" 
                                        id='btn_maj_creancier' class="box_creancier fancybox.iframe btn btn-primary" 
                                        style="margin-right: 3px;">Modifier</a>    
                                <?php endif; ?> 

                                <?php if($user->can("IMP_SUP") || $user->HasRole("ADMINISTRATEUR")): ?>
                                    <a href="javascript::" 
                                        onclick="delete_creancier();"
                                        class="btn btn-danger" 
                                        style="margin-right: 3px;">Supprimer</a>    
                                <?php endif; ?> 

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <?php endif; ?>
                    </table>
                </div>
            </div>


        </div>


        <div class='form-group'>
            <?php echo Form::submit('Enregistrer les modifications', ['class' => 'btn btn-primary']); ?>

        </div>
        <?php echo Form::close(); ?>

    </div>
</div>


<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo Html::script('js/jquery.fancybox.js'); ?>




<script type="text/javascript">
var eTarget;
    $(document).ready(function() {
        
         $('#_table tbody').on( 'click', 'tr', function () {
            $(this).toggleClass('selected');
        } );

        $(".box_imput").fancybox({
            width:'70%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {
                eTarget=$(this.element).attr("id");
            },
            afterClose: function () {
                if (eTarget!="btn_visu_imputation") {
                    $("#refresh").val(true);
                    $("#form").submit();
                }
                return;
            }
        });



        $(".box_creancier").fancybox({
            width:'70%',
            autoDimensions:false,
            fitToView   : false,
            autoSize    : false,
            closeClick  : true,
            openEffect  : 'fade',
            closeEffect : 'fade',
            afterLoad: function () {
                eTarget=$(this.element).attr("id");
            },
            afterClose: function () {
                if (eTarget!="btn_visu_creancier") {
                    $("#refresh").val(true);
                    $("#form").submit();
                }
                return;
            }
        });

    });

    function delete_imputation() {
        $('#delete_imputation').val('<?php echo isset($imputation)?$imputation->id:""; ?>');
        $("#refresh").val(true);
        $('#form').submit();
    }

    function delete_creancier() {
        $('#delete_creancier').val('<?php echo isset($creancier)?$creancier->id:""; ?>');
        $("#refresh").val(true);
        $('#form').submit();
    }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre\resources\views/mandatements/mandats/edit.blade.php ENDPATH**/ ?>