
<?php $__env->startSection('title'); ?>
    Consultation d'un Employeur
<?php $__env->stopSection(); ?>
<?php $__env->startSection('styles'); ?>
    <?php echo Html::style('css/jquery.fancybox.css'); ?> 
    <?php echo Html::style('css/jquery.fancybox-buttons.css'); ?> 
    <!-- Datatable -->
    <?php echo Html::style('css/dataTables.bootstrap.css'); ?> 
    <?php echo Html::style('css/buttons.bootstrap.css'); ?> 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class='col-lg-10 col-lg-offset-1' style="margin-top:-20px">
    <h1><i class='fa fa-employeur'></i>Fiche Employeur <small><?php echo $employeur->nom; ?></small></h1>
 
    <?php echo Form::model($employeur, ['employeur' => 'form', 'url' => '/tiers/employeurs/' . $employeur->id,  'class' => 'form-horizontal']); ?>


    <ul class="nav nav-tabs">
        <li class="active"><a href="#nom" data-toggle="tab">Nom - Statut</a></li>
        <li><a href="#employes" data-toggle="tab">Employes</a></li>
        <li><a href="#adresse" data-toggle="tab">Contact</a></li>
        <li><a href="#banque" data-toggle="tab">Banque</a></li>
        <li><a href="#cotisations" data-toggle="tab">Cotisations</a></li>
        <li><a href="#controles" data-toggle="tab">Contrôles</a></li>
    </ul>

    <script>
        $('#myTab a').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
        })

        $('a[data-toggle="tab"]').on('shown', function (e) {
        e.target // activated tab
        e.relatedTarget // previous tab
        })
    </script>

    <br/>
    <div class="tab-content">
        <!-- ------------------------------------- ONGLET NOM ------------------------------- -->
            <div class="tab-pane active" id="nom">

                <div class="col-md-12 bg-success">
                    <div class="form-group">
                        <div class="col-md-10">
                            <?php echo Form::label('nom', 'Nom'); ?>

                            <?php echo Form::text('nom', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-4">
                            <?php echo Form::label('numrc', 'Numéro RC'); ?>

                            <?php echo Form::text('numrc', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>

                        <!--
                        <div class="col-md-2">
                            <?php echo Form::label('nbsal', 'Nombre de salariés'); ?>

                            <?php echo Form::text('nbsal', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                        -->

                        <div class="col-md-3">
                            <label for="nbsalcalc">Nb salariés <small>(au 1er Janvier)</small></label>
                            <?php echo Form::text('nbsalcalc', $employeur->NbEmployes, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>

                        

                        <div class="col-md-2">
                            <?php echo Form::label('statut', 'Statut'); ?>

                            <br/>
                                <?php echo Form::select(
                                    'statut',
                                    App\Models\MyApp::STATUTS_ENTREPRISE,
                                    $employeur->statut,
                                    [
                                        'disabled','class' => 'selectpicker',
                                    ]
                                ); ?>

                        </div>
                    </div>  

                    <div class="form-group">
                        <div class="col-md-4">
                            <?php echo Form::label('date_deb', 'Début d\'activité'); ?>

                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_deb'>
                                        <?php echo Form::text('date_deb', $employeur->date_deb, ['disabled' => 'true', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <?php echo Form::label('date_fin', 'Fin d\'activité'); ?>

                            <div class="input-group">
                                <div class='input-group date' id='datepicker_date_fin'>
                                        <?php echo Form::text('date_fin', $employeur->date_fin, ['disabled' => 'true', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-sm-9">
                        <div class='form-group'>
                            <?php echo Form::label('verrou', 'Verrou'); ?>

                            <?php echo Form::checkbox('verrou', null, ['disabled' => 'true','class' => 'form-control']); ?>

                        </div>
                    </div>

                    <div class="col-md-9">
                            <div class='form-group'>
                                <?php echo Form::label('observation', 'Observations'); ?>

                                <?php echo Form::textarea('observation', null, ['disabled' => 'true', 'class' => 'form-control', 'rows'=>'8']); ?>

                            </div>
                    </div>
                </div>
            </div>

        <!-- ------------------------------------- ONGLET EMPLOYES ------------------------------- -->
            <div class="tab-pane" id="employes">
                <div class="form-group">
                    <div class="col-md-12 bg-info" style="padding:14px">
                        <table id="_table" style="background-color:white" class="table table-condensed table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th width='1%'>N°</th>
                                    <th >Année</th>
                                    <th >Employé</th>
                                    <th class="sum" width='5%'>Jan</th>
                                    <th width='5%'>Fév</th>
                                    <th width='5%'>Mar</th>
                                    <th width='5%'>Avr</th>
                                    <th width='5%'>Mai</th>
                                    <th width='5%'>Jui</th>
                                    <th width='5%'>Jui</th>
                                    <th width='5%'>Aou</th>
                                    <th width='5%'>Sep</th>
                                    <th width='5%'>Oct</th>
                                    <th width='5%'>Nov</th>
                                    <th width='5%'>Déc</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__currentLoopData = $salaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo $salaire->benum; ?></td>
                                    <td><?php echo $salaire->annee; ?></td>
                                    <td nowrap><?php echo $salaire->beneficiaire_nom; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->jan; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->fev; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->mar; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->avr; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->mai; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->jun; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->jui; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->aou; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->sep; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->oct; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->nov; ?></td>
                                    <td nowrap align='right'><?php echo $salaire->dec; ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                 
                        </table>
                    </div>


                    <?php if( $user->can("SAL_MAJ") || $user->HasRole("ADMINISTRATEUR") ): ?>
                    <a href="<?php echo url('recouvrement/salaire_annee/'.$employeur->id); ?>" 
                        class="btn btn-success" target="_blank"
                        style="margin-right: 3px;">Gestion des salaires</a>
                    <?php endif; ?> 
                </div>
            </div>


        <!-- ------------------------------------- ONGLET CONTACTS ------------------------------- -->
            <div class="tab-pane" id="adresse">
                <div class="col-md-12 bg-success" style="padding:14px">
                    <div class="form-group">
                        <div class="col-md-9">
                            <?php echo Form::label('adresse', 'Adresse'); ?>

                            <?php echo Form::textarea('adresse', null, ['disabled' => 'true', 'class' => 'form-control', 'rows'=>'2']); ?>

                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-2">
                            <?php echo Form::label('cp', 'Code Postal'); ?>

                            <?php echo Form::text('cp', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>

                        <div class="col-md-4">
                            <?php echo Form::label('district', 'District - Zone'); ?>

                            <?php echo Form::text('district', $employeur->district, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>

                        <div class="col-md-4">
                            <?php echo Form::label('ile', 'Ile'); ?>

                            <?php echo Form::text('ile', $employeur->ile_libelle, ['disabled' => 'true', 'class' => 'form-control']); ?>               
                        </div>
                    </div>
                </div>


                <div class="col-md-12 bg-info" style="padding:10px">
                    <legend>Contact 1 / Responsable</legend>
                    <div class="form-group">
                        <div class="col-md-4">
                            <?php echo Form::label('responsable', 'Nom'); ?>

                            <?php echo Form::text('responsable', null, ['disabled' => 'true', 'class' => 'form-control'] ); ?>

                        </div>

                        <div class="col-md-4">
                            <?php echo Form::label('email', 'Email'); ?>

                            <?php echo Form::email('email', null, ['disabled' => 'true', 'class' => 'form-control'] ); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::label('tel', 'Téléphone'); ?>

                            <?php echo Form::text('tel', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::label('fax', 'Fax'); ?>

                            <?php echo Form::text('fax', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>
                <div class="col-md-12 bg-warning" style="padding:10px">
                    <legend>Contact 2</legend>
                    <div class="form-group">
                        <div class="col-md-4">
                            <?php echo Form::label('contact_nom', 'Nom'); ?>

                            <?php echo Form::text('contact_nom', null, ['disabled' => 'true', 'class' => 'form-control'] ); ?>

                        </div>

                        <div class="col-md-4">
                            <?php echo Form::label('contact_email', 'Email'); ?>

                            <?php echo Form::email('contact_email', null, ['disabled' => 'true', 'class' => 'form-control'] ); ?>

                        </div>

                        <div class="col-md-2">
                            <?php echo Form::label('contact_tel', 'Téléphone'); ?>

                            <?php echo Form::text('contact_tel', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>
            </div>


        <!-- ------------------------------------- ONGLET BANQUE ------------------------------- -->
            <div class="tab-pane" id="banque">
                <div class="col-md-12 bg-success" style="padding:14px">
                    <div class="form-group">
                        <div class="col-md-6">
                            <?php echo Form::label('banque_id', 'Banque'); ?>

                            <div class="input-group">
                                <div class="input-group-addon" id="ref_banque"><?php echo $employeur->banque_id; ?></div>
                                    <?php echo Form::text('banque', $employeur->NomBanque, ['disabled' => 'true', 'class' => 'form-control']); ?>

                                </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-6">
                            <?php echo Form::label('compte', 'Compte'); ?>

                            <?php echo Form::text('compte', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>

                    <div class="form-group">
                        <div class="col-md-6">
                            <?php echo Form::label('iban', 'IBAN'); ?>

                            <?php echo Form::text('iban', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>
                
                    <div class="form-group">
                        <div class="col-md-2">
                            <?php echo Form::label('secteur', 'Secteur'); ?>

                             <?php echo Form::text('secteur', $employeur->secteur, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>
                </div>
            </div>


        <!-- ------------------------------------- ONGLET COTISATIONS ------------------------------- -->
            <div class="tab-pane" id="cotisations">
              <div class="col-md-12 bg-info" style="padding:14px">
                    <div class="form-group">
                        <div class="col-xs-12">
                            <?php echo Form::label('mode_cotis', 'Mode de cotisation :&nbsp;&nbsp;&nbsp;'); ?>

                            <?php echo Form::radio('mode_cotis', 'value1', ($employeur->mode_cotis == '1')); ?> Trimestrielles&nbsp;
                            <?php echo Form::radio('mode_cotis', 'value2', ($employeur->mode_cotis == '2')); ?> Mensuelles&nbsp;

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-xs-2">
                            <?php echo Form::label('der_cotis', 'Dernière&nbsp;cotisation'); ?>

                            <div class="input-group">
                                <?php echo Form::text('der_cotis', null, ['disabled' => 'true','class' => 'form-control']); ?>

                                <div class="input-group-addon">CFP</div>
                            </div>
                        </div>

                        <div class="col-xs-2">
                            <?php echo Form::label('der_mois', 'Mois concerné'); ?>

                            <div class="input-group">
                                <div class='input-group date' id='datepicker_der_mois'>
                                        <?php echo Form::text('der_mois', $employeur->der_mois, ['disabled' => 'true', 'class' => 'form-control']); ?>

                                </div>
                            </div>
                        </div>

                        <div class="col-xs-3">
                            <?php echo Form::label('soldei', 'Solde antérieur'); ?>

                            <div class="input-group">
                            <?php echo Form::text('soldei', null, ['disabled' => 'true','class' => 'form-control']); ?>

                            <div class="input-group-addon">CFP</div>
                            </div>
                        </div>
                    </div>


                    <div class="form-group">
                        <div class="col-xs-2">
                            <?php echo Form::label('date_med', 'Dernière MED'); ?>

                            <div class='input-group date' id='datepicker_date_med'>
                                    <?php echo Form::text('date_med', $employeur->date_med, ['disabled' => 'true', 'class' => 'form-control']); ?>

                            </div>
                        </div>

                        <div class="col-xs-2">
                            <?php echo Form::label('date_maj', 'Dernière MAJ'); ?>

                            <div class='input-group date' id='datepicker_date_maj'>
                                    <?php echo Form::text('date_maj', $employeur->date_maj, ['disabled' => 'true', 'class' => 'form-control']); ?>

                            </div>
                        </div>

                        <div class="col-md-2">
                            <?php echo Form::label('date_cont', 'Date du contentieux'); ?>

                            <div class='input-group date' id='datepicker_date_cont'>
                                    <?php echo Form::text('date_cont', $employeur->date_cont, ['disabled' => 'true', 'class' => 'form-control']); ?>

                            </div>
                        </div>

                        <div class="col-md-3">
                            <?php echo Form::label('nom_cont', 'Libellé'); ?>

                            <?php echo Form::text('nom_cont', null, ['disabled' => 'true', 'class' => 'form-control']); ?>

                        </div>
                    </div>
              

                    <legend>Liste des cotisations (2 dernières années)</legend>
                    <div class="form-group" align="center">
                        <div class="table-responsive col-lg-12" style="">
                            <table id="_table_cotisation" style="background-color:white" class="table table-condensed table-striped table-bordered" width="100%" >
                                <thead>
                                    <tr>
                                        <th width='1%'>Exercice</th>
                                        <th width='10%'>Date</th>
                                        <th width='10%'>CLR</th> 
                                        <th width='10%'>CCPF</th>
                                        <th width='10%'>Débit</th>
                                        <th width='10%'>Crédit</th>
                                        <th width='10%'>Mois</th>
                                        <th width='1%'>Nb&nbsp;Mois</th>
                                        <th width='1%'>Bord.&nbsp;Pub</th>
                                        <th width='1%'>Bord.&nbsp;Pri</th>
                                        <th width='10%'>Date&nbsp;encais.</th>
                                        <th width='10%'>Date&nbsp;Dépôt.</th>
                                        <th width='50px'>&nbsp;</th>
                                    </tr>
                                </thead>
                     
                                <tbody>
                                    <?php $__currentLoopData = $cotisations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cotisation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td align="center"><?php echo $cotisation->exercice; ?></td>
                                        <td align="center"><?php echo $cotisation->date; ?></td>
                                        <td align="right"><?php echo $cotisation->clr; ?></td>
                                        <td align="right"><?php echo $cotisation->ccpf; ?></td>
                                        <td align="right"><?php echo $cotisation->debit; ?></td>
                                        <td align="right"><?php echo $cotisation->credit; ?></td>
                                        <td align="center"><?php echo $cotisation->mois; ?></td>
                                        <td align="center"><?php echo $cotisation->nbmois; ?></td>
                                        <td><?php echo $cotisation->bdx; ?></td>
                                        <td><?php echo $cotisation->bdx_prive; ?></td>
                                        <td align="center"><?php echo $cotisation->encais_date; ?></td>
                                        <td align="center"><?php echo $cotisation->date_depot; ?></td>
                                        <td nowrap>
                                        <?php if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        <a href="<?php echo url('recouvrement/cotisations/'.$cotisation->id); ?>" 
                                            class="various fancybox.iframe btn btn-warning" 
                                            style="margin-right: 3px;">Détail</a>
                                        <?php endif; ?>  
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                     
                            </table>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group">
                            <a href="javascript:" 
                            id='btn_ajout_enfant' 
                            onclick="$('#dialog-percotis').dialog( 'open' );return false;" 
                            class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Bordereau de cotisation</a>

                            <a href="<?php echo url('cotisations_attestation_regul/'.$employeur->id); ?>" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation de régularité</a>

                            <a href="<?php echo url('cotisations_attestation_pmtech/'.$employeur->id); ?>" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation de paiement échelonné</a>

                            <!--
                            <a href="<?php echo url('cotisations_attestation/'.$employeur->id); ?>" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation</a>
                        -->

                            <a href="<?php echo url('cotisations_attestation_simple/'.$employeur->id); ?>" 
                            id='btn_ajout_enfant'  class="box_versement fancybox.iframe btn btn-info" 
                            target="_blank">Attestation simple</a>

                            <a href="<?php echo url('cotisations_attestation_cotisation/'.$employeur->id); ?>" 
                            id=''  class="btn btn-info" 
                            target="_blank">Attestation de Situation</a>
                        </div>
                    </div>
                </div>
            </div>  

        <!-- ------------------------------------- ONGLET CONTROLES ------------------------------- -->
            <div class="tab-pane" id="controles">
                <div class="col-md-12 bg-info" style="padding:14px">
                    <legend>Liste des controles</legend>
                    <div class="form-group">
                        <div class="table-responsive col-lg-12">
                            <?php if(count($controles)>0): ?>
                            <table style="background-color:white" id="_table" class="table table-condensed table-striped table-bordered" width="90%" >
                                <thead>
                                    <tr>
                                        <th width='1%'>N°</th>
                                        <th width='1%'>Contrôle</th>
                                        <th width='10%'>Agent1</th>
                                        <th width='10%'>Agent2</th> 
                                        <th width='10%'>Validation</th>
                                        <th width='10%'>Observations</th>
                                        <th width='200px'>&nbsp</th>
                                    </tr>
                                </thead>
                     
                                <tbody>
                                <?php $__currentLoopData = $controles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $controle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td style="color:grey"><?php echo $controle->id; ?></td>
                                    <td align="center"><?php echo $controle->date_cont; ?></td>
                                    <td align="center"><?php echo $controle->agent1; ?></td>
                                    <td align="right"><?php echo $controle->agent2; ?></td>
                                    <td align="right"><?php echo $controle->date_valid; ?></td>
                                    <td align="right"><?php echo $controle->observations; ?></td>
                                    <td nowrap>
                                    <?php if($user->can("COT_VISU") || $user->HasRole("ADMINISTRATEUR")): ?>
                                        <a href="<?php echo url('recouvrement/controles/show_box/'.$controle->id); ?>" 
                                            class="various fancybox.iframe btn btn-warning" 
                                            style="margin-right: 3px;">Détail</a>
                                    <?php endif; ?> 
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                        <?php else: ?>
                            <h2><small><i>Aucun contrôle</i></small></h2>
                        <?php endif; ?>
                    </div>
                </div>
            </div>  
        </div>


        <div id="dialog-percotis" title="Période">
            <?php echo Form::label('per_cotis', 'Veuillez saisir la période de cotisation'); ?>

            <?php echo Form::select('annee_cotis',$exercices,date('Y')-1,
                [
                    'id' => 'annee_cotis','class' => 'form-control selectpicker',
                    'data-width' => "100%",'style' => 'font-weight:bold;background:whitesmoke'
                ]); ?>

            <br/><br/>
            <?php echo Form::select(
                    'tri_cotis',[""=>"Choisissez un trimestre",
                        "T1"=>"1er trimestre","T2"=>"2e trimestre","T3"=>"3e trimestre","T4"=>"4e trimestre"],
                    "",
                    [   'id'=>'tri_cotis',
                        'class' => 'form-control selectpicker'
                        ,'data-width' => "100%",
                    ]
                ); ?>

            <br/><br/>
            <?php echo Form::text('per_cotis', null, ['placeholder' => 'Libellé de la période', 
                'class' => 'form-control','id'=>'per_cotis']); ?>

        </div>


        <?php echo Form::close(); ?>

 
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo Html::script('js/magicsuggest.js'); ?>

    <?php echo Html::script('js/jquery.fancybox.js'); ?>

    <!-- <?php echo Html::script('js/jquery.dataTables.editable.js'); ?>  -->
    <?php echo $__env->make('tiers.employeurs.scripts_employeur', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;

    <!-- Datatable  -->
    <?php echo Html::script('js/jquery.dataTables.js'); ?>

    <?php echo Html::script('js/dataTables.bootstrap.js'); ?>


    <!-- Datatable Button --> 
    <?php echo Html::script('js/dataTables.buttons.js'); ?>

    <?php echo Html::script('js/buttons.bootstrap.js'); ?>

    <?php echo Html::script('js/buttons.html5.js'); ?>

    <?php echo Html::script('js/buttons.print.js'); ?>

    <?php echo Html::script('js/jszip.min.js'); ?>

    <?php echo Html::script('js/pdfmake.min.js'); ?>

    <?php echo Html::script('js/vfs_fonts.js'); ?>

    <?php echo Html::script('js/buttons.colVis.min.js'); ?>


    <?php echo Html::script('js/moment.min.js'); ?>

    <?php echo Html::script('js/datetime-moment.js'); ?>

<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\CPSWF\ancienne verrsion\sipre\resources\views/tiers/employeurs/show.blade.php ENDPATH**/ ?>