<?php echo $__env->make('forms.fbncheader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('forms.fdatatables', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('styles'); ?>
    <?php echo Html::style('css/jquery.fancybox.css'); ?>

    <?php echo Html::style('css/jquery.fancybox-buttons.css'); ?>

<?php $__env->stopSection(); ?>


    <div class="col-lg-max container-fluid col-lg-offset-1 bg-success alert">
        <div class="col-xs-2">
           <?php echo Html::image("img/".$user->getIconeStatut($type), "",
            array( 'maxwidth' => '20%','width' => '50%' )); ?>

        </div>
        <div class="col-xs-10">
            <h1><?php echo "Versement définitifs des ".$user->getTitreStatut($type); ?></h1>
        </div>

        <div class="col-xs-2" style="padding-top:10px">
                <?php echo Form::label('brd', "Numéro d'imprimé :"); ?>

            </div>
            <div class="col-xs-2">
                <?php echo Form::select('num_imp',
                    $liste_num_imp,
                    $num_imp,
                    [
                        'id' => 'num_imp','class' => 'form-control selectpicker show-tick',
                        'data-width' => "90%",'style' => 'font-weight:bold;'
                    ]
                ); ?>

                <script>
                    $(document).ready(function() {
                        $('#num_imp').on('change', function() {
                            location.href="<?php echo url('/versements/'.$type); ?>/"
                                +$('#num_imp').val();
                        });
                    });
                </script>
            </div>
    </div>

    <div class="col-lg-max  container-fluid col-lg-offset-1" style="padding-top:20px">
    <?php if($type!=""): ?>
        <div class="table-responsive">
            <table id="_table" class="table table-condensed table-striped table-bordered">
                <thead>
                    <tr>
                        <th width='1%'>N°</th>
                        <th width='1%'>N°Emp</th>
                        <th >Bénéficiaire</th>
                        <th width='1%'>NbEnf<?php echo ($type!="RET")?" Considérés":""; ?></th>
                        <th width='1%'>Naissance</th>
                        <th width='1%'>Statut</th>
                        <th width='1%'>Type</th>
                        <?php if($type=="RET"): ?>
                        <th width='1%'>RetType</th>
                        <th width='1%'>RetDate</th>
                        <th width='1%'>RetNum</th>
                        <?php endif; ?>
                        <!-- <th width='1%' nowrap>N°IMP</th> -->
                        <th width='1%'>Rappel</th>
                        <th width='1%'>Calcul</th>
                        <th width='1%'>Montant</th>
                        <th width='10%'>Banque</th>
                        <th width='10%'>Compte</th>
                        <th>Obs</th>
                    </tr>
                </thead>


                <tbody>
                <?php $__currentLoopData = $versements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $versement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $beneficiaire=App\Models\Beneficiaire::find($versement->benum);
                ?>

                <tr>
                    <td style="color:grey"><?php echo $versement->benum; ?></td>
                    <td style="color:grey"><?php echo $versement->sonum; ?></td>
                    <td><a href="<?php echo url('tiers/beneficiaires/'.$versement->benum); ?>"
                        class="" target="_blank">
                        <?php echo $versement->nom_beneficiaire." ".$versement->prenom_beneficiaire; ?></td>
                        </a>
                    <td>
                        <?php echo $versement->nb_enf.(($type=="RET")?"":"/".$beneficiaire->NbEnfants); ?>

                    </td>
                    <td><?php echo $versement->naissance_beneficiaire; ?></td>
                    <td align="center"><?php echo $versement->statut_beneficiaire; ?></td>
                    <td align="center"><?php echo $versement->type; ?></td>
                    <?php if($type=="RET"): ?>
                    <td align="center"><?php echo $versement->ret_type; ?></td>
                    <td align="center"><?php echo $versement->ret_date; ?></td>
                    <td align="center"><?php echo $versement->ret_num; ?></td>
                    <?php endif; ?>
                    <!-- <td align="center"><?php echo $versement->num_imp; ?></td> -->
                    <td align="right" nowrap><?php echo number_format($versement->montant_r,0,","," "); ?></td>
                    <td align="right" nowrap><?php echo number_format($versement->montant_c,0,","," "); ?></td>
                    <td align="right" style="font-weight:bold;" class="bg-danger" nowrap><?php echo number_format($versement->montant,0,","," "); ?></td>
                    <td><?php echo $versement->banque_nom; ?></td>
                    <td><?php echo $versement->compte; ?></td>
                    <td><?php echo $versement->obs_vers; ?></td>
                </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>
    <?php endif; ?>


<p>
    <div class='form-group form-horizontal'>
        <?php if($type!=""): ?>
            <div class="col-md-2">
                    <a href="<?php echo url('versements_print/'.$type.'/'.$num_imp); ?>"
                        class="btn btn-info"  target="_blank">Imprimer le borderau</a>
            </div>

            <?php if($user->can("VER_EXP") || $user->HasRole("ADMINISTRATEUR")): ?>


            <div class="col-md-3">
                <a href="<?php echo url('versements_export_fichier_complet/'.$type.'/'.$num_imp); ?>"
                    class="btn btn-warning"  target="_blank">Générer le fichier DFiP</a>
            </div>
<!--
            <div class="col-md-2">
                    <a disabled href="<?php echo url('versements_export_fichier/'.$type.'/'.$num_imp); ?>"
                        class="btn btn-danger"  target="_blank">Générer le fichier BWF</a>
            </div>

            <div class="col-md-2">
                    <a disabled href="<?php echo url('versements_export_fichier_BWF_TP/'.$type.'/'.$num_imp); ?>"
                        class="btn btn-danger"  target="_blank">Générer le fichier BWF/DFiP</a>
            </div>

            <div class="col-md-2">
                    <a disabled href="<?php echo url('versements_export_fichier_TP/'.$type.'/'.$num_imp); ?>"
                        class="btn btn-danger"  target="_blank">Générer le fichier DFiP</a>
            </div>
        -->
            <?php endif; ?>
        <?php endif; ?>
    </div>
</p>


</body></html>

<?php echo Html::script('js/magicsuggest.js'); ?>

<?php echo Html::script('js/jquery.fancybox.js'); ?>

<?php echo Html::script('js/jquery.dataTables.editable.js'); ?>


<?php echo $__env->make('forms.fdatatables_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    $("._box").fancybox({
        //fitToView   : true,
        width       : '85%',
        height      : '85%',
        closeClick  : true,
        openEffect  : 'fade',
        closeEffect : 'fade',
    });
</script>
<?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre\resources\views/prestations/versements/index_annee.blade.php ENDPATH**/ ?>