
 
<?php $__env->startSection('title'); ?> Mise à jour d'une fiche salaire <?php $__env->stopSection(); ?>
 

<?php $__env->startSection('content'); ?>
    <?php $__env->startSection('styles'); ?>
        <?php echo Html::style('css/jquery.fancybox.css'); ?> 
        <?php echo Html::style('css/jquery.fancybox-buttons.css'); ?> 
    <?php $__env->stopSection(); ?>

    <div class='col-lg-10 col-lg-offset-1'>
        <?php if($errors): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class='bg-danger alert'><?php echo $error; ?></div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <h1><i class='fa fa-banque'></i> Mise à jour d'une fiche salaire</h1>
        <?php echo Form::model($salaire, ['salaire' => 'form', 'url' => '/recouvrement/salaires/' . $salaire->id, 'method' => 'PUT', 'class' => 'form-horizontal']); ?>

            <div class="tab-content">
                <div class="form-group">
                    <div class="col-md-4">
                            <?php echo Form::label('benum', 'Bénéficiaire'); ?>

                            <?php echo Form::hidden('benum', $salaire->benum); ?>

                            <div class="input-group">
                                <div class="input-group-addon" id="ref_beneficiaire"><?php echo $salaire->benum; ?></div>
                                <?php echo Form::text('benom', $salaire->beneficiaire_nom, 
                                    ['class' => 'form-control','disabled'=>'true']
                                    ); ?>

                            </div>
                    </div>

                    <div class="col-md-4">
                            <?php echo Form::label('sonum', 'Employeur'); ?>

                            <?php echo Form::hidden('sonum', $employeur->id); ?>

                            <div class="input-group">
                                <div class="input-group-addon" name="ref_employeur" id='ref_employeur'><?php echo $employeur->id; ?></div>
                                <?php echo Form::text('employeur_nom', $employeur->nom, 
                                    ['class' => 'form-control', 
                                        'name'=>"employeur_nom",'id'=>"employeur_nom"]
                                    ); ?>

                            </div>
                        <script>
                                $(function() {        
                                   $("#employeur_nom").autocomplete({
                                        source: "<?php echo route('autocomplete_employeur'); ?>",
                                        minLength: 2,
                                        select: function(event, ui) {
                                            $('#sonum').val(ui.item.id);
                                            $('#ref_employeur').html(ui.item.id);
                                        },
                                        change: function( event, ui ) {
                                            var id_nom=ui.item.value.trim();
                                            var nom;
                                            if(id_nom.length>5) nom=(id_nom.substring(4)).trim();
                                            $('#employeur_nom').val(nom);
                                            $('#ref_employeur').html(ui.item.id);
                                            $('#sonum').val(ui.item.id);
                                        }
                                    }); 
                                   return;
                                });
                        </script>
                    </div>
                </div>
                <div class="form-group">
                    <div class="col-md-1">
                            <?php echo Form::label('annee', 'Année'); ?>

                            <?php echo Form::text('annee', null, ['class' => 'form-control','readonly']); ?>

                    </div>
                
                    <div class="col-md-4">
                        <?php echo Form::label('dat_ent', 'Date d\'entrée'); ?>

                        <div class="input-group">
                            <div class='input-group date' id='datepicker_dat_ent'>
                                <?php echo Form::text('dat_ent', null, ['placeholder' => 'Date d\'entrée', 'class' => 'form-control']); ?>

                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_dat_ent').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <?php echo Form::label('date_sor', 'Date de sortie'); ?>

                        <div class="input-group">
                            <div class='input-group date' id='datepicker_date_sor'>
                                <?php echo Form::text('date_sor', null, ['placeholder' => 'Date de sortie', 'class' => 'form-control']); ?>

                                <span class='input-group-addon'><span class='glyphicon glyphicon-calendar'></span></span>

                                <script type="text/javascript">
                                    $(function () {
                                        $('#datepicker_date_sor').datepicker({
                                            format: "dd/mm/yyyy",
                                            language: "fr",
                                            autoclose: true
                                        });
                                    });
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
                <hr/>
                <div class="form-group">
                    <button type="button" class="btn bt-sm btn-success" onclick="ventiler()">Ventiler un salaire</button>
                    <input type='hidden' id='ventil_active' value="0" />
                    <a href="<?php echo url('log_salaires/'.$salaire->id); ?> " 
                        class="btn bt-sm btn-warning box_log fancybox.iframe">Historique
                    </a>
                    <?php echo Form::submit('Enregistrer', ['class' => 'btn bt-sm btn-primary']); ?>

                </div>

                <div class="col-md-12">
                    <table class="table table-condensed table-striped table-bordered">
                        <theader>
                            <tr>
                                <th ></th>
                                <?php $tmois=App\Models\MyApp::MOIS_COURT_LONG; ?>
                                <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td width='100px'><?php echo Form::label($mois, $libelle); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </theader>
                        <tbody>
                            <tr>
                                <th>Montant Origine</th>
                                <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo Form::text('origine', $salaire->{$mois}, ['class' => 'form-control','disabled']); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>

                            <tr>
                                <th>Montant</th>
                                <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo Form::text($mois, null, ['class' => 'form-control']); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                            <tr>
                            <th>Suspendu</th>
                                <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td align='center'>
                                        <?php echo Form::checkbox('box_'.$mois, 1,$salaire->getSuspendu($mois)?1:0
                                            , ['id'=>'box_'.$mois]); ?>

                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-md-12" id='div_ventil' style='visibility:hidden'>
                    <div class="form-group">
                        <div class="col-md-2">
                                <?php echo Form::label('total_vent', 'Montant à ventiler'); ?>

                                <?php echo Form::text('total_vent', null, ['id'=>'total_vent',
                                            'class' => 'form-control',
                                            'placeholder'=>'Total à ventiler',
                                            'onchange'=>'set_vent()']); ?>


                                <?php echo Form::text('total_a_vent', null, ['id'=>'total_a_vent',
                                            'class' => 'form-control',
                                            'readonly', 'style'=>'color:grey;font-style:italic;']); ?>

                        </div>
                    </div>
                    <table class="table table-striped table-condensed table-bordered">
                        <theader>
                            <tr>
                                <th ></th>
                                <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td width='100px'><?php echo Form::label($mois, $libelle); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </theader>
                        <tbody>
                            <tr>
                                <th>Ventilation<small style='font-weight:normal'><br>Ajouté au salire</small></th>
                                <?php $__currentLoopData = $tmois; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mois=>$libelle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>

                                    <input class='ventil checkbox' type='checkbox' 
                                        value='0' 
                                        id='<?php echo $mois; ?>_check' 
                                        onchange='set_vent()'
                                        style='visibility:hidden'/>

                                        <?php echo Form::text($mois.'_vent', null, 
                                            ['id'=>$mois.'_vent','class' => 'form-control','onchange'=>'calc_vent()']); ?>

                                    </td>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="col-md-12" id='div_modif' style='visibility:hidden'>
                    <div class="form-group">
                        <div class="col-md-2">
                            Modifications
                        </div>
                    </div> 
                </div>    


            </div>
        <?php echo Form::close(); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo Html::script('js/jquery.fancybox.js'); ?>

    <script type="text/javascript">
        $(document).ready(function() {
            $(".box_log").fancybox({
                width:'550px',
                autoDimensions:false,
                fitToView   : false,
                autoSize    : false,
                closeClick  : true,
                openEffect  : 'fade',
                closeEffect : 'fade',
                afterLoad: function () {
                    
                },
                afterClose: function () {
                    return;
                }
            })
        });

        function ventiler() {
            if($('#ventil_active').val()==0) {
                $('#div_ventil').attr('style','visibility:show');
                $('.ventil').attr('style','visibility:show');
                $('#ventil_active').val(1);
            } else {
                $('#div_ventil').attr('style','visibility:hidden');
                $('.ventil').attr('style','visibility:hidden');
                $('#ventil_active').val(0);
                raz_vent();
            }
        }
        function set_vent() {
            var total=$('#total_vent').val();
            var t_mois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            var nb=0;
            //Compte le nomnbre de mois
            for(var i=0;i<t_mois.length;i++) {
                if($('#'+t_mois[i]+'_check').prop( "checked" )) {
                    nb++;
                }
            }
            var ventmois=0;
            var reste=0;
            if(nb>0) {
                ventmois=parseInt(total/nb);
                if(nb*ventmois!=total) reste=total-nb*ventmois;
            }
            for(var i=0;i<t_mois.length;i++) {
                if($('#'+t_mois[i]+'_check').prop( "checked" )) {
                    if(i==(t_mois.length-1)) ventmois+=reste;
                    $('#'+t_mois[i]+'_vent').val(ventmois);

                } else {
                     $('#'+t_mois[i]+'_vent').val(0);
                }
            }
            calc_vent();
        }
        function raz_vent() {
            $('#total_vent').val(0);
            var t_mois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            for(var i=0;i<t_mois.length;i++) {
                     $('#'+t_mois[i]+'_vent').val(0);
            }
            calc_vent();
        }
        function calc_vent() {
            var total=$('#total_vent').val();
            var t_mois=['jan','fev','mar','avr','mai','jun','jui','aou','sep','oct','nov','dec'];
            var total_vent=0;

            for(var i=0;i<t_mois.length;i++) {
                total_vent+=parseInt($('#'+t_mois[i]+'_vent').val());
            }
            $('#total_a_vent').val(total_vent);
            var reste = parseInt($('#total_vent').val())-parseInt($('#total_a_vent').val());
            if(reste>0) $('#total_a_vent').val(total_vent+" ("+reste+")");
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\SYSINFO\cpswf\sipre\resources\views/recouvrement/salaires/edit.blade.php ENDPATH**/ ?>