<?php
namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Hash;


class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
        $this->middleware('auth')->only('logout');
    }

    //Surcharge
    public function login(Request $request)
    {

        $email="gendarmerie@mail.wf";
        $request->merge(['email' => $email]); //Fore id
        if(!$request->password) $this->validateLogin($request);
        
        $password=$request->password;
       

        //$user = new User;
        /*
        $user = User::where('email','=',$email)->first();
        if(!$user) $user = new User;
        $user->name = "ADMINISTRATEUR";
        $user->email      = strtolower($request->email);
        $user->password   = Hash::make('ImmatWallis&Futuna986!');
        $user->save();
*/
        if ($this->attemptLogin($request)) {


            $user=User::where('email','=',$email)->first();           
/*
            if(!$user->actif) { //Si desactivé
                Auth::logout();
                return $this->sendFailedLoginResponse($request);
            }*/

            $id = $user->id;
            Session::put('id', $user->id);
            Session::put('nom', $user->name);
            Session::put('profil', $user->getRoleNames()->first());
            return $this->sendLoginResponse($request);
        }

        // If the login attempt was unsuccessful we will increment the number of attempts
        // to login and redirect the user back to the login form. Of course, when this
        // user surpasses their maximum number of attempts they will get locked out.
        $this->incrementLoginAttempts($request);
        return $this->sendFailedLoginResponse($request);
    }
}
