<?php namespace App\Models;

use App\Models\Sipre\SipreBeneficiaire;
use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use Illuminate\Support\Facades\Auth;
use DateTime;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Collection;

class Allocataire extends Model {

	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'allocataires';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;
    //protected $keepRevisionOf = ['title'];
    //protected $dontKeepRevisionOf = ['category_id'];
    //protected $historyLimit = 500; //Stop tracking revisions after 500 changes have been made.


    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Conjoint
    public function conjoint()
    {
        return $this->hasOne(Allocataire::class,'id_conjoint');
    }

    //Enfants comme parent1
    public function enfants()
    {
        return $this->hasMany(Allocataire::class,'id_parent1')
            ->union($this->hasMany(Allocataire::class,'id_parent2'));
    }

    //Commissions
    public function allocataires_commissions(): HasMany
    {
        return $this->hasMany(AllocataireCommission::class,"id_allocataire");
    }
    //Comptes
    public function allocataires_comptes(): HasMany
    {
        return $this->hasMany(AllocataireCompte::class,"id_allocataire");
    }
    //Droits
    public function allocataires_droits(): HasMany
    {
        return $this->hasMany(AllocataireDroit::class,"id_allocataire");
    }
    //Equipements
    public function allocataires_equipements(): HasMany
    {
        return $this->hasMany(AllocataireEquipement::class,"id_allocataire");
    }
    //Fragilite
    public function allocataires_fragilites(): HasMany
    {
        return $this->hasMany(AllocataireFragilite::class,"id_allocataire");
    }
    //GIR
    public function allocataires_girs(): HasMany
    {
        return $this->hasMany(AllocataireGir::class,"id_allocataire");
    }
    //Handicap
    public function allocataires_handicaps(): HasMany
    {
        return $this->hasMany(AllocataireHandicap::class,"id_allocataire");
    }
    //Humaines
    public function allocataires_humaines(): HasMany
    {
        return $this->hasMany(AllocataireHumaine::class,"id_allocataire");
    } 
    //Projets
    public function allocataires_projets(): HasMany
    {
        return $this->hasMany(AllocataireProjet::class,"id_allocataire");
    } 
    //Ressources
    public function allocataires_ressources(): HasMany
    {
        return $this->hasMany(AllocataireRessource::class,"id_allocataire");
    } 
    //Visites
    public function allocataires_visites(): HasMany
    {
        return $this->hasMany(AllocataireVisite::class,"id_allocataire");
    } 
    //Famille-Titulaire
    public function famille_titulaire(): HasOne
    {
        return $this->hasOne(Famille::class,"id_titulaire");
    } 
    //Famille-Conjoint
    public function famille_conjoint(): HasOne
    {
        return $this->hasOne(Famille::class,"id_conjoint");
    } 

    //Village
    public function village()
    {
        return $this->hasOne(Village::class,"id","id_village");
    }


    /* Dates */
    public function getDates()
    {
        return array('date_naissance','date_deces','date_pi','procuration_date_naissance','date_arrivee_wf','date_depart_wf',
            'procuration_date_debut','procuration_date_fin',
            'updated_at','created_at');
            //'date_ouverture_aae','date_fermeture_aae','date_ouverture_csr','date_fermeture_csr',
    }
    //Dates AAE
 
    public function getDateOuvertureAAEAttribute($value)
    {
        return ($this->attributes['date_ouverture_aae']!=null)?date('d/m/Y', strtotime($this->attributes['date_ouverture_aae'])):null;
    }
    public function getDateFermetureAAEAttribute($value)
    {
        return ($this->attributes['date_fermeture_aae']!=null)?date('d/m/Y', strtotime($this->attributes['date_fermeture_aae'])):null;
    }
    //Dates AAE US
    public function getDateOuvertureAAEUSAttribute($value)
    {
        return ($this->attributes['date_ouverture_aae']!=null)?date('Y-m-d', strtotime($this->attributes['date_ouverture_aae'])):null;
    }
    public function getDateFermetureAAEUSAttribute($value)
    {
        return ($this->attributes['date_fermeture_aae']!=null)?date('Y-m-d', strtotime($this->attributes['date_fermeture_aae'])):null;
    }
    //Dates CSR
    public function getDateOuvertureCSRAttribute($value)
    {
        return ($this->attributes['date_ouverture_csr']!=null)?date('d/m/Y', strtotime($this->attributes['date_ouverture_csr'])):null;
    }
    public function getDateFermetureCSRAttribute($value)
    {
        return ($this->attributes['date_fermeture_csr']!=null)?date('d/m/Y', strtotime($this->attributes['date_fermeture_csr'])):null;
    }
    //Dates CSR US
    public function getDateOuvertureCSRUSAttribute($value)
    {
        return ($this->attributes['date_ouverture_csr']!=null)?date('Y-m-d', strtotime($this->attributes['date_ouverture_csr'])):null;
    }
    public function getDateFermetureCSRUSAttribute($value)
    {
        return ($this->attributes['date_fermeture_csr']!=null)?date('Y-m-d', strtotime($this->attributes['date_fermeture_csr'])):null;
    }

    //Dates NAISSANCE
    public function getDateNaissanceAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['date_naissance'])):null;
    }
    public function getDateNaissanceUSAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('Y-m-d', strtotime($this->attributes['date_naissance'])):null;
    }
    //Dates DECES
    public function getDateDecesAttribute($value)
    {
        return ($this->attributes['date_deces']!=null)?date('d/m/Y', strtotime($this->attributes['date_deces'])):null;
    }

    //Date arrivée W&F
    public function getDateArriveeWFAttribute($value)
    {
        return ($this->attributes['date_arrivee_wf']!=null)?date('d/m/Y', strtotime($this->attributes['date_arrivee_wf'])):null;
    }

    //Date départ W&F
    public function getDateDepartWFAttribute($value)
    {
        return ($this->attributes['date_depart_wf']!=null)?date('d/m/Y', strtotime($this->attributes['date_depart_wf'])):null;
    }

    public function getDatePiAttribute($value)
    {
        return (($this->attributes['date_pi']!=null))?date('d/m/Y', strtotime($this->attributes['date_pi'])):null;
    }

    public function getProcurationDateNaissanceAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateNaissanceUSAttribute($value)
    {
        return ($this->attributes['procuration_date_naissance']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_naissance'])):null;
    }
    public function getProcurationDateDebutAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateDebutUSAttribute($value)
    {
        return ($this->attributes['procuration_date_debut']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_debut'])):null;
    }
    public function getProcurationDateFinAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getProcurationDateFinUSAttribute($value)
    {
        return ($this->attributes['procuration_date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['procuration_date_fin'])):null;
    }
    public function getUpdatedAtAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['updated_at'])):null;
    }

    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }
    public function getCreatedAtDayAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/y', strtotime($this->attributes['created_at'])):null;
    }


    /***************/
    /* NOM ADRESSE */
    /***************/
    public function getIdPADAttribute()
    {
        return str_pad($this->id, 5, "0", STR_PAD_LEFT);
    }
    public function getIdCPSWFPADAttribute()
    {
        if(!$this->id_cpswf) return "";
        return str_pad($this->id_cpswf, 5, "0", STR_PAD_LEFT);
    }

    /* ADRESSE */
    public function getVillageFullNameAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->FullName;
    }

    public function getVillageFullName2Attribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->FullName2;
    }

    public function getVillageNomAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        return $village->nom;
    }

    //Nom village et ile
    public function getVillageIleNomAttribute()
    {
        $village=$this->village;
        if(!$village) return "";
         $district=$village->district;

        if(!$district) return $village->nom;
        return $village->nom." (".$district->ile.")";
    }



    public function getIleAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "A";
        return $village->ile;
    }

    public function getDistrictNomAttribute()
    {
        $village=Village::find($this->id_village);
        if(!$village) return "";
        $district=District::find($village->id_district);
        if(!$district) return "";
        return $district->nom;
    }

    public function getAdresseCompleteAttribute()
    {
        $sep="<br/>";
        $adresse=trim($this->adresse);
        if($this->id_village) $adresse.=$sep.$this->VillageFullName;

        return trim($adresse);
    }

    public function getAdresseComplete2($sep="\n")
    {

        $adresse=trim($this->adresse);
        if($this->id_village) {
            $village=Village::find($this->id_village);
            if($village) $adresse.=" - ".$village->getFullName3($sep);
        }
        return trim($adresse);
    }



    /***************/
    /* NOM         */
    /***************/


    /* NOM+PRENOM  */
    public function getNomCompletAttribute()
    {
        if($this->nom) $lib=$this->nom." ".$this->prenom.(($this->nom)?" - Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance:"");
        else $lib=$this->nom_naissance." ".$this->prenom;
        return $lib;
    }

    public function getNomComplet2Attribute()
    {
        if($this->nom) $lib=$this->nom." ".$this->prenom.(($this->nom)?" - Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance:"");
        else $lib=$this->nom_naissance." ".$this->prenom;
        return $lib;
    }

    public function getNomComplet3Attribute()
    {
        if($this->nom) $lib=$this->nom." ".$this->prenom.(($this->nom)?" - Né".(($this->sexe=="M")?" ":"e ").$this->nom_naissance:"");
        else $lib=$this->nom_naissance." ".$this->prenom;
        $lib.=" Né".(($this->sexe=="M")?" ":"e ")." le ".$this->DateNaissance;
        return $lib;
    }

    /* NOM seul pour éditions */
    public function getNomReduit($taille_max=20)
    {
        $nom=trim($this->nom_naissance);
        if(strlen($nom)>$taille_max) $nom=substr($nom,0,$taille_max);
        return trim($nom);
    }

    /* NOM+PRENOM pour éditions */
    public function getNomCompletReduit($taille_max=20)
    { 
        $prenom=str_replace(","," ",$this->prenom);
        $prenom2="";$lib2="";
        $t_prenom=explode(' ',$prenom);
        $prenom=trim($t_prenom[0]);
        if(isset($t_prenom[1])) $prenom2=trim($t_prenom[1]);

        $nom_naissance=trim($this->nom_naissance);
        $nom=trim($this->nom);
        if($nom) {
            $lib=$nom." ".$prenom.(($nom)?" - Né".(($this->sexe=="M")?" ":"e ").$nom_naissance:"");
            if($prenom2) {
                $lib2=$nom." ".$prenom." ".$prenom2.(($nom)?" - Né".(($this->sexe=="M")?" ":"e ").$nom_naissance:"");
                if(strlen($lib2)<=$taille_max) $lib=$lib2;
            }
            if(strlen($lib)>=$taille_max) {
                $prenom=substr($prenom,0,2).".";
                $lib=$nom." ".$prenom.(($nom)?" - Né".(($this->sexe=="M")?" ":"e ").$nom_naissance:"");
            }
        }
        else {
            $lib=$nom_naissance." ".$prenom;
            if($prenom2) {
                $lib2=$nom_naissance." ".$prenom." ".$prenom2;
                if(strlen($lib2)<=$taille_max) $lib=$lib2;
            }
            
            if(strlen($lib)>=$taille_max) $lib=$nom_naissance." ".substr($prenom,0,2).".";
        }

        return $lib;
    }


    /* NOM+PRENOM (1er lettre si > taille) pour éditions */
    public function getNomPrenomReduit($taillemax=30)
    {
        $nom=trim($this->nom_naissance);
        if(strlen($nom)>$taillemax) $nom=substr($nom,0,$taillemax);
        $t_prenom=explode(' ',trim($this->prenom));
        $prenom=trim($t_prenom[0]);
        if(strlen($nom." ".$prenom)>$taillemax) $prenom=substr($prenom,0,1).".";

        return trim($nom." ".$prenom);
    }

    /* Etat Civil */
    public function getEtatCivilAttribute()
    {
        if($this->sexe=="M") return "M";
        if($this->sexe=="F") return "Mme";  
        return "";
    }

    /* Etat Civil Long */
    public function getEtatCivilLongAttribute()
    {
        if($this->sexe=="M") return "Monsieur";
        if($this->sexe=="F") return "Madame";  
        return "";
    }

    /* Etat Civil Code */
    public function getEtatCivilCodeAttribute()
    {
        if($this->sexe=="M") return "1";
        if($this->sexe=="F") return "2";  
        return "";
    }
    
    /***************/
    /* AGE         */
    /***************/
    public function getAgeAttribute()
    {
        $date=$this->attributes['date_naissance'];
        $age= (int) ((time() - strtotime($date)) / 3600 / 24 / 365);

        return $age;
    }

    public function getAgeDate($date_day)
    {
        $date=$this->attributes['date_naissance'];
        $age= (int) ((strtotime($date_day) - strtotime($date)) / 3600 / 24 / 365);
        return $age;
    }

    public function getAgeMoisJourAttribute()
    {
        $date=date_create($this->attributes['date_naissance']);
        $today = new DateTime();
        $diff  = $today->diff($date);
        return array('y' => $diff->y, 'm' => $diff->m, 'd' => $diff->d, 'days' => $diff->days);
    }

    public function getEcartAgeConjointAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return ""; 
        $ecart=$this->age-$conjoint->age;

        return $ecart;
    }

    /************************************/
    /* EQUIPEMENTS / BESOINS            */
    /************************************/
    public function gethasBesoinsAttribute() {
        $nb_besoin=AllocataireEquipement::where('id_allocataire','=',$this->id)->where('besoin','=','O')->count();
        if(!$nb_besoin) return false;
        return true;
    }

    public function getListeBesoins($avecobservations=false) {
        $besoins=AllocataireEquipement::where('id_allocataire','=',$this->id)->where('besoin','=','O')->get();
        $txt="";
        foreach($besoins as $besoin) {
            $txt.="<li>";
            $txt.=$besoin->EquipementNom;
            if($avecobservations && $besoin->observations) {
                $txt.=" : ".$besoin->observations;
            }
            $txt.="</li>";
        }
        $txt="<ul>".$txt."</ul>";
        return $txt;
    }

    public function getListeBesoinsObservations($sep="<br/>") {
        $besoins=AllocataireEquipement::where('id_allocataire','=',$this->id)->where('besoin','=','O')->get();
        $txt="";
        foreach($besoins as $besoin) {
            $txt.=(($txt)?$sep:"").$besoin->observations;
        }
        return $txt;
    }

    public function gethasBesoinsHumainAttribute() {
        $nb_besoin=AllocataireHumaine::where('id_allocataire','=',$this->id)->where('prevoir','=','1')->count();
        if(!$nb_besoin) return false;
        return true;
    }

    public function getListeBesoinsHumain($avecobservations=false) {
        $besoins=AllocataireHumaine::where('id_allocataire','=',$this->id)->where('prevoir','=','1')->get();
        $txt="";
        foreach($besoins as $besoin) {
            $txt.="<li>";
            $txt.=$besoin->BesoinNom;
            if($besoin->ModaliteNom) $txt.=" - ".$besoin->ModaliteNom;
            if($avecobservations && $besoin->observations) {
                $txt.=" : ".$besoin->observations;
            }
            $txt.="</li>";
        }
        $txt="<ul>".$txt."</ul>";
        return $txt;
    }


    public function gethasProjetsAttribute() {
        $nb_projets=AllocataireProjet::where('id_allocataire','=',$this->id)->count();
        if(!$nb_projets) return false;
        return true;
    }
    // Lite projets de Vie
    public function getListeProjets($avecobservations=false) {
        $projets=AllocataireProjet::where('id_allocataire','=',$this->id)->get();
        $txt="";
        foreach($projets as $projet) {
            $txt.="<li>";
            $txt.=$projet->ProjetNom;
            if($avecobservations && $projet->observations) {
                $txt.=" : ".$projet->observations;
            }
            $txt.="</li>";
        }
        $txt="<ul>".$txt."</ul>";
        return $txt;
    }
    /************************************/
    /* EVALUATION SOCIALE              */
    /************************************/
    public function getGetLastAGGIR($type_aide,$type_visite="") {
        $allocataire_gir_obj=AllocataireGir::where('id_allocataire','=',$this->id)
            ->where('statut','=','TER');

        if($type_visite) $allocataire_gir_obj=$allocataire_gir_obj->where('type_visite','=',$type_visite);
        $allocataire_gir=$allocataire_gir_obj->orderby('id','desc')->limit(1)->first();  
        if(!$allocataire_gir) return "";
        return $allocataire_gir;
    }

    public function getLastEvaluationValue($type_aide,$type_visite,$champ) {
        $res="";
        if($champ=="GIR") {
            $allocataire_gir=$this->getGetLastAGGIR($type_aide,$type_visite);
            if($allocataire_gir) $res=$allocataire_gir->groupe;
        }
        if($champ=="GIR_OBS") {
            $allocataire_gir=$this->getGetLastAGGIR($type_aide,$type_visite);
            if($allocataire_gir) $res=$allocataire_gir->observations;
        }

        if($champ=="SCORE_FRAGILITE") {
            $allocataire_fragilite=$this->getGetLastFragilite($type_visite);
            if($allocataire_fragilite) $res=$allocataire_fragilite->score;
        }
        if($champ=="TAUX_HANDICAP") {
            $allocataire_handicap=$this->getGetLastHandicap($type_visite);
            if($allocataire_handicap) $res=$allocataire_handicap->tx_handicap;
        }


        return $res;
    }

    public function GetLastEvaluationSociale() {
        $allocataire_visite=$this->getGetLastEvaluation("SOC");
        if(!$allocataire_visite) return "";
        return $allocataire_visite->tx_handicap;
    }

    public function getPeriodeDroits($id_commission) {
        //recherche du droit
        $allocataire_commission=AllocataireCommission::find($id_commission);
        if(!$allocataire_commission) return "";
        $type_aide= $allocataire_commission->type_aide;
        $date_commission=$allocataire_commission->DateCommissionUS;
        $allocataires_droits=AllocataireDroit::
           whereRaw("id_allocataire=".$this->id." AND type='".$type_aide."'".
                " AND (date_fermeture >= '".$date_commission."' OR date_fermeture is null)".
                " AND date_ouverture is not null")
            ->orderby("date_ouverture","DESC")->orderby("id","DESC")
            ->first();
        if(!$allocataires_droits) return "";
        return $allocataires_droits->Periode;
    }

    /***************/
    /* HANDICAP     */
    /***************/
    public function getGetLastHandicap($type_visite="") {
        $allocataire_handicap_obj=AllocataireVisite::where('id_allocataire','=',$this->id)
            ->where('type_aide','=','APH');
        if($type_visite) $allocataire_handicap_obj=$allocataire_handicap_obj->where('type_visite','=',$type_visite);
        $allocataire_handicap=$allocataire_handicap_obj->orderby('date_visite','desc')->limit(1)->first();
        if(!$allocataire_handicap) return "";
        return $allocataire_handicap;
    }

    /***************/
    /* FRAGILITE     */
    /***************/

    public function getGetLastFragilite($type_visite="") {
        $allocataire_fragilite_obj=AllocataireFragilite::where('id_allocataire','=',$this->id)
            ->where('statut','=','VAL');

        if($type_visite) $allocataire_fragilite_obj=$allocataire_fragilite_obj->where('type_visite','=',$type_visite);
        $allocataire_fragilite=$allocataire_fragilite_obj->orderby('id','desc')->limit(1)->first();
        if(!$allocataire_fragilite) return "";
        return $allocataire_fragilite;
    }

    public function getScoreLastAttribute()
    {
        $allocataire_fragilite=$this->getGetLastFragilite();
        if(!$allocataire_fragilite) return 0;
        return $allocataire_fragilite->Points;
    }

    public function LastFragiliteDelay() {
        $nbj=0;
        $allocataire_fragilite=$this->getGetLastFragilite();
        if($allocataire_fragilite) {
            $date_fragilite=$allocataire_fragilite->date_evaluation;
            $t_result=MyApp::getDateDiffToday($date_fragilite);
            $nbj=$t_result["j"]+($t_result["m"]*30+$t_result["a"]*365);
        }
        return $nbj;
    } 

    public function getColorLastFragiliteAttribute() {
        $allocataire_fragilite=$this->getGetLastFragilite();
        if(!$allocataire_fragilite) return "black;";

        return $allocataire_fragilite->FragiliteColor;
    }

    /***************/
    /* GIR     */
    /***************/

    public function LastGirDelay($type_aide,$type_visite="") {
        $nbj=0;
        $allocataire_gir=$this->getGetLastAGGIR($type_aide);
        if($allocataire_gir) {
            $date_gir=$allocataire_gir->date_evaluation;
            $t_result=MyApp::getDateDiffToday($date_gir);
            $nbj=$t_result["j"]+($t_result["m"]*30+$t_result["a"]*365);
        }
        return $nbj;
    } 

    public function getColorLastGir($type_aide,$type_visite="") {
        $allocataire_gir=$this->getGetLastAGGIR($type_aide,$type_visite);
        if(!$allocataire_gir) return "black;";

        return $allocataire_gir->GirColor;
    }

    /************************************/
    /* COMMISSION                       */
    /************************************/
    public function getLastCommission($type_aide="",$avis="O") {
        $allocataire_commission_obj=AllocataireCommission::where('id_allocataire',"=",$this->id);
        if($type_aide) $allocataire_commission_obj=$allocataire_commission_obj->where("type_aide","=",$type_aide);
        if($avis) $allocataire_commission_obj=$allocataire_commission_obj->where("avis","=",$avis);
        
        $allocataire_commission=$allocataire_commission_obj
            ->orderby("date_commission","DESC")
            ->first();
        if(!$allocataire_commission) return null;
        return $allocataire_commission;
    }

    public function getTauxReconnuLastCommission($type_aide) {
        $allocataire_commission=$this->getLastCommission($type_aide);
        if(!$allocataire_commission) return null;
        return $allocataire_commission->taux_reconnu;
    }

    public function getDateLastCommission($type_aide,$avis="O") {
        $allocataire_commission=$this->getLastCommission($type_aide,$avis);
        if(!$allocataire_commission) return null;
        return $allocataire_commission->DateCommissionUS;
    }

    
    //Allocataires_commissions : Ajoute une commission
    public function addCommission($type_aide,$date_commission,$observations="") {
        //Controle si droit existe pas encore
        if($this->hasAide($type_aide)) return "";
        //Check existe pas déjà
        $allocataire_last_commission=$this->getLastCommission($type_aide,null);
        if($allocataire_last_commission && !$allocataire_last_commission->avis) return false; //Si il n'y a pas d'avis donnée sur la derniere commission, elle est encous, donc pas de création
        //Recherche si elle existe déjà
        $allocataire_commission=AllocataireCommission::where("id_allocataire","=",$this->id)
            ->where("type_aide","=",$type_aide)->where("date_commission","=",$date_commission)->first();
        //Sinon création
        if(!$allocataire_commission) {
            $allocataire_commission = new AllocataireCommission;
            $allocataire_commission->id_allocataire  = $this->id;
            $allocataire_commission->type_aide  = $type_aide;
            $allocataire_commission->date_commission = $date_commission;
            $allocataire_commission->observations = $observations;
            $allocataire_commission->save();
        }
        return $allocataire_commission;
    }

    /***************/
    /* ABSENCE W&F         */
    /***************/
    public function getDureeAbsence()
    {
        $date_debut=$this->attributes['date_depart_wf'];
        $t=MyApp::getDateDiffToday($date_debut);
        $nb_ans=$t['a'];$nb_mois=$t['m'];$nb_jours=$t['j'];
        $res="";
        if($nb_ans>0) $res.=$nb_ans."a/";
        if($nb_mois>0) $res.=$nb_mois."m/";
        $res.=$nb_jours."j";
        return $res;
    }
    public function getDureePresence()
    {
        $date_debut=$this->attributes['date_arrivee_wf'];
        $t=MyApp::getDateDiffToday($date_debut);
        $nb_ans=$t['a'];$nb_mois=$t['m'];$nb_jours=$t['j'];
        $res="";
        if($nb_ans>0) $res.=$nb_ans."a/";
        if($nb_mois>0) $res.=$nb_mois."m/";
        $res.=$nb_jours."j";
        return $res;
    }

    public function getDureeAbsencejour()
    {
        if(!$this->attributes['date_depart_wf']) return "";
        $date_debut=$this->attributes['date_depart_wf'];
        $date_fin=date('Y-m-d');
        $nb=MyApp::getNbJours($date_debut,$date_fin);
        return $nb;
    }

    public function getDureePresencejour()
    {
        if(!$this->attributes['date_arrivee_wf']) return "";
        $date_debut=$this->attributes['date_arrivee_wf'];
        $date_fin=date('Y-m-d');
        $nb=MyApp::getNbJours($date_debut,$date_fin);
        return $nb;
    }



    /***************/
    /* Droits   && AIDES*/
    /***************/
    public function getHasDroitsOuverture($type_aide,$date_ref="",$id_exclus="")
    {
        if(!$date_ref) $date_ref=date("Y-m-d");

        $allocataires_droits_obj=AllocataireDroit::
                whereRaw('date_ouverture<="'.$date_ref.'" AND (date_fermeture is NULL OR date_fermeture>"'.$date_ref.'")')
                ->where('type','=',$type_aide)
                ->where('id_allocataire','=',$this->id);

        //Si mode update on exclu la fiche en cours
        if($id_exclus) $allocataires_droits_obj=$allocataires_droits_obj->where('id','<>'.$id_exclus.')');
        $allocataires_droits=$allocataires_droits_obj->orderby('id_allocataire','ASC')->orderby('date_ouverture','DESC')->first();
        
        if(!$allocataires_droits) return false;
        else {
            if(!$allocataires_droits->date_ouverture) return false;
            else return true;
        }
    }

    public function getAllocataireDroitOuvert($type_aide,$date_ref="")
    {
        if(!$date_ref) $date_ref=date("Y-m-d");
        //'ATT'=>'Droits non ouverts','FER'=>'Droits fermés','OUV'=>'Droits ouverts','NDF'=>'Dates non définies'
        $msg="";
        $allocataires_droits=AllocataireDroit::
            whereRaw('date_ouverture<="'.$date_ref.'" AND (date_fermeture is NULL OR date_fermeture>"'.$date_ref.'")')
            ->where('type','=',$type_aide)
            ->where('id_allocataire','=',$this->id)
            ->orderby('id_allocataire','ASC')->orderby('date_ouverture','DESC')
            ->first();
        if(!$allocataires_droits) return "";
        else {
            if(!$allocataires_droits->date_ouverture) return "";
        }
        return  $allocataires_droits;
    }

    public function getDroitsOuverture($type_aide,$date_ref="")
    {
        if(!$date_ref) $date_ref=date("Y-m-d");
        //'ATT'=>'Droits non ouverts','FER'=>'Droits fermés','OUV'=>'Droits ouverts','NDF'=>'Dates non définies'
        $msg="";
        $allocataires_droits=$this->getAllocataireDroitOuvert($type_aide,$date_ref);
        if(!$allocataires_droits) $msg="NDF";
        else {
            if(!$allocataires_droits->date_ouverture) $msg="FER";
            else $msg="OUV";
        }
        return $msg;
    }

    public function getDroitsOuvertureBadge($type_aide,$date_ref="",$badge=false)
    {
        if(!$date_ref) $date_ref=date("Y-m-d");
        //'ATT'=>'Droits non ouverts','FER'=>'Droits fermés','OUV'=>'Droits ouverts','NDF'=>'Dates non définies'
        $msg="";
        $allocataires_droits=AllocataireDroit::
            whereRaw('date_ouverture<="'.$date_ref.'" AND (date_fermeture is NULL OR date_fermeture>"'.$date_ref.'")')
            ->where('type','=',$type_aide)
            ->where('id_allocataire','=',$this->id)
            ->orderby('id_allocataire','ASC')->orderby('date_ouverture','DESC')
            ->first();
        if(!$allocataires_droits) $msg="NDF";
        else {
            if(!$allocataires_droits->date_ouverture) $msg="FER";
            else $msg="OUV";
        }
        if($msg) {
            if($badge) {
                if($msg!="OUV") $msg="<span class='badge badge-danger right'>". MyApp::DROITS_OUVERTURE[$msg]."</span>";
                else $msg="<span class='badge badge-success right'>". MyApp::DROITS_OUVERTURE[$msg]."</span>";
            } else $msg=MyApp::DROITS_OUVERTURE[$msg];
        }

        return $msg;
    }


    public function getSituationWF()
    {
        $delais_presence=MyApp::DUREE_ALERTE_PRESENCE; //90j
        $delais_absence=MyApp::DUREE_ALERTE_ABSENCE;; //90j
        $presence_jours=$this->getDureePresencejour();
        $absence_jours=$this->getDureeAbsencejour();
        if($presence_jours && $absence_jours) return "-";

        $msg="";
        if(!$absence_jours && $presence_jours) {
            if($presence_jours>30) $presence_jours=$this->getDureePresence();
            else $presence_jours.="j";
            $msg="Présence depuis ".$presence_jours;
        }
        elseif($absence_jours) {
            if($absence_jours>30) $absence_jours=$this->getDureeAbsence();
            else $absence_jours.="j";
            $msg="Absence depuis ".$absence_jours;
        }
        return $msg;
    }

    //Allocataires_droits : ferme droit
    public function setFermeDroit($type_aide,$date_ferme="") {
        //Controle si droit existe pas encore
        if(!$this->hasAide($type_aide)) return "";
        $allocataire_droit=$this->getAllocataireDroitsEncours($type_aide);
        if(!$allocataire_droit) return "";
        $allocataire_droit->date_fermeture =($date_ferme)?$date_ferme:date('Y-m-d');
        $allocataire_droit->save();
        return $allocataire_droit;
    }

    //Allocataires_droits : ferme droit
    public function setRouvreDroit($type_aide,$date_ouverture="") {
        //Recherche avec date du jour comprise !!!
        $date_ref=date("Y-m-d");
        $allocataire_droit=AllocataireDroit::
            whereRaw('date_demande IS NOT NULL AND (date_ouverture<="'.$date_ref.'" OR date_ouverture is NULL) AND (date_fermeture is NULL OR date_fermeture>="'.$date_ref.'")')
            ->where('type','=',$type_aide)->where('id_allocataire','=',$this->id)->orderby('id','DESC')->first();
        if(!$allocataire_droit) return "";
        $allocataire_droit->date_fermeture =($date_ouverture)?$date_ouverture:null;
        $allocataire_droit->save();
        return $allocataire_droit;
    }

    //Allocataires_droits : Add droit
    public function addDroit($type_aide,$observations=null) {
        //Controle si droit existe pas encore
        if($this->hasAide($type_aide)) return "";
        //Check existe pas déjà
        $allocataire_droit=AllocataireDroit::where("id_allocataire","=",$this->id)
            ->where("type","=",$type_aide)->where("date_demande","=",date('Y-m-d'))
            ->whereNull("date_ouverture")->whereNull("date_fermeture")->first();
        if(!$allocataire_droit) $allocataire_droit = new AllocataireDroit;
        $allocataire_droit->id_allocataire  = $this->id;
        $allocataire_droit->type  = $type_aide;
        $allocataire_droit->date_demande = date('Y-m-d');
        $allocataire_droit->date_ouverture = date('Y-m-d');
        $allocataire_droit->date_fermeture =null ;
        $allocataire_droit->observations = $observations;
        $allocataire_droit->motif_refus =null ;
        $allocataire_droit->motif_fermeture =null ;
        $allocataire_droit->save();
        return $allocataire_droit;
    }

    //Allocataires_droits : Droit OUverts
    public function getIsDroitOuvert($aide,$date_ref="") {
        if(!$date_ref) $date_ref=Date('Y-m-d');
        $allocataires_droits=AllocataireDroit::
            whereRaw("date_ouverture<='".$date_ref."' AND (date_fermeture is NULL OR date_fermeture>'".$date_ref."')")
            ->where('type','=',$aide)
            ->where('id_allocataire','=',$this->id)
            ->orderby('date_ouverture','DESC')
            ->orderby('id','DESC')
            ->first();
        if(!$allocataires_droits) return false;
        return true;
    }

    //Allocataires_droits : Liste droits
    public function getDroitsListe() {
        $lst="";$t_droits=[];
        $allocataires_droits=AllocataireDroit::where('id_allocataire','=',$this->id)->get();
        foreach($allocataires_droits as $allocataire_droit) {
            if($this->getIsDroitOuvert($allocataire_droit->type)) { 
                if(!in_array($allocataire_droit->type,$t_droits)) {
                    $t_droits[]=$allocataire_droit->type;
                    $lst.=($lst?",":"").$allocataire_droit->type;
                }
            }
        }
        return $lst;
    }


    public function getInfoAides($sep="<br/>")
    {
      $lib="";
      //Aide à l'enfant
      $lib.=(($lib!="")?$sep:"").$this->getInfoDetailAides();
      $lib.=(($lib!="")?$sep:"")."Date Naissance : <b>".$this->DateNaissance.(($this->certificat==9)?"-":" - ".$this->Age." ans")."</b>";
      if($this->sexe) $lib.=$sep."Sexe : <b>".MyApp::SEXE[$this->sexe]."</b>";
      if($this->id_CPSWF) $lib.=$sep."CPSWF : <b>".$this->id_CPSWF."</b>";
      if($this->certificat_enfant) $lib.=$sep."Cert.: <b>".$this->CertificatEnfantLibelle."</b>";
      if($this->id_CPSWF) $lib.=$sep."Statut : <b>".$this->id_CPSWF."</b>";
      if($this->EnfantLienParente)  $lib.=$sep."Lien de parenté : <b>".$this->EnfantLienParente."</b>";
      return $lib;
    }

    public function getInfoDetailAides($card=true,$sep="<br/>")
    {
        //Aide à l'enfant
        $t_aides=explode(",",$this->getDroitsListe());
        $txt="";
        foreach($t_aides as $aide) {
            $lib=""; 
            if(array_key_exists($aide,MyApp::TYPES_AIDES)) {
                $lib=MyApp::TYPES_AIDES[$aide];
                if(!$card)  $txt.=($txt?",":"").$lib;
                else $txt.="<span class='right badge badge-".MyApp::COLOR_AIDES[$aide]."' style='background-color:".MyApp::COLOR_AIDES[$aide].";' >".$lib."</span>";
            }
        }
        return $txt;
    }

    public function hasAide($type_aide)
    {
        return $this->getIsDroitOuvert($type_aide); 
    }

    //Sur le dernier droit
    public function getDateOuverture($type_aide)
    {
        $msg="";
        $allocataires_droits=AllocataireDroit::where('type','=',$type_aide)
            ->where('id_allocataire','=',$this->id)->orderby('date_ouverture','DESC')->first();
        if(!$allocataires_droits) return "";
        return $allocataires_droits->DateOuverture;
    }

    //Sur le dernier droit
    public function getDateFermeture($type_aide)
    {
        $msg="";
        $allocataires_droits=AllocataireDroit::where('type','=',$type_aide)
            ->where('id_allocataire','=',$this->id)->orderby('date_ouverture','DESC')->first();
        if(!$allocataires_droits) return "";
        return $allocataires_droits->DateFermeture;
    }

    //Sur le dernier droit : Périoed
    public function getInfoDroit($type_aide)
    {
        $txt="";
        //$date_fermeture=$this->getDateFermeture($type_aide);
        //if(!$date_fermeture) return "";
        $allocataires_droits=AllocataireDroit::where('type','=',$type_aide)->where('id_allocataire','=',$this->id)->orderby('date_ouverture','DESC')->orderby('id','DESC')->first();
        if(!$allocataires_droits) return "";
        if(!$allocataires_droits->DateOuverture) return "<span class='text-danger'>Demande&nbsp;sans date d'ouverture</span>";
        //$periode="Du ".$allocataires_droits->DateOuverture;
        //if($allocataires_droits->DateFermeture) $periode.=" au ".$allocataires_droits->DateFermeture;
        //else $periode.=" sans Date de fin";

        if($allocataires_droits->DateFermetureUS>=date('Y-m-d') || !$allocataires_droits->DateFermetureUS)  {
            if($allocataires_droits->DateouvertureUS<date('Y-m-d')) $txt="<span class='text-success'>Ouvert depuis le ".$allocataires_droits->DateOuverture;
            else $txt="<span class='text-primary'>Ouverture&nbspprévue&nbsp;le ".$allocataires_droits->DateOuverture;     
            if(!$allocataires_droits->DateFermetureUS) $txt.="";//" sans&nbsp;limite";
            $txt.="</span>";
        } else {
           $txt="<span class='text-danger'>"."Du&nbsp;".$allocataires_droits->DateOuverture." au&nbsp;".$allocataires_droits->DateFermeture."</span>"; 
        }
        return $txt;

        /*
        if($allocataires_droits->DateFermetureUS<date('Y-m-d')) $txt="<span class='text-danger'>".$periode."</span>";
        else {
            if($allocataires_droits->DateouvertureUS<date('Y-m-d')) $txt="<span class='text-primary'>Ouvert depuis le ".$allocataires_droits->DateOuverture."</span>";
            else $txt="<span class='text-primary'>Ouverture prévue le ".$allocataires_droits->DateOuverture."</span>";
        }*/
        return $txt;
    }


    //Recherche dernier droit
    public function getLastDroit($type_aide)
    {
        $allocataires_droits=AllocataireDroit::where('type','=',$type_aide)->where('id_allocataire','=',$this->id)
            ->orderby('date_demande','DESC')->orderby('date_ouverture','DESC')->orderby('id','DESC')->first();
        if(!$allocataires_droits) return "";
        return $allocataires_droits;
    }

    //Sur le dernier droit : Observation
    public function getObsDroit($type_aide)
    {
        $allocataires_droits=$this->getLastDroit($type_aide);
        if(!$allocataires_droits) return "";
        return $allocataires_droits->observations;
    }

    //Sur le dernier droit : Date Demande
    public function getDateDemande($type_aide)
    {
        $allocataires_droits=$this->getLastDroit($type_aide);
        if(!$allocataires_droits) return "";
        return $allocataires_droits->DateDemande;
    }

    /* Fiche allocatauire droit avec demande en cours */
    public function getAllocataireDroitsEncours($type_aide,$ouvert=true,$avecdemande=true)
    {
        $date_ref=date("Y-m-d");
        $msg="";
        $condition="type='".$type_aide."' AND id_allocataire='".$this->id."' ";
        if($ouvert) $condition.=' AND (date_ouverture<="'.$date_ref.'" OR date_ouverture is NULL) AND (date_fermeture is NULL OR date_fermeture>"'.$date_ref.'") ';
        if($avecdemande) $condition.=' AND date_demande IS NOT NULL ';
        
        $allocataire_droit=AllocataireDroit::
            whereRaw($condition)
            ->orderby('date_ouverture','DESC')
            ->orderby('id','DESC')
            ->first();
        return $allocataire_droit;
    }

    public function getMotifRefus($type_aide,$refusseul=true,$ouverts=true) //derneir refus
    {
        $allocataires_droits=$this->getAllocataireDroitsEncours($type_aide,$ouverts,false);
        if(!$allocataires_droits) return "";
        $motif_fermeture="";
        if(!$refusseul) {
            if($allocataires_droits->date_fermeture) $motif_fermeture=$allocataires_droits->motif_fermeture;
            if($motif_fermeture) $motif_fermeture=MyApp::getZBaseLibelle("BEN_RAISONS_FERMETURE",$motif_fermeture,'');
        }
        $motif_refus=$allocataires_droits->motif_refus;
        
        if($motif_refus)  $motif_refus=MyApp::getZBaseLibelle("BEN_RAISONS_REFUS",$motif_refus,'');
        $lib=$motif_refus?$motif_refus:$motif_fermeture; //Prend motif refs si les 2
        
        return $lib;
    }

    public function getMotifFinDroit($type_aide,$ouverts=true) //derneir refus
    {
        $allocataires_droits=$this->getAllocataireDroitsEncours($type_aide,$ouverts,false);
        if(!$allocataires_droits) return "";
        return strtoupper($allocataires_droits->motif_fermeture);
    }

    /***************/
    /* CONJOINT  */
    /***************/
    /* Retourne le conjoint */
    public function getConjoint()
    {
        $conjoint=Allocataire::find($this->id_conjoint);
        if(!$conjoint) return "";
        return $conjoint;
    }
    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    public function getConjointNomCompletAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->NomComplet;
    }
    /* Retourne StatutConjoint conjoiunt ou titulaire */
    public function getStatutConjointAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->statut;
    }
    /* Retourne l'id du partanaire, conjoiunt ou titulaire */
    public function getConjointNomStatutCompletAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->NomComplet." (".$conjoint->statut.")";
    }
    /* Retourne l'IdCPSWFPAD du partanaire, conjoiunt ou titulaire */
    public function getConjointIdCPSWFPADAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->IdCPSWFPAD;
    }
    /* Retourne la date de naissance du partanaire, conjoiunt ou titulaire */
    public function getConjointDateNaissanceAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->DateNaissance;
    }
    

    /* conjoint : RETRAITE             */
    public function getConjointMontantRetraiteCPSWFAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->MontantRetraiteCPSWF;
    }

    /* conjoint : Allcoations             */
    public function getConjointMontantAllocationsAttribute()
    {
        $conjoint=$this->getConjoint();
        if(!$conjoint) return "";
        return $conjoint->MontantAllocations;
    }

    /***************/
    /* FAMILLE      */
    /***************/
    public function getEnfantLienParenteAttribute()
    {
        //MAJ Lien parenté
        $id_famille=$this->id_famille;
        if(!$id_famille) {
            $famille =  $this->getFamilleResponsable();
            if($famille) $id_famille=$famille->id;
        }        
        $famille_enfant=FamilleEnfant::where("id_famille","=",$id_famille)->where("id_enfant","=",$this->id)->first();

        if(!$famille_enfant) return "";
        if(!isset(MyApp::FOYER_ROLES[$famille_enfant->lien_parente])) return "";

        return MyApp::FOYER_ROLES[$famille_enfant->lien_parente];
    }

    public function setFamille($id_famille)
    {
        $this->id_famille = $id_famille;
        return $this->save();
    }

    public function getFamille()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) $famille =  $this->getFamilleResponsable();

        if(!$famille) return []; 
        return $famille;
    }

    public function getIdPADFamilleAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) $famille =  $this->getFamilleResponsable();
        
        if(!$famille) return ""; 
        return $famille->IdPAD;
    }

    /* TITULAIRE */
    public function getIsTitulaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return false; 
        if($famille->id_titulaire==$this->id) return true;
        return false;
    }
    public function getFamilleIdTitulaireAttribute()
    {
        $famille=Famille::find($this->id_famille);
        if(!$famille) return ""; 
        return $famille->id_titulaire;
    }

    public function getNomCompletTitulaireAttribute()
    {
        $titulaire=Allocataire::find($this->id_titulaire);
        if(!$titulaire) return "";
        return  $titulaire->NomComplet;
    }

    /* CONJOINT */
    public function getConjointFamille()
    {
        $famille=$this->getFamille();
        if(!$famille) return ""; 
        $conjoint=$famille->getConjoint();
        if(!$conjoint) return "";
        return $conjoint;
    }

    public function getIsConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return false; 
        if($conjoint_famille->id==$this->id) return true;
        return false;
    }


    public function getFamilleIdConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return "";
        return  $conjoint_famille->id;
    }

    public function getRetraiteConjointAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return ""; 

        //Types ressources pour calcul retraite
        $types=["RES_RET"];
        return $conjoint_famille->getMontantRessourcesSpec($types);
        //return $conjoint_famille->montant_retraite;
    }

    public function getFamilleConjointNomCompletAttribute()
    {
        $conjoint_famille=$this->getConjointFamille();
        if(!$conjoint_famille) return "";
        return  $conjoint_famille->NomComplet;
    }

    public function getStatutParentAttribute()
    {
        if($this->sexe=="M") return "Père";
        if($this->sexe=="F") return "Mère";
        return "";
    }

    /***************/
    /* Parents     */
    /***************/
    public function getNomCompletParent1Attribute()
    {
        $parent=Allocataire::find($this->id_parent1);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }
    public function getNomCompletParent2Attribute()
    {
        $parent=Allocataire::find($this->id_parent2);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }


   /***************/
    /* Dossier     */
    /***************/
    public function getStatutDossierLibelleAttribute()
    {
      $lib=MyApp::getZBaseLibelle("BEN_STATUT_DOSSIER",$this->statut_dossier,'');

      return $lib;
    }
    public function getStatutDossierLibelleCourtAttribute()
    {
      $lib=MyApp::getZBaseLibelle($nom,$this->statut_dossier,'court');
      return $lib;
    }


    /***************/
    /* RESPONSABLES   pour Enfants  */
    /***************/
    public function getIdResponsable1Attribute()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant','=',$this->id)
            //->where('lien_parente','=','ENF')
            ->first();
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        $titulaire=$famille->getTitulaire();
        // A FINIR //
        return  $titulaire->id;
    }

    public function getFamilleResponsable()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant','=',$this->id)
            //->where('lien_parente','=','ENF')
            ->first();
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        if(!$famille) return "";
        return  $famille;
    }

    public function getIdPADFamilleResponsableAttribute()
    {
        $famille=$this->getFamilleResponsable();
        if(!$famille) return "";
        return  $famille->IdPAD;
    }

    public function getNomCompletResponsable1Attribute()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant','=',$this->id)
            //->where('lien_parente','=','ENF')
            ->first();
            
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        $titulaire=$famille->getTitulaire();
        // A FINIR //
        return  $titulaire->NomComplet;
    }
    public function getNomCompletResponsable2Attribute()
    {
        $parent=Allocataire::find($this->id_parent2);
        if(!$parent) return "";
        return  $parent->NomComplet;
    }

    /***************/
    /* ENFANTS     */
    /***************/
    // Enfants de la famille sur Age 
    public function getEnfantsFamilleLESS($age=21)
    {
		$famille=Famille::find($this->id_famille);
        if(!$famille) return "";
        return $famille->getEnfantsLESS($age);
    }

    //Renvoi la famille du Enfant/allocataire
    public function getFamilleEnfant()
    {
        $famille_enfant=FamilleEnfant::where('id_enfant',"=",$this->id)->first();
        if(!$famille_enfant) return "";
        $famille=Famille::find($famille_enfant->id_famille);
        if(!$famille)  return [];
        return $famille;
    }

    //Renvoi l'identifiant de la famille du membre/allocataire
    public function getIdFamilleEnfantAttribute()
    {
        $famille=$this->getFamilleEnfant();
        if(!$famille)  return [];
        
        return str_pad($famille->id, 5, "0", STR_PAD_LEFT);
    }

    public function getEnfants()
    {
        $enfants=Allocataire::where('id_parent1',"=",$this->id)->orWhere('id_parent2',"=",$this->id)->get();
        return $enfants;
    }

    public function getEnfantsFamille()
    {
        $t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->pluck("familles_enfants.id_enfant")->toArray();
        $enfants=Allocataire::whereIn('id',$t_id_enfants)->get();
        return $enfants;
    }

    public function getNbEnfantsAttribute()
    {
        $nb=DB::table('familles_enfants')->where('id_famille', '=', $this->id_famille)->count();
        return $nb;
    }

    public function getNbEnfants($date)
    {
      $nb=DB::table('allocataires')->where("date_naissance","<",$date)->where("id_parent1","=",$this->id)->count();
      $nb+=DB::table('allocataires')->where("date_naissance","<",$date)->where("id_parent2","=",$this->id)->count();
      return $nb;
    }

    public function getNbEnfantsLESS($age=21)
    {
		$famille=Famille::find($this->id_famille);
        if(!$famille) return 0;
        return $famille->NbEnfantsLESS;
    }

    public function getCertificatEnfantLibelleAttribute()
    {
        $liste_certificats=MyApp::getZBase("CERT_ENFANTS");

        if(!isset($liste_certificats[$this->certificat_enfant])) return "";
        return$liste_certificats[$this->certificat_enfant];
    }
    
    public function getNewCertificatAttribute()
    {
        $date=$this->attributes['date_naissance'];
        $age=$this->Age;
        $certif=$this->certificat_enfant ;
        if($certif=='') $certif=0;
        $res=$certif;
        if(($certif==1)||($certif==2)||($certif==3)) $res=8;
        if(($certif==4)) $res=8;

        return $res;
    }

    /***************/
    /* ENFANTS HORS FOYER    */
    /***************/
    public function getMembres()
    {
        $familles_membres=FamilleMembre::where('id_membre',"=",$this->id)->get();
        if(!$familles_membres) return "";
        return $familles_membres;
    }


    /***************/
    /* MEMBRES    */
    /***************/
    /*
    public function getMembres()
    {
        $familles_membres=FamilleMembre::where('id_membre',"=",$this->id)->get();
        if(!$familles_membres) return "";
        return $familles_membres;
    }*/

    public function getMembreListeFamille()
    {
       $familles_membres=$this->getMembres();
       $liste_famille=[];
       foreach($familles_membres as $famille_membre) 
            $liste_famille[$famille_membre->id_famille]=$famille_membre->id_famille;

       return $liste_famille;
    }


    //Renvoi la famille du membre/allocataire
    public function getFamilleMembre()
    {
        $famille_membre=FamilleMembre::where('id_membre',"=",$this->id)->first();
        if(!$famille_membre) return "";
        $famille=Famille::find($famille_membre->id_famille);
        if(!$famille)  return [];
        return $famille;
    }

    //Renvoi l'identifiant de la famille du membre/allocataire
    public function getIdFamilleMembreAttribute()
    {
        $famille=$this->getFamilleMembre();
        if(!$famille)  return [];
        
        return str_pad($famille->id, 5, "0", STR_PAD_LEFT);
    }


    public function getInfoLien($all=false,$sep="<br/>")
    {
        $msg="";;
        //Verifs liens
        //Comptes
        $nb  = DB::table('allocataires_comptes')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des comptes bancaires sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Droits
        $nb  = DB::table('allocataires_droits')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des Droits sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Equipements
        $nb  = DB::table('allocataires_equipements')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des Equipements sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Fragilites
        $nb  = DB::table('allocataires_fragilites')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des Fragilites sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //GIR
        $nb  = DB::table('allocataires_girs')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des GIRs sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

       //Humaines
        $nb  = DB::table('allocataires_humaines')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des Besoins humains sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Ressources
        $nb  = DB::table('allocataires_ressources')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Des ressources sont encore associés à cet allocataire.";
        if(!$all && $msg) return $msg;

        //Famille
        $nb  = DB::table('familles')->where('id_titulaire', '=', $this->id)->count();
        $nb  += DB::table('familles')->where('id_conjoint', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Cet allocataire est encore associé à une Famille.";
        if(!$all && $msg) return $msg;

        //Aidant
        $nb  = DB::table('familles_aidants')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Aidant dans une Famille";
        if(!$all && $msg) return $msg;

        //Enfant
        $nb  = DB::table('familles_enfants')->where('id_enfant', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Enfant dans une Famille";
        if(!$all && $msg) return $msg;

        //MEmbre
        $nb  = DB::table('familles_membres')->where('id_membre', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Membre dans une Famille";
        if(!$all && $msg) return $msg;

        //Versements
        $nb  = DB::table('versements')->where('id_allocataire', '=', $this->id)->count();
        $nb  += DB::table('versements')->where('id_conjoint', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Un ou plusieurs versement";
        if(!$all && $msg) return $msg;

        //Versements Enfant
        $nb  = DB::table('versements_enfants')->where('id_enfant', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Enfant dans un versement";
        if(!$all && $msg) return $msg;

        //Versement Prepa
        $nb  = DB::table('versements_prepa')->where('id_allocataire', '=', $this->id)->count();
        if($nb>0) $msg.=$sep."Versement en préparation";

        if($msg) $msg="La suppression est interdite car des éléments liés :  ".$msg;
        return $msg;
    }

    /**
     * Fiche Supprimable ?
     */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("ALO_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;

        $msg=$this->getInfoLien();
        if($msg) return false;
        return true;
    }

    /***************/
    /* AAE     */
    /***************/
    public function  getPrimeAAEAttribute()
    {
        //Prime Exceptionnelle
        $montant_prime=MyApp::getPrimeExcept();
        $prime= $montant_prime*$this->NbEnfantsAAE;
        return $prime;
    }
    /**
     * Nombre d'enfants pour Aide Sociale
     */
    public function getNbEnfantsAAEAttribute()
    {
        if(!$this->IsTitulaire) return 0;
        $certif_aae=MyApp::getCertificatsAAE();
        $nb=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->count();


        return $nb;
    }

    /**
     * enfants avec AAE
     */
    public function  getEnfantsAAE()
    {
        if(!$this->IsTitulaire) return [];
        $certif_aae=MyApp::getCertificatsAAE();
        $t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->pluck("familles_enfants.id_enfant")->toArray();
        $enfants=Allocataire::whereIn('id',$t_id_enfants)->get();
        
        
        /*$t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$this->id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->pluck("familles_enfants.id_enfant")->toArray();

        
        $t_id_enfants=FamilleEnfant::join("allocataires","allocataires.id","=","familles_enfants.id_enfant")
            ->where('familles_enfants.id_famille','=',$id_famille )
            ->whereIn('certificat_enfant',$certif_aae)
            ->pluck("familles_enfants.id_enfant")->toArray();
        */

        
        return $enfants;
    }

    /**
     * Calcul AAE
     */
    public function  getCalculAAEAttribute()
    {
        $montant=MyApp::getMontantAAE($this->NbEnfantsAAE);
        return $montant;
    }
    
    /**
     * enfants de la famille
     */
    public function  getEnfantsListe($sep="<br/>",$age=21,$titulaire=true)
    {
        if($titulaire && !$this->IsTitulaire) return ""; // SI pas titulaire pas d'enfant associé
        $enfants=$this->getEnfantsFamilleLESS($age);
        if(!$enfants) return "";   
        $txt="";
		foreach($enfants as $enfant) {
            $certif=$enfant->Certificat;
            if(in_array($certif,MyApp::getCertificatsAAE()))  $certif="<span class='right badge badge-".MyApp::COLOR_AIDES["AAE"]."'>".$certif."</span>";
            else $certif="<span class='right badge badge-secondary'>".$certif."</span>";
			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->Age."a".($certif?"&nbsp;".$certif:")");
		}
        return $txt;
    }

    public function  getEnfantsPANListe($sep="<br/>")
    {
		$enfants=$this->getEnfantsEligiblePAN();
        $txt="";
		foreach($enfants as $enfant) {
            $t_age=$enfant->AgeMoisJour;
            if($t_age['m']<2) $t_id[]=$enfant->id;
			$txt.=(($txt)?$sep:"").$enfant->NomComplet."&nbsp;".$enfant->DateNaissance." (".$t_age['d']." jours)";
		}
        return $txt;
    }



    /***************/
    /* FILET SOCIAL    */
    /***************/
    // type_res=D pour détail du calcul
    public function  getCalculMontantFSOAttribute()
    {
        //$famille=$this->getFamille();
        //if($famille) {
        //    $montant=$famille->getCalculMontantFSO();
        //} else {
            $montant=$this->CalculFSO;

        //}
        return $montant;
    }


    //Renvoi le montant si Elligible FSO
    public function getCalculFSOAttribute()
    {
        //Si Motif Refus => 0
        $allocataire_droit=$this->getAllocataireDroitsEncours("FSO",true,false);
        if(!$allocataire_droit) return 0;
        if($allocataire_droit->motif_refus) return 0;

        $plafond_qf=MyApp::getParam("FSO_PLAFOND");

        if($this->qf>=$plafond_qf) return 0;
        $age_min=MyApp::FSO_AGE_MIN;
        $age_tranche=MyApp::FSO_AGE_TRANCHE;

        if($this->age<$age_min) return 0;
        $montant_base_moins=MyApp::getParam("FSO_MONTANT1");
        $montant_base_plus=MyApp::getParam("FSO_MONTANT2");
        
        if($this->age<$age_tranche) return $montant_base_moins;
        return $montant_base_plus;
    }


    /********************************/
    /* AIDE AUX PERSONENS AGGEES    */
    /********************************/
    public function  getCalculMontantAPAAttribute()
    {
        $montant=$this->CalculAPA;
        return $montant;
    }

    //Renvoi le montant si Elligible APA
    public function getCalculAPAAttribute()
    {
        //Si Motif Refus => 0
        $allocataire_droit=$this->getAllocataireDroitsEncours("APA",true,false);
        if(!$allocataire_droit) return 0;
        if($allocataire_droit->motif_refus) return 0;

        $montant_ressources=$this->MontantRessources;
        $conjoint=$this->getConjoint();
        if($conjoint) {
            $plafond_qf=MyApp::getParam("APA_PLAFOND");
            $montant_ressources+=$this->MontantRessourcesConjoint;
        }
        else {
            $plafond_qf=MyApp::getParam("APA_PLAFOND_IND");
        }

        $age_mini=MyApp::getParam("APA_AGE");
        if($montant_ressources>=$plafond_qf) return 0;
        if($this->age<$age_mini) return 0;

        $montant_base=MyApp::getParam("APA_MONTANT");


        return $montant_base;
    }



    /* ******************** */
    /* Prime à la naissance  
    /* ******************** */
    public function getEligiblePANAttribute()
    {
        //Recherche les enfants de moins de 2 mois
        $enfants=$this->getEnfantsFamille();
        foreach($enfants as $enfant) {
            if(($enfant->age<1 || $enfant->force_pan)&&(!$enfant->id_versement_pan)) { //Versement pas encore fait
                $t_age=$enfant->AgeMoisJour;
                if($t_age['m']<2 || $enfant->force_pan) return true;
                //ou if($t_age['d']<=30) return true;
            }
        }
        return false;
    }

    public function getEnfantsEligiblePAN()
    {
        //Recherche les enfants de moins de 2 mois
        $t_id=[];
        $enfants=$this->getEnfantsFamille();
        foreach($enfants as $enfant) {
            if(($enfant->age<1 || $enfant->force_pan)&&(!$enfant->id_versement_pan)) { //Versement pas encore fait
                $t_age=$enfant->AgeMoisJour;
                if($t_age['m']<2 || $enfant->force_pan) $t_id[]=$enfant->id;
                //ou if($t_age['d']<=30) return true;
            }
        }
        $enfants_pan=Allocataire::whereIn("id",$t_id)->get();
        return $enfants_pan;
    }

    public function getNbEnfantsEligiblePANAttribute()
    {
        //Recherche les enfants de moins de 2 mois
        $enfants_pan=$this->getEnfantsEligiblePAN();
        if(!$enfants_pan) return 0;
        return $enfants_pan->count();
    }

    /* Listes des Id enfants PAN */
    public function  getIdEnfantsEligiblePAN()
    {
        $txt="";
        $enfants_pan=$this->getEnfantsEligiblePAN();
        foreach($enfants_pan as $enfant) $txt=((!$txt)?'':',').$enfant->id;

        return $txt;
    }

    public function  getCalculPANAttribute()
    {
        $enfants_pan=$this->getEnfantsEligiblePAN();
        $nb=$enfants_pan->count();
        if($nb==0) return 0;
        $montant_base=MyApp::getParam("PAN_PRIME");

        return $montant_base*$nb;
    }
    


    /* ******************** */
    /* CPSWF             */
    /* ******************** */
    
    public function getSipreBeneficiaire()
    {
        if(!$this->id_cpswf) return "";
        $beneficiaire=SipreBeneficiaire::find($this->id_cpswf);
        if(!$beneficiaire) return "";
        return $beneficiaire;
    }
    /* RETRAITE             */
    public function getMontantRetraiteCPSWFAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->RetraiteMontant;
    }

    //Montant retraire
    public function getUpdatedAtCPSWFAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->UpdatedAt;
    }

    /* Allcoations             */
    public function getMontantAllocationsAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        
        if(!$beneficiaire) return "";
        
        return $beneficiaire->AllocationsMontant;
    }
    
    /* Allcoations / Enfants            */
    public function getEnfantsAllocations($sep="")
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        $enfants=$beneficiaire->getEnfantsAlloc($sep);
        return $enfants;
    }

    /* Salaires             */
    public function getMontantSalairesAttribute()
    {
        $beneficiaire=$this->getSipreBeneficiaire();
        if(!$beneficiaire) return "";
        return $beneficiaire->SalairesMontant;
    }

    /* ******************** */
    /* VERSEMENTS  
    /* ******************** */
    public function getLastVersement($type_aide)
    {
        $versement=Versement::where("id_allocataire","=",$this->id)
        ->where("type","=",$type_aide)
        ->orderby("date","DESC")->first();
        if(!$versement) return false;
        return $versement;
    }

    /* ******************** */
    /* INDUS et RM  
    /* ******************** */
    public function getNbReductionMandatAttribute()
    {
        $nb=DB::table('reductions_mandats')
        ->join('versements','versements.id','=','reductions_mandats.id_versement')
        ->where('versements.id_allocataire','=',$this->id)->count();
        
        return $nb;
    }
    public function getNbIndusAttribute()
    {
        $nb=DB::table('indus_detail')
        ->join('versements','versements.id','=','indus_detail.id_versement')
        ->where('versements.id_allocataire','=',$this->id)->count();
        
        return $nb;
    }
 
    //Renvoi vrai si un indus est en cours
    public function gethasIndusEncoursAttribute()
    {
        $nb_indus=Indu::where('id_allocataire','=',$this->id)->where('statut','=','TRA')->count();
        return $nb_indus;
    }

    //Renvoi le montant du prélèvement sur Indus
    public function getPrelevement($aide,$date)
    {
        $indus_prelevement=InduPrelevement::select("indus_prelevements.id")
            ->join("indus","indus.id","=","indus_prelevements.id_indu")
            ->where('indus.id_allocataire','=',$this->id)
            ->where('indus_prelevements.aide','=',$aide)
            ->where('indus_prelevements.date','like',substr($date,0,7).'%')->first();
        
        if(!$indus_prelevement) return "";
        $indus_prelevement=InduPrelevement::find($indus_prelevement->id);
        return $indus_prelevement;
    }

    //Renvoi le montant du prélèvement sur Indus
    public function getMontantPrelevement($aide,$date)
    {
        $indus_prelevement=$this->getPrelevement($aide,$date);
        if(!$indus_prelevement) return 0;
        return $indus_prelevement->montant;
    }

    /***************/
    /* RESSOURCES */
    /***************/
    public function getMontantRessourcesAttribute()
    {
        $date=date('Y-m-d');
        if($this->statut=="DCD") return 0;
        $ressources=AllocataireRessource::where("id_allocataire","=",$this->id)->where("date_fin",">",$date)->sum("montant");
        $ressources+=AllocataireRessource::where("id_allocataire","=",$this->id)->whereNull("date_fin")->sum("montant");

        return $ressources;
    }

    public function getMontantRessourcesSpec($liste=[])
    {
        $date=date('Y-m-d');
        if($this->statut=="DCD") return 0;

        $montant=0;

        $ressources=AllocataireRessource::
            where("id_allocataire","=",$this->id)->where("date_fin",">",$date)
            //->whereIn("type_ressource",$liste)
            ->get();

        foreach($ressources as $ressource) {
            if($ressource->date_fin) $montant+=$ressource->montant;
        }
        
        return $montant;
    }

    public function getQFAttribute()
    {
        $famille=$this->getFamille();
        if(!$famille) {
            return $this->MontantRessources;
        }
        //Si juste membre alors ressources perso
        $famille_membre=FamilleMembre::where('id_membre',"=",$this->id)->where('id_famille',"=",$famille->id)->first();
        if($famille_membre)  return $this->MontantRessources;
        
        return $famille->QF;
    }

    public function getFamilleNbPersonnesAttribute()
    {
        $famille=$this->getFamille();
        if(!$famille) return 1;
        return $famille->NbPersonnes;
    }

    public function getFamilleMontantRessourcesAttribute()
    {
        $famille=$this->getFamille();
        if($famille) return $famille->MontantRessources;
        return $this->MontantRessources;
    }

    public function getMontantRessourcesConjointAttribute()
    {
        $famille=$this->getFamille();
        if(!$famille) return "";
        if($this->IsTitulaire) $conjoint_famille=$famille->getConjoint();
        else $conjoint_famille=$famille->getTitulaire();
        
        if(!$conjoint_famille) return ""; 

        return $conjoint_famille->MontantRessources;
    }

    /* Denier versement sur période donnée et aide données pour "":Allocataire, "C"=>conjoint */
    public function getLastVersementAide($type_aide,$id_origine="",$delay="") {
            //INDUS 
        if($delay=="") $delay=MyApp::RESSOURCE_AIDES_DELAY;
        if($id_origine=="") $id_origine=$this->id;
        $versement=Versement::where('id_allocataire','=',$id_origine)->where('type','=',$type_aide)->orderby('num_imp','desc')->first();
        if(!$versement) return "";
        $nbj=MyApp::getDateDiffToday($versement->DateUS,true);
        if($nbj>$delay) return "";
        // Indus .. pt-être à faire
        /*
            $indu_detail=InduDetail::where('id_versement','=',$versement->id)->first();
            if($indu_detail) {
                $indu=Indu::where('id','=',$indu_detail->id_indus)->where('statut','<>','ENC')->first();
                if($indu) return "";
            }
        */
        return $versement;

    }
    


    public function getRessourcesSITAS()
    {
        $collect=new Collection;

        //Allocataire
        $t_aides=MyApp::TYPES_AIDES;
        foreach($t_aides as $key=>$libelle) {
            $versement=$this->getLastVersementAide($key);
            if($versement) {
                $versement->origine="Allocataire";
                $versement->NomAide=$libelle;
                $collect->push($versement);    
            }
        }
        //dd($collect);    
        //Conjoint
        $famille=$this->getFamille();
        if($famille) {
            $conjoint=$famille->getConjoint();
            if($conjoint) {
            if($conjoint->id==$this->id) $conjoint=$famille->getTitulaire();
                if($conjoint) {
                    foreach($t_aides as $key=>$libelle) {
                        $versement=$this->getLastVersementAide($key,$conjoint->id);
                        if($versement) {
                            $versement->origine="Conjoint";
                            $versement->NomAide=$libelle;
                            $collect->push($versement);    
                        }
                    }
                }
            }
        }

        return $collect;
    }



    /***********/
    /* BANQUES */
    /***********/
    public function getCompteAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        $RIB=$allocataire_compte->IBAN_pays.' '.$allocataire_compte->IBAN_cle.' '.$allocataire_compte->IBAN_banque.' '.$allocataire_compte->IBAN_guichet.' '.
        $allocataire_compte->IBAN_compte.' '.$allocataire_compte->IBAN_clerib;

        return $RIB;
    }

    public function getBanqueIdAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return null;
        return $allocataire_compte->id_banque;
    }

    public function getNomBanqueAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        $banque=Banque::find($allocataire_compte->id_banque);
        if(!$banque) return "";
        return $banque->nom;
    }

    public function getNomTitulaireCompteAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if(!$allocataire_compte) return "";
        return $allocataire_compte->titulaire;
    }
    
    public function getLastCompte()
    {
        $allocataire_compte=AllocataireCompte::where("id_allocataire","=",$this->id)
            ->where("actif","=","1")->orderby("id","DESC")->first();
            if(!$allocataire_compte) return "";
            return $allocataire_compte;
    }
    public function getIBANcompletAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";

        return $allocataire_compte->IBANcomplet;
    }

    public function getRIBcompletAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";

        return $allocataire_compte->RIBcomplet;
    }

    public function getIBAN_paysAttribute()
    {
        $allocataire_compte=$this->getLastCompte();
        if($allocataire_compte=="") return "";
        return $IBAN_pays;
    }

    /***************/
    /* DOCUMENTS     */
    /***************/
    public function getDocuments()
    {
        $documents=Document::where('id_allocataire','=',$this->id)->get();
        return $documents;
    }

    /* Loistes de documantes , type =1 pour libellé court */
    public function getTypesDocuments($sep=",",$format="")
    {
        $documents=$this->getDocuments();
        $list=[];
        foreach($documents as $document) {
           $list[]=MyApp::getZBaseLibelle("DOC_TYPES",$document->type,$format) ;
        }
        $list = array_unique($list);
        return implode($sep,$list);
    }

    /* Renvoi vrai si le document existe */
    public function hasDocument($t_type)
    {
        $documents=$this->getDocuments();
        $trouve=false;
        foreach($documents as $document) 
           if(in_array($document->type,$t_type)) {$trouve=true;break;}
        return $trouve;
    }

    /* ******************** */
    /* LOG                  */
    /* ******************** */
    public function log_transaction($url,$operation,$values="") {
        $log=new Logs;
        if($values=="") {
          $t_values=$this->getAttributes();
          foreach($t_values as $nom=>$value) $values.=(($values=="")?"":";").$nom."=>".$value;
        }
        $log->addlog(['url'=>$url,'table'=>$this->table ,'operation'=>$operation,'values'=>$values]);
      }
  }
