<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireCommission extends Model
{

	protected $table = 'allocataires_commissions';
	public  $timestamps = false;
    use RevisionableTrait;
    //protected $revisionForceDeleteEnabled = true;
    //protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }


    /* Dates */
    public function getDates()
    {
        return array('date_ouverture','date_commission','date_commission','date_evaluation','updated_at','created_at');
    }

    //Dates  OUverture
    public function getDateOuvertureAttribute($value)
    {
        return ($this->attributes['date_ouverture']!=null)?date('d/m/Y', strtotime($this->attributes['date_ouverture'])):null;
    }
    public function getDateOuvertureUSAttribute($value)
    {
        return (($this->attributes['date_ouverture']!=null))?date('Y-m-d', strtotime($this->attributes['date_ouverture'])):null;
    }

    //Dates  Commission
    public function getDateCommissionAttribute($value)
    {
        return ($this->attributes['date_commission']!=null)?date('d/m/Y', strtotime($this->attributes['date_commission'])):null;
    }
    public function getDateCommissionUSAttribute($value)
    {
        return (($this->attributes['date_commission']!=null))?date('Y-m-d', strtotime($this->attributes['date_commission'])):null;
    }

    
    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }

    public function getAvisLibelleAttribute($value)
    {
        if(!isset(MyApp::COMMISSION_AVIS[$this->avis])) return "";
        return MyApp::COMMISSION_AVIS[$this->avis];
    }

    public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

    public function getDetailCommissionAttribute($value)
    {
        $txt="";
        $txt=$this->DateCommission." pour ".$this->AllocataireNom;

        return $txt;

    }


}