<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireDroit extends Model {

    protected $table = 'allocataires_droits';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }


    /* Dates */
    public function getDates()
    {
        return array('date_ouverture','date_fermeture','date_demande','updated_at','created_at');
    }

    //Dates 
    public function getDateOuvertureAttribute($value)
    {
        return ($this->attributes['date_ouverture']!=null)?date('d/m/Y', strtotime($this->attributes['date_ouverture'])):null;
    }
    public function getDateFermetureAttribute($value)
    {
        return ($this->attributes['date_fermeture']!=null)?date('d/m/Y', strtotime($this->attributes['date_fermeture'])):null;
    }
    public function getDateDemandeAttribute($value)
    {
        return ($this->attributes['date_demande']!=null)?date('d/m/Y', strtotime($this->attributes['date_demande'])):null;
    }

    //US
    public function getDateOuvertureUSAttribute($value)
    {
        return ($this->attributes['date_ouverture']!=null)?date('Y-m-d', strtotime($this->attributes['date_ouverture'])):null;
    }
    public function getDateFermetureUSAttribute($value)
    {
        return ($this->attributes['date_fermeture']!=null)?date('Y-m-d', strtotime($this->attributes['date_fermeture'])):null;
    }
    public function getDateDemandeUSAttribute($value)
    {
        return ($this->attributes['date_demande']!=null)?date('Y-m-d', strtotime($this->attributes['date_demande'])):null;
    }

    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }

    public function getDetailDroitAttribute()
    {
        $txt="";
        $types_aides=MyApp::TYPES_AIDES_COURT;
        if(isset($types_aides[$this->type])) {
            $txt=$types_aides[$this->type];
        }
        return $txt;
    }

    public function getPeriodeAttribute()
    {
        return $this->DateOuverture." au ".$this->DateFermeture;
    }


    public function getDroitsOuvertureBadge($date_ref="",$badge=false)
    {
        if(!$date_ref) $date_ref=date("Y-m-d");
        //'ATT'=>'Droits non ouverts','FER'=>'Droits fermés','OUV'=>'Droits ouverts','NDF'=>'Dates non définies'
        $msg="OUV";
        $isOK=true;
        if($this->DateOuvertureUS>$date_ref || !$this->DateOuvertureUS)  $msg="ATT";
        elseif($this->DateFermetureUS && $this->DateFermetureUS<$date_ref )  $msg="FER";;

        if($msg) {
            if($badge) {
                if($msg!="OUV") $msg="<span class='badge badge-danger right'>". MyApp::DROITS_OUVERTURE[$msg]."</span>";
                else $msg="<span class='badge badge-success right'>". MyApp::DROITS_OUVERTURE[$msg]."</span>";
            } else $msg=MyApp::DROITS_OUVERTURE[$msg];
        }

        return $msg;
    }

    public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }
}

