<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireEquipement extends Model
{

	protected $table = 'allocataires_equipements';
	public  $timestamps = false;
    use RevisionableTrait;
    //protected $revisionForceDeleteEnabled = true;
    //protected $revisionCreationsEnabled = true;
    
    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }

    public function getEquipement()
    {
        $equipement=Equipement::find($this->id_equipement);
        return $equipement;
    }

    public function getEquipementNomAttribute()
    {
        $equipement=$this->getEquipement();
        
        if(!$equipement) return "";
        return $equipement->nom;
    }

    public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }
    
}