<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireFragilite extends Model {

    protected $table = 'allocataires_fragilites';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;
    
    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }

    /* Dates */
    public function getDates()
    {
        return array('date_evaluation','updated_at','created_at');
    }

    //Dates 
    public function getDateEvaluationAttribute($value)
    {
        return ($this->attributes['date_evaluation']!=null)?date('d/m/Y', strtotime($this->attributes['date_evaluation'])):null;
    }

    //US
    public function getDateEvaluationUSAttribute($value)
    {
        return ($this->attributes['date_evaluation']!=null)?date('Y-m-d', strtotime($this->attributes['date_evaluation'])):null;
    }

    //US
    public function getDateSaisieUSAttribute($value)
    {
        return ($this->attributes['date_evaluation']!=null)?date('Y-m-d', strtotime($this->attributes['date_evaluation'])):null;
    }


    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }

    public function getCreatedAtDayAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/y', strtotime($this->attributes['created_at'])):null;
    }

    /* ALLOCATAIRE */
    public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

    
    /* Gestionnaire */
    public function getNomGestionnaireAttribute()
    {
        $user=User::find($this->id_user);
        return $user->name;
    }


    /* Gestionnaire */
    public function getPointsAttribute()
    {
        $nbpt=0;
        $allocataire_fragilite_detail=AllocataireFragiliteDetail::
            where('id_allocataire_fragilite','=',$this->id)->get();
        foreach($allocataire_fragilite_detail as $detail) {
            $nbpt+=$detail->etat;
        }
        return $nbpt;
    }

    /* Gestionnaire */
    public function getDetailFragiliteAttribute()
    {
        $txt=$this->AllocataireNom." du ".$this->DateSaisie." saisie par ".$this->NomGestionnaire;
        return $txt;
    }
    

    public function FragiliteDelay() {
        $nbj=0;
        $date_fragilite=$this->DateEvaluationUS;
        $t_result=MyApp::getDateDiffToday($date_fragilite);
        $nbj=$t_result["j"]+($t_result["m"]*30+$t_result["a"]*365);

        return $nbj;
    } 

    public function getFragiliteColorAttribute() {
        $nbj=$this->FragiliteDelay();
        if($nbj<180) return "green;"; //-6mois
        if($nbj<=365) return "black;"; //-6mois
        return "red;"; //+1an
    } 
}

