<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;

class AllocataireFragiliteDetail extends Model {

    protected $table = 'allocataires_fragilites_detail';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;
    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire Fragilite
    public function allocataire_fragilite(): HasOne
    {
        return $this->hasOne(AllocataireFragilite::class,"id","id_allocataire_fragilite");
    }

    /* Dates */
    public function getDates()
    {
        return array('updated_at','created_at');
    }

    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    /* ALLOCATAIRE */
    public function getAllocataireFragilite()
    {
        $allocataire_fragilite=AllocataireFragilite::find($this->id_allocataire_fragilite);
        return $allocataire_fragilite;
    }

    public function getAllocataire()
    {
        $allocataire_fragilite=$this->getAllocataireFragilite();
        $allocataire=Allocataire::find($allocataire_fragilite->id_allocataire);
        return $allocataire;
    }

    public function getFragilite()
    {
        $fragilite=FragiliteRubrique::find($this->id_fragilite);
        return $fragilite;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

    public function getFragiliteLibelleAttribute()
    {
        $fragilite=$this->getFragilite();
        if(!$fragilite) return "";
        return $fragilite->libelle;
    }

    public function getFragiliteGroupeAttribute()
    {
        $fragilite=$this->getFragilite();
        if(!$fragilite) return "";
        return $fragilite->groupe;
    }
}

