<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireGir extends Model {

    protected $table = 'allocataires_girs';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;
    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }
    

    /* Dates */
    public function getDates()
    {
        return array('date_evaluation','updated_at','created_at');
    }

    //Dates 
    public function getDateEvaluationAttribute($value)
    {
        return ($this->attributes['date_evaluation']!=null)?date('d/m/Y', strtotime($this->attributes['date_evaluation'])):null;
    }


    //US
    public function getDateEvaluationUSAttribute($value)
    {
        return ($this->attributes['date_evaluation']!=null)?date('Y-m-d', strtotime($this->attributes['date_evaluation'])):null;
    }


    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    /* ALLOCATAIRE */
    public function getAllocataire()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

    
    /* Gestionnaire */
    public function getNomGestionnaireAttribute()
    {
        $user=User::find($this->id_user);
        return $user->name;
    }

    
	function getVariableModalite($code) {
        $allocataire=AllocataireGirDetail::where('id_allocataire_gir','=',$this->id)
            ->where('code_variable','=',$code)->first();

        if(!$allocataire) return "";
		return $allocataire->modalite;
	}

    function getGroupeModalite($code) {
        $allocataire=AllocataireGirDetail::where('id_allocataire_gir','=',$this->id)->where('code_variable','=',$code)->first();
        if(!$allocataire) return "";

        $aggir=Aggir::where('code','=',$code)->first();
        $groupe=$aggir->groupe;
        $options=Aggir::where('groupe','=',$groupe)->orderby('ordre','ASC')->get();
        $modalites="";
        foreach($options as $variable) {
            $allocataireGir=AllocataireGirDetail::where('id_allocataire_gir','=',$this->id)->where('code_variable','=',$variable->code)->first();
            if(isset($modalites)) {
                if($allocataireGir->modalite=="B") $modalites="B"; //Si une fois B on passe à B
            }
            else $modalites=$allocataire->modalite;
        }
        
		return $allocataire->modalite;
	}
    
	function getVariableValue($code,$groupe,$modalite,$group_options=false) {
        
        if($group_options) { //Cas de plusieurs options : Calul des la valeur moyenne
            $modalite_moyenne="";
            if(strlen($code)>4) {
                $t_options_modalites=AllocataireGirDetail::select('modalite')->where('id_allocataire_gir','=',$this->id)
                ->where('code_variable','like',substr($code,0,4)."%")->pluck('modalite')->toArray();
                $modalite_moyenne="A";
                if (in_array("C", $t_options_modalites)) {
                    if (in_array("A", $t_options_modalites) || in_array("B", $t_options_modalites)) $modalite_moyenne="B";
                    else $modalite_moyenne="C";
                }
                elseif (in_array("B", $t_options_modalites)) {
                    $modalite_moyenne="B";
                }
                //Cas particulier avec Taux le plus bas
                if($code=="ELIM1") {
                    if(in_array("C", $t_options_modalites)) $modalite_moyenne="C";
                    else if(in_array("B", $t_options_modalites)) $modalite_moyenne="B";
                    //dd($t_options_modalites);
                }
                $alloc_modalite=$modalite_moyenne;
                //if($code=="TOIL1") dd($modalite_moyenne);
            } else {
                $allocataire=AllocataireGirDetail::where('id_allocataire_gir','=',$this->id)->where('code_variable','=',$code)->first();
                $alloc_modalite=$allocataire->modalite;
            }
        } else {
            $allocataire=AllocataireGirDetail::where('id_allocataire_gir','=',$this->id)->where('code_variable','=',$code)->first();
            $alloc_modalite=$allocataire->modalite;
        }
        
        if($alloc_modalite!=$modalite) return 0;    
        $aggir=Aggir::where('code','=',$code)->first();
        if(!$aggir) return 0;
        //dd($aggir->{'valeur_'.strtolower($groupe.$modalite)});
        $valeur=$aggir->{'valeur_'.strtolower($groupe.$modalite)};
		return $valeur;
	}

    
	function getGroupeGIRAttribute() {
        //Calcul des totaux
        $t_grp=MyApp::GROUPE_GIR;
        $t_grp_modalite=MyApp::GROUPE_MODALITE; //B, C
        $aggir=Aggir::orderby('ordre','ASC')->get();
        $t_modalites=[];
        //Calcul
        $t_values=[];
        foreach($aggir as $variable) {
            foreach($t_grp_modalite as $grp_modalite) {
                foreach($t_grp as $grp) {
                    if( (strlen($variable->code)==4) || (substr($variable->code,4,1)=="1") ) {
                        $allocataire=AllocataireGirDetail::where('id_allocataire_gir','=',$this->id)
                            ->where('code_variable','=',$variable->code)->first(); //Le 12er du groupe à les Taux
                        
                        //Cas de plusieurs options : Calul des la valeur moyenne
                        /*
                        $modalite_moyenne="";
                        if(strlen($variable->code)>4) {
                            $t_options_modalites=AllocataireGirDetail::select('modalite')->where('id_allocataire_gir','=',$this->id)
                            ->where('code_variable','like',substr($variable->code,0,4)."%")->pluck('modalite')->toArray();
                            $modalite_moyenne="A";
                            if (in_array("C", $t_options_modalites)) {
                                if (in_array("A", $t_options_modalites) || in_array("B", $t_options_modalites)) $modalite_moyenne="B";
                                else $modalite_moyenne="C";
                            }
                            elseif (in_array("B", $t_options_modalites)) {
                                $modalite_moyenne="B";
                            }
                        }
                            */
                        $value=$this->getVariableValue($allocataire->code_variable,$grp,$grp_modalite,true);
                        $t_values[$variable->code."-".$grp.$grp_modalite]=$value;
                        if(!isset($total[$grp])) $total[$grp]=0;
                        $total[$grp]+=$value;
                    }
                }
            }
        }
        $t_ventilation=[];
        foreach($t_grp as $grp) {
            if($grp=="A") {
                if($total[$grp]>=4380) $rang="1";
                elseif ($total[$grp]<4380 && $total[$grp]>=4140) $rang="2";
                elseif ($total[$grp]<4140 && $total[$grp]>=3390) $rang="3";
                else $rang="B";
            }
            if(($grp=="B")&&($rang=="B")) {
                if($total[$grp]>=2016) $rang="4";
                else $rang="C";
            }
            if(($grp=="C")&&($rang=="C")) {
                if($total[$grp]>=1700) $rang="5";
                elseif($total[$grp]<1700 && $total[$grp]>=1432) $rang="6";
                else $rang="D";
            }
            if(($grp=="D")&&($rang=="D")) {
                if($total[$grp]>=2400) $rang="7";
                else $rang="E";
            }
            if(($grp=="E")&&($rang=="E")) {
                if($total[$grp]>=1200) $rang="8";
                else $rang="F";
            }
            if(($grp=="F")&&($rang=="F")) {
                if($total[$grp]>=800) $rang="9";
                else $rang="G";
            }
            if(($grp=="G")&&($rang=="G")) {
                if($total[$grp]>=650) $rang="10";
                else $rang="H";
            }
            if(($grp=="H")&&($rang=="H")) {
                if($total[$grp]>=4000) $rang="11";
                elseif($total[$grp]<4000 && $total[$grp]>=2000) $rang="12";
                else $rang="13";
            }
        }
        $groupe=0;
        if($rang==1) $groupe=1;
        if($rang>1 && $rang<=7) $groupe=2;
        if($rang==8 ||  $rang==9) $groupe=3;
        if($rang==10 ||  $rang==11) $groupe=4;
        if($rang==12) $groupe=5;
        if($rang==13) $groupe=6;

		return $groupe;
	}

    public function GirDelay() {
        $nbj=0;
        $date_evaluation=$this->DateEvaluationUS;
        $t_result=MyApp::getDateDiffToday($date_evaluation);
        $nbj=$t_result["j"]+($t_result["m"]*30+$t_result["a"]*365);
        
        return $nbj;
    } 

    public function getGirColorAttribute() {
        $nbj=$this->GirDelay();
        if($nbj<180) return "green;"; //-6mois
        if($nbj<=365) return "black;"; //-6mois
        return "red;"; //+1an
    } 
}

