<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireGirDetail extends Model {

    protected $table = 'allocataires_girs_detail';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;
    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire Gir
    public function allocataire_gir(): HasOne
    {
        return $this->hasOne(AllocataireGir::class,"id","id_allocataire_gir");
    }
    


    /* Dates */
    public function getDates()
    {
        return array('updated_at','created_at');
    }


    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    /* ALLOCATAIRE */
    public function getAllocataireGir()
    {
        $allocataire_gir=AllocataireGir::find($this->id_allocataire_gir);
        return $allocataire_gir;
    }

    public function getAllocataire()
    {
        $allocataire_gir=$this->getAllocataireGir();
        $allocataire=Allocataire::find($allocataire_gir->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }


}

