<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use App\Http\Controllers\Logs;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireHandicapDetail extends Model {

    protected $table = 'allocataires_girs_detail';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(AllocataireHandicap::class,"id","id_allocataire_handicap");
    }

    /* Dates */
    public function getDates()
    {
        return array('updated_at','created_at');
    }


    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    /* ALLOCATAIRE */
    public function getAllocataireHandicap()
    {
        $allocataire_handicap=AllocataireHandicap::find($this->id_allocataire_handicap);
        return $allocataire_handicap;
    }

    public function getAllocataire()
    {
        $allocataire_handicap=$this->getAllocataireHandicap();
        $allocataire=Allocataire::find($allocataire_handicap->id_allocataire);
        return $allocataire;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }


}

