<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireHandicapDetail extends Model {

    protected $table = 'allocataires_handicaps_detail';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire Gir
    public function allocataire_handicap(): HasOne
    {
        return $this->hasOne(AllocataireHandicap::class,"id","id_allocataire_handicap");
    }

    /* Dates */
    public function getDates()
    {
        return array('updated_at','created_at');
    }

    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    /* ALLOCATAIRE */
    public function getAllocataireHandicap()
    {
        $allocataire_fragilite=AllocataireHandicap::find($this->id_allocataire_handicap);
        return $allocataire_handicap;
    }

    public function getAllocataire()
    {
        $allocataire_handicap=$this->getAllocataireHandicap();
        $allocataire=Allocataire::find($allocataire_handicap->id_allocataire);
        return $allocataire;
    }

    public function getHandicap()
    {
        $handicap=HandicapRubrique::find($this->id_handicap);
        return $handicap;
    }

    public function getAllocataireNomAttribute()
    {
        $allocataire=$this->getAllocataire();
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }

    public function getHandicapLibelleAttribute()
    {
        $handicap=$this->getHandicap();
        if(!$handicap) return "";
        return $handicap->libelle;
    }

    public function getCategorieNiveauAttribute()
    {
        if($this->niveau<20) return 1;
        if($this->niveau<50) return 2;
        if($this->niveau<80) return 3;
        return 4;
    }
}

