<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireHumaine extends Model
{

	protected $table = 'allocataires_humaines';
	public  $timestamps = false;
    use RevisionableTrait;
    //protected $revisionForceDeleteEnabled = true;
    //protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }
    
    /* Dates */
    public function getDates()
    {
        return array('date_saisie','date_naissance','updated_at','created_at');
    }

    //Dates  OUverture
    public function getDateSaisieAttribute($value)
    {
        return ($this->attributes['date_saisie']!=null)?date('d/m/Y', strtotime($this->attributes['date_saisie'])):null;
    }
    public function getDateSaisieUSAttribute($value)
    {
        return (($this->attributes['date_saisie']!=null))?date('Y-m-d', strtotime($this->attributes['date_saisie'])):null;
    }
    //Date naissance IAdant
    public function getDateNaissanceAttribute($value)
    {
        return ($this->attributes['date_naissance']!=null)?date('d/m/Y', strtotime($this->attributes['date_naissance'])):null;
    }
    public function getDateNaissanceUSAttribute($value)
    {
        return (($this->attributes['date_naissance']!=null))?date('Y-m-d', strtotime($this->attributes['date_naissance'])):null;
    }

    //Date modification
    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    public function getAidantNomCompletAttribute($value)
    {
        return $this->aidant_nom." ".$this->aidant_prenom." (".$this->DateNaissance.")";;
    }

    public function getBesoinNomAttribute($value)
    {
        return MyApp::getZBaseLibelle("HUM_BESOINS",$this->besoin);
       
    }

    public function getModaliteNomAttribute($value)
    {

        return MyApp::getZBaseLibelle("HUM_BESOINS_MODALITES",$this->modalite);

    }

        public function getRythmeNomAttribute($value)
    {
        if(!isset(MyApp::TYPES_BESOINS_RYTHMES[$this->rythme])) return "";
        return MyApp::TYPES_BESOINS_RYTHMES[$this->rythme];
    }
    
    
}