<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireProjet extends Model
{

	protected $table = 'allocataires_projets';
	public  $timestamps = false;
    use RevisionableTrait;
    //protected $revisionForceDeleteEnabled = true;
    //protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }
    
    /* Dates */
    public function getDates()
    {
        return array('date_saisie','updated_at','created_at');
    }

    //Dates  OUverture
    public function getDateSaisieAttribute($value)
    {
        return ($this->attributes['date_saisie']!=null)?date('d/m/Y', strtotime($this->attributes['date_saisie'])):null;
    }
    public function getDateSaisieUSAttribute($value)
    {
        return (($this->attributes['date_saisie']!=null))?date('Y-m-d', strtotime($this->attributes['date_saisie'])):null;
    }
    //Date modification
    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }


    public function getProjetNomAttribute($value)
    {
        return MyApp::getZBaseLibelle("PROJETS_VIE",$this->projet);
       
    }

    public function getDelaisNomAttribute($value)
    {
        if(!isset(MyApp::PROJET_DELAIS[$this->delais])) return ""; 
        return MyApp::PROJET_DELAIS[$this->delais];  
    }
    public function getPeriodiciteNomAttribute($value)
    {
        if(!isset(MyApp::PROJET_PERIODICITE[$this->periodicite])) return ""; 
        return MyApp::PROJET_PERIODICITE[$this->periodicite];  
    }
    public function getTypeAideNomAttribute($value)
    {
        if(!isset(MyApp::PROJET_TYPE_AIDE[$this->type_aide])) return ""; 
        return MyApp::PROJET_TYPE_AIDE[$this->type_aide];  
    }
}