<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireRessource extends Model
{

	protected $table = 'allocataires_ressources';
	public  $timestamps = false;
    use RevisionableTrait;
    //protected $revisionForceDeleteEnabled = true;
    //protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }
    
    /* Dates */
    public function getDates()
    {
        return array('date_fin');
    }
    //Dates Fin
    public function getDateFinAttribute($value)
    {
        return ($this->attributes['date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['date_fin'])):null;
    }
    //Dates Fin
    public function getDateFinUSAttribute($value)
    {
        return ($this->attributes['date_fin']!=null)?date('Y-m-d', strtotime($this->attributes['date_fin'])):null;
    }

    /* ADRESSE */
    public function getNomCompletAllocataireAttribute()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        if(!$allocataire) return "";
        return $allocataire->NomComplet;
    }
    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("RES_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;


        return true;
    }

    /* ADRESSE */
    public function getTypeAttribute()
    {
        $types_ressources=MyApp::getZBase("BEN_RESSOURCE");

        if(!isset($types_ressources[$this->type_ressource])) return "";
        return $types_ressources[$this->type_ressource];
    }

    
}