<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;
use \Venturecraft\Revisionable\RevisionableTrait;
use Illuminate\Database\Eloquent\Relations\HasOne;

class AllocataireVisite extends Model
{

	protected $table = 'allocataires_visites';
	public  $timestamps = false;
    use RevisionableTrait;
    //protected $revisionForceDeleteEnabled = true;
    //protected $revisionCreationsEnabled = true;

    /* ************** */
    /* RELATIONS     
    /* ************** */
    //Allocataire
    public function allocataire(): HasOne
    {
        return $this->hasOne(Allocataire::class,"id","id_allocataire");
    }
    
    
    /* Dates */
    public function getDates()
    {
        return array('date_visite','updated_at','created_at');
    }

    //Dates  OUverture
    public function getDateVisiteAttribute($value)
    {
        return ($this->attributes['date_visite']!=null)?date('d/m/Y', strtotime($this->attributes['date_visite'])):null;
    }
    public function getDateVisiteUSAttribute($value)
    {
        return (($this->attributes['date_visite']!=null))?date('Y-m-d', strtotime($this->attributes['date_visite'])):null;
    }
    
    public function getUpdatedAtDayAttribute($value)
    {
        return (($this->attributes['updated_at']!=null))?date('d/m/y', strtotime($this->attributes['updated_at'])):null;
    }

    public function getCreatedAtAttribute($value)
    {
        return (($this->attributes['created_at']!=null))?date('d/m/Y H:i:s', strtotime($this->attributes['created_at'])):null;
    }
}