<?php namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Database\Eloquent\Model;
use DB;

class District extends Model
{
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'districts';
	public  $timestamps = false;


	/**
     * Get the user's full name by concatenating the first and last names
     *
     * @return string
     */
    public function getNbVehiculesAttribute()
    {

     $nb_vehicules=DB::table('vehicules')
     	->join('villages','villages.id', '=', 'vehicules.commune_id')
     	->where('villages.district_id','=',$this->id)
     	->count(); 

        return $nb_vehicules;
    }


    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("DIS_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;
        $nb=$this->NbVehicules;
        if($nb>0) return false;

        return true;
    }

}