<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use \Venturecraft\Revisionable\RevisionableTrait;

class Document extends Model
{
	protected $table = 'documents';
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;


    public function getTypeLibelleAttribute()
    {
        $types_documents=MyApp::getZBase("DOC_TYPES");
        if(!isset($types_documents[$this->type])) return "";
        return $types_documents[$this->type];
    }

    public function getURLAttribute()
    {
        if(env('APP_ENV') =="developpement") $path_base="../storage/app/public";
        else $path_base='../storage';
        $url=url($path_base.$this->path.'/'.$this->nom_file);

        return $url;
    }

    public function getExtensionAttribute()
    {
        $ext = pathinfo($this->nom_file, PATHINFO_EXTENSION);
        return $ext;
    }

    public function getExisteAttribute()
    {
        $path = $this->Path;
        return file_exists($path);
    }

    public function getPathAttribute()
    {
        $allocataire=Allocataire::find($this->id_allocataire);
        if(!$allocataire) return false;
        if(env('APP_ENV')=='developpement') $path="../storage/app/";
        else $path="./storage/";
        $path = $path.MyApp::PATH_ALLOCATAIRES.$allocataire->IdPAD."/".$this->nom_file;
        return $path;

    }


    public function getIconeAttribute()
    {
        $icon="icons-fichier-48.png";
        $ext = $this->Extension;
        if($ext=="pdf") $icon="icons-pdf-48.png";
        if($ext=="jpg") $icon="icons-jpg-48.png";
        if($ext=="png") $icon="icons-png-48.png";
        return $icon;
    }

}