<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use \Venturecraft\Revisionable\RevisionableTrait;

class Equipement extends Model
{

	protected $table = 'equipements';
	public  $timestamps = false;
    use RevisionableTrait;
    protected $revisionForceDeleteEnabled = true;
    protected $revisionCreationsEnabled = true;

    /**
    * Fiche Supprimable ?
    */
    public function getIsSupprimableAttribute()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if (!$user->can("EQU_SUP") && !$user->HasRole("ADMINISTRATEUR")) return false;


        $nb=AllocataireEquipement::where('id_equipement','=',$this->id)->count();
        if($nb>0) return false;
        
        return true;
    }

}