<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Structures\Onisep;
use App\Models\Structures\Etablissement;
use App\Models\Structures\Academie;
use App\Models\Structures\Region;
use App\Models\Structures\Departement;
use App\Models\Structures\Commune;
use App\Models\Structures\Niveau;
use App\Models\Structures\Secteur;
use App\Models\Structures\Domaine;
use App\Models\Structures\Formation;

use App\Models\Structures\SessionStage;
use App\Models\Structures\Classe;
use App\Models\Structures\Soussecteur;
use App\Models\Structures\Diplome;
use App\Models\MyApp;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\ClasseRequest;
use Illuminate\Http\Request;
use DB;

class AgendasController extends Controller {
    private $menu='agendas';
    private $submenu='classes';


    public function index($page=1,$id_region="",$id_domaine="",$id_niveau="",$id_departement="")
    {
        //if(!($user=Auth::user())) return Redirect::route( 'login' );
        //if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter classes")) return Redirect::route('home');
        $limit=100;$isLimited=0;
        $withHeader=true;
        $withHero=true;
        $withClient=false;
        $withService=false;
        $withFooter2=true;

        $t_mois=["Jan","Fev","Mar","Avr","Mai","Jui","Jui","Aou","Sep","Oct","Nov","Dec"];
        $page=["Jan","Fev","Mar","Avr","Mai","Jui"];

        $res=$this->updateONISEP();
        $academies=Academie::select( "id","nom")->orderby('nom','ASC')->get();//->pluck('nom','code')->toArray();
        $regions=Region::select("id","nom")->orderby('nom','ASC')->get();//->pluck('nom','code')->toArray();
        $niveaux=Niveau::select("id","nom")->orderby('nom','ASC')->get();
        $domaines=Domaine::select("id","nom")->orderby('id','ASC')->get();
        $region_avec_dep=region::where('nom','like','%collectiv%')->first();
        $departements=""; $academie="";
        if($region_avec_dep->id==$id_region) {
            $academie=Academie::where('nom','like','%collectiv%')->first();
            $departements=Departement::select("id","nom")->where('id_academie','=',$academie->id)->orderby('id','ASC')->get();
        }
        $formations=[];$total_result=0;
        if($id_region) {
            $obj_formations=Formation::select("formations.id as id_formation")
                ->join('etablissements','etablissements.id','=','formations.id_etablissement')
                ->join('communes','communes.id','=','etablissements.id_commune')
                ->join('departements','departements.id','=','communes.id_departement')
                ->join('academies','academies.id','=','departements.id_academie')
                ->where('academies.id_region','=',$id_region);
            if($id_niveau)  $obj_formations=$obj_formations->where('formations.id_niveau','=',$id_niveau);
            if($id_domaine)  $obj_formations=$obj_formations->where('formations.id_domaine','=',$id_domaine);
            if($academie)  $obj_formations=$obj_formations->where('academies.id','=',$academie->id);
            if($id_departement)  {
                $obj_formations=$obj_formations->where('communes.id_departement','=',$id_departement);
                $obj_formations=$obj_formations->where('departements.id','=',$id_departement);
            }
            $formations=$obj_formations->orderby('formations.uai','ASC')->orderby('id_formation','ASC')->get();
            $total_result=$formations->count();
            if($total_result>$limit) $formations=$obj_formations->limit($limit)->orderby('formations.uai','ASC')->orderby('id_formation','ASC')->get();
        }


        if(count($formations)>0) $isLimited=($formations->count()==$limit)?$limit:0;
        $semaines=MyApp::week2day2tab();
        $lycees=[];$colleges=[];$classes=[];$sessions=[];$diplomes=[];

        //Points
        $k=0;$Base_GPS=[];$t_GPS=[];$t_Marker_txt=[];$t_IdEtablissements=[];$t_IdFormations=[];
        foreach($formations as $formation) {
            $f=Formation::find($formation->id_formation);
            if(!in_array($f->id_etablissement, $t_IdEtablissements)) {
                $k++;
                $t_IdFormations[]=$f->id;
                $t_IdEtablissements[]=$f->id_etablissement;
                $t=[$f->NomEtablissementCourt,$f->latitude,$f->Longitude];
                $t_GPS[]=$t;
                if($k==1) $Base_GPS=[$f->latitude,$f->Longitude];
            }
        }
        $Base_GPS=json_encode($Base_GPS);
        $t_GPS=json_encode($t_GPS);
        $t_IdFormations=json_encode($t_IdFormations);
        $t_IdEtablissements=json_encode($t_IdEtablissements);

        return View::make('agendas.index', [
            'menu' => $this->menu,'submenu' => $this->submenu,
            'id_region'=>$id_region,'id_domaine'=>$id_domaine,'id_niveau'=>$id_niveau,'id_departement'=>$id_departement,
            't_mois'=>$t_mois,'page'=>$page, 'isLimited' => $isLimited,'total_result' => $total_result,
            'regions'=>$regions,
            'academies'=>$academies,
            'niveaux'=>$niveaux,
            'domaines'=>$domaines,
            'formations'=>$formations,
            'departements'=>$departements,
            'semaines'=>$semaines,
            'diplomes'=>$diplomes,
            't_GPS'=>$t_GPS,'Base_GPS'=>$Base_GPS,
            't_IdFormations'=>$t_IdFormations,'t_IdEtablissements'=>$t_IdEtablissements,
            'lycees'=>$lycees,'colleges'=>$colleges,'classes'=>$classes,'sessions'=>$sessions,
            'withHeader' => $withHeader,'withHero' => $withHero,'withClient' => $withClient,
            'withService' => $withService, 'withFooter2' => $withFooter2
        ]);

    }

    public function index_filtre($id_region="",$id_domaine="",$id_niveau="",$id_departement="")
    {
       return $this->index(1,$id_region,$id_domaine,$id_niveau,$id_departement);
    }

    public function getLocation2()
    {
        // API end URL
        $apiURL = 'https://freegeoip.app/json/';

        // Create a new cURL resource with URL
        $ch = curl_init($apiURL);

        // Return response instead of outputting
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Execute API request
        $apiResponse = curl_exec($ch);
        dd($apiResponse);
        // Close cURL resource
        curl_close($ch);

        // Retrieve IP data from API response
        $ipData = json_decode($apiResponse, true);

        if(!empty($ipData)){
            $country_code = $ipData['country_code'];
            $country_name = $ipData['country_name'];
            $region_code = $ipData['region_code'];
            $region_name = $ipData['region_name'];
            $city = $ipData['city'];
            $zip_code = $ipData['zip_code'];
            $latitude = $ipData['latitude'];
            $longitude = $ipData['longitude'];
            $time_zone = $ipData['time_zone'];

            echo 'Country Name: '.$country_name.'<br/>';
            echo 'Country Code: '.$country_code.'<br/>';
            echo 'Region Code: '.$region_code.'<br/>';
            echo 'Region Name: '.$region_name.'<br/>';
            echo 'City: '.$city.'<br/>';
            echo 'Zipcode: '.$zip_code.'<br/>';
            echo 'Latitude: '.$latitude.'<br/>';
            echo 'Longitude: '.$longitude.'<br/>';
            echo 'Time Zone: '.$time_zone;
        }else{
            echo 'IP data is not found!';
        }

    }

    public function getLocation(Request $request)
    {
        $userIP = '162.222.198.75';
        // API end URL
        $apiURL = 'https://freegeoip.app/json/'.$userIP;

        // Create a new cURL resource with URL
        $ch = curl_init($apiURL);

        // Return response instead of outputting
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // Execute API request
        $apiResponse = curl_exec($ch);

        // Close cURL resource
        curl_close($ch);

        // Retrieve IP data from API response
        $ipData = json_decode($apiResponse, true);

        if(!empty($ipData)){
            $country_code = $ipData['country_code'];
            $country_name = $ipData['country_name'];
            $region_code = $ipData['region_code'];
            $region_name = $ipData['region_name'];
            $city = $ipData['city'];
            $zip_code = $ipData['zip_code'];
            $latitude = $ipData['latitude'];
            $longitude = $ipData['longitude'];
            $time_zone = $ipData['time_zone'];

            echo 'Country Name: '.$country_name.'<br/>';
            echo 'Country Code: '.$country_code.'<br/>';
            echo 'Region Code: '.$region_code.'<br/>';
            echo 'Region Name: '.$region_name.'<br/>';
            echo 'City: '.$city.'<br/>';
            echo 'Zipcode: '.$zip_code.'<br/>';
            echo 'Latitude: '.$latitude.'<br/>';
            echo 'Longitude: '.$longitude.'<br/>';
            echo 'Time Zone: '.$time_zone;
        }else{
            echo 'IP data is not found!';
        }

        return $country_name;
        //if latitude and longitude are submitted
        $latitude=$request->latitude;
        $longitude=$request->longitude;
        $location="1212";
        if($latitude && $longitude){
            //send request and receive json data by latitude and longitude
            $url = 'http://maps.googleapis.com/maps/api/geocode/json?latlng='.trim($latitude).','.trim($longitude).'&sensor=false';
            $json = @file_get_contents($url);
            $data = json_decode($json);
            $status = $data->status;

            //if request status is successful
            if($status == "OK"){
                //get address from json data
                $location = $data->results[0]->formatted_address;
            }else{
                $location =  '';
            }

            //return address to ajax
            echo $location;
        }
        return $location;
    }


    public function updateONISEP()
    {
        //$res=$this->updateONISEP_Formations();
        /*
        $res=$this->updateONISEP_Secteurs();
        $res=$this->updateONISEP_Niveaux();
        $res=$this->updateONISEP_Regions();
        $res=$this->updateONISEP_Academies();
        $res=$this->updateONISEP_Departements();
        $res=$this->updateONISEP_Communes();
        $res=$this->updateONISEP_Formations();
        $res=$this->updateONISEP_Etablissements();
        */
    }

    /* NIVEAUX */
    public function updateONISEP_Niveaux()
    {

        $o_niveaux=Onisep::select("FOR_NIVEAU_SORTIE")->distinct()->orderby('FOR_NIVEAU_SORTIE','ASC')->get();
        $niveaux=Niveau::truncate();
        try{
            DB::beginTransaction();
            foreach($o_niveaux as $o_niveau) {
                $niveau=new Niveau;
                $niveau->nom=$o_niveau->FOR_NIVEAU_SORTIE;
                if($niveau->nom) $niveau->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();
            $ret=false;
        }

        //$o_academies=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get();
        //$o_lycees=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get()
        return true;
    }

    /* REGIONS */
    public function updateONISEP_Regions()
    {

        $o_regions=Onisep::select("ENS_REGION")->distinct()->orderby('ENS_REGION','ASC')->get();
        $regions=Region::truncate();
        try{
            DB::beginTransaction();
            foreach($o_regions as $o_region) {
                $region=new Region;
                $region->nom=$o_region->ENS_REGION;
                if($region->nom) $region->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();
            $ret=false;
        }
        return true;
    }

    /* ACADEMIES */
    public function updateONISEP_Academies()
    {
        $o_academies=Onisep::select("ENS_ACADEMIE","ENS_REGION")->distinct()->orderby('ENS_ACADEMIE','ASC')->orderby('ENS_REGION','ASC')->get();
        $academies=Academie::truncate();
        try{
            DB::beginTransaction();
            foreach($o_academies as $o_academie) {
                $region=Region::where('nom','=',$o_academie->ENS_REGION)->first();
                $id_region=($region)?$region->id:"";
                $academie=new Academie;
                $academie->nom=$o_academie->ENS_ACADEMIE;
                $academie->id_region=$id_region;
                if($academie->nom) $academie->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();
            $ret=false;
        }

        //$o_academies=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get();
        //$o_lycees=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get()
        return true;
    }

    /* DEPARTEMENTS */
    public function updateONISEP_Departements()
    {
        $o_departements=Onisep::select("ENS_DEPARTEMENT","ENS_ACADEMIE")->distinct()->orderby('ENS_DEPARTEMENT','ASC')->orderby('ENS_ACADEMIE','ASC')->get();
        $departements=Departement::truncate();
        try{
            DB::beginTransaction();
            foreach($o_departements as $o_departement) {
                $academie=Academie::where('nom','=',$o_departement->ENS_ACADEMIE)->first();

                $id_academie=($academie)?$academie->id:"";
                $departement=new Departement;
                $departement->nom=$o_departement->ENS_DEPARTEMENT;
                $departement->id_academie=$id_academie;
                if($departement->nom) $departement->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();
            $ret=false;
        }

        //$o_academies=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get();
        //$o_lycees=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get()
        return true;
    }

    /* COMMUNES */
    public function updateONISEP_Communes()
    {
        $o_communes=Onisep::select("ENS_COMMUNE","ENS_DEPARTEMENT")->distinct()->orderby('ENS_COMMUNE','ASC')->orderby('ENS_DEPARTEMENT','ASC')->get();
        $communes=Commune::truncate();

        try{
            DB::beginTransaction();
            foreach($o_communes as $o_commune) {
                $departement=Departement::where('nom','=',$o_commune->ENS_DEPARTEMENT)->first();
                $id_departement=($departement)?$departement->id:"";
                $commune=new Commune;
                $commune->nom=$o_commune->ENS_COMMUNE;
                $commune->id_departement=$id_departement;
                if($commune->nom) $commune->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();dd($e);
            $ret=false;
        }

        //$o_academies=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get();
        //$o_lycees=Onisep::select("FOR_ACADEMIE")->distinct()->orderby('FOR_ACADEMIE','ASC')->get()
        return true;
    }

    public function updateONISEP_Etablissements()
    {
        $o_etablissements=Onisep::select('FOR_LIEU','ENS_UAI','ENS_STATUT','ENS_ADRESSE','ENS_CP',
            'ENS_COMMUNE','ENS_DEPARTEMENT','ENS_ACADEMIE','ENS_REGION','ENS_LATITUDE',
            'ENS_LONGITUDE','ENS_TELEPHONE','ENS_WEB','ENS_ACCESSIBILITE')
            ->distinct()->orderby('ENS_UAI','ASC')->get();
        $etablissements=Etablissement::truncate();
        try{
            DB::beginTransaction();
            foreach($o_etablissements as $o_etablissement) {
                $commune=Commune::where('nom','=',$o_etablissement->ENS_COMMUNE)->first();
                $id_commune=($commune)?$commune->id:"";
                $lieu=str_replace("Lycée d'enseignement général et technologique","LEGT",$o_etablissement->FOR_LIEU);
                $lieu=str_replace("Lycée d'enseignement professionnel et technologique","LEPT",$o_etablissement->FOR_LIEU);
                $lieu=str_replace("Ecole hôtelière","EcHôt",$o_etablissement->FOR_LIEU);
                $lieu=str_replace("Ecole technique commerciale","EcTC",$o_etablissement->FOR_LIEU);
                $lieu=str_replace("Campus des sciences et techniques","CampST",$o_etablissement->FOR_LIEU);
                $lieu=str_replace("Section d'enseignement professionnel du lycée polyvalent","SEP",$o_etablissement->FOR_LIEU);
                $lieu=str_replace("international","Int",$lieu);$lieu=str_replace("internationale","int.",$lieu);
                $lieu=str_replace("Lycée polyvalent","LPol",$lieu);$lieu=str_replace("internationale","int.",$lieu);
                $lieu=str_replace("Lycée professionnel","LPro",$lieu);$lieu=str_replace("internationale","int.",$lieu);
                $lieu=str_replace("Centre d'éducation aux technologies appropriées au développement du collège","CETAD",$lieu);$lieu=str_replace("internationale","int.",$lieu);
                $lieu=str_replace("Centre d'éducation aux technologies appropriées au développement","CETAD",$lieu);$lieu=str_replace("internationale","int.",$lieu);

                $etablissement=new Etablissement;
                $etablissement->id_commune=$id_commune;
                $etablissement->ENS_UAI=$o_etablissement->ENS_UAI;
                $etablissement->ENS_LIEU= $lieu;
                $etablissement->ENS_STATUT=$o_etablissement->ENS_STATUT;
                $etablissement->ENS_ADRESSE=$o_etablissement->ENS_ADRESSE;
                $etablissement->ENS_CP=$o_etablissement->ENS_CP;
                $etablissement->ENS_COMMUNE=$o_etablissement->ENS_COMMUNE;
                $etablissement->ENS_DEPARTEMENT=$o_etablissement->ENS_DEPARTEMENT;
                $etablissement->ENS_ACADEMIE=$o_etablissement->ENS_ACADEMIE;
                $etablissement->ENS_REGION=$o_etablissement->ENS_REGION;
                $etablissement->ENS_LATITUDE=$o_etablissement->ENS_LATITUDE;
                $etablissement->ENS_LONGITUDE=$o_etablissement->ENS_LONGITUDE;
                $etablissement->ENS_TELEPHONE=$o_etablissement->ENS_TELEPHONE;
                $etablissement->ENS_WEB=$o_etablissement->ENS_WEB;
                $etablissement->ENS_ACCESSIBILITE=$o_etablissement->ENS_ACCESSIBILITE;
                if($etablissement->ENS_UAI) $etablissement->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();dd($e);
            $ret=false;
        }

        return true;
    }

    public function updateONISEP_Secteurs()
    {
        $o_secteurs=Onisep::select('FOR_INDEX')->distinct()->orderby('FOR_INDEX','ASC')->get();
        $secteurs=Secteur::truncate();
        $doamine=Domaine::truncate();
        try{
            DB::beginTransaction();
            foreach($o_secteurs as $o_secteur) {
                $secteur=new Secteur;
                $secteur->nom=$o_secteur->FOR_INDEX;
                if($secteur->nom) {
                    $secteur->save();
                    //Domaine
                    $t=explode('/',$secteur->nom);
                    $nb=Domaine::where('nom','=',$t[0])->count();
                    if(!$nb) {
                        $domaine=new Domaine;
                        $domaine->id_secteur=$secteur->id;
                        $domaine->nom=$t[0];
                        $domaine->save();
                    }
                }
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();dd($e);
            $ret=false;
        }

        return true;
    }

    public function updateONISEP_Formations()
    {
        $o_formations=Onisep::select('ENS_UAI','FOR_LIEU','FOR_NIVEAU_SORTIE','FOR_TYPE','FOR_INDEX','FOR_URL','FOR_LIBELLE','FOR_ID_ONISEP')
            ->distinct()->orderby('FOR_NIVEAU_SORTIE','ASC')->orderby('ENS_COMMUNE','ASC')->get();
        $formations=Formation::truncate();
        try{
            DB::beginTransaction();
            foreach($o_formations as $o_formation) {
                $niveau=Niveau::where('nom','=',$o_formation->FOR_NIVEAU_SORTIE)->first();
                $id_niveau=($niveau)?$niveau->id:"";
                $etablissement=Etablissement::where('ENS_UAI','=',$o_formation->ENS_UAI)->where('ENS_LIEU','=',$o_formation->FOR_LIEU)->first();
                $id_etablissement=($etablissement)?$etablissement->id:"";
                $t=explode('/',$o_formation->FOR_INDEX);
                $domaine=Domaine::where('nom','=',$t[0])->first();
                $id_domaine=($domaine)?$domaine->id:"";
                $formation=new Formation;
                $formation->id_etablissement=$id_etablissement;
                $formation->uai=$o_formation->ENS_UAI;
                $formation->id_niveau=$id_niveau;
                $formation->id_domaine=$id_domaine;
                $formation->type=$o_formation->FOR_TYPE;
                $formation->index=$o_formation->FOR_INDEX;
                $formation->url=$o_formation->FOR_URL;
                $formation->libelle=$o_formation->FOR_LIBELLE;
                $formation->id_onisep=$o_formation->FOR_ID_ONISEP;
                if($formation->uai && $id_etablissement && $id_domaine) $formation->save();
            }
            $ret=true;
            DB::commit();
        }catch(\Exception $e){
            DB::rollback();dd($e);
            $ret=false;
        }

        return true;
    }




}

