<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Modeles\Etablissement;
use App\Modeles\Commune;
use App\Modeles\Classe;
use App\Modeles\Modele;
use ClassesController;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\EtablissementRequest;
use Image;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\File;
use Symfony\Component\HttpFoundation\File\UploadedFile;

class EtablissementsController extends Controller {

    private $menu='etablissements';

    public function index()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter etablissements")) return Redirect::route('home');

        $etablissement = Etablissement::first();
        if(isset($etablissement->id)) return $this->show($etablissement->id);
        return $this->create();
    }


    public function etablissement_consult()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter etablissements")) return Redirect::route('home');

        $etablissement = Etablissement::first();
        if(isset($etablissement->id)) return $this->show($etablissement->id);
        return $this->create();  
    }


    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter etablissements")) return Redirect::route('home');

        $mode="create";

        $t_communes=array();
        $communes = Commune::all();
        foreach($communes as $commune) $t_communes[$commune->id]=$commune->nom;

        return View::make('structures.etablissements.create',[
                'user' => $user, 'menu' => $this->menu, 'mode' => $mode,
                "t_communes" => $t_communes
            ]);
    }

    public function store(EtablissementRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter etablissements")) return Redirect::route('home');

        $etablissement = $this->setData($request);
 
        return Redirect::to('/etablissements');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier etablissements")) return Redirect::route('home');

        $etablissement = Etablissement::find($id);

        $t_communes=array();
        $communes = Commune::all();
        foreach($communes as $commune) $t_communes[$commune->id]=$commune->nom;

        return View::make('structures.etablissements.edit.'.$mode, [ 
            'user' => $user,'menu' => $this->menu , 'mode' => $mode,
             'etablissement' => $etablissement,"t_communes" => $t_communes
            ]);
    }
 
    public function update($id,EtablissementRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier etablissements")) return Redirect::route('home');

        $etablissement = $this->setData($request,$id);

        return $this->show($etablissement->id);
    }
 
    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter etablissements")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer etablissements")) return Redirect::route('home');

        //Pas de suppression si au moins une classe
        $nb=Classes::where("id","<>","0")->count();
        if($nb>0) return;
        //Pas de suppression si au moins un enseignant
        $nb=Enseignant::where("id","<>","0")->count();
        if($nb>0) return;

        Etablissement::destroy($id);
 
        return Redirect::to('/etablissements');
    }


    public function setData($request,$id="")
    {

        if($id!="") $etablissement =Etablissement::find($id);
        else $etablissement = new Etablissement;

        $etablissement->nom=$request->nom;
        $etablissement->rne=strtoUpper($request->rne);
        $etablissement->adresse=$request->adresse;
        $etablissement->id_commune=$request->id_commune;
        $etablissement->tel=$request->tel;
        $etablissement->fax=$request->fax;
        $etablissement->email=$request->email;
        $etablissement->cafat=$request->cafat;
        $etablissement->assurance_nom=$request->assurance_nom;
        $etablissement->assurance_ref=$request->assurance_ref;
        $etablissement->representant_nom=$request->representant_nom;
        $etablissement->representant_fonction=$request->representant_fonction;
        
        //Suppression du document
        $destinationPath=$etablissement->Path;
        if(!file_exists($destinationPath)) {
            mkdir($destinationPath);
        } 
        //Logo
        $logo_width="300";
        $logo_height="100";
        $id_pad=str_pad($id,4,"0",STR_PAD_LEFT);
        $destinationPath="public/etablissement/".$id_pad; 
        $nom_file='signature_'.$etablissement->rne;
        $msg="";$extension="";
        $image=$request->file('image');
        if($image) {
            $extension = $image->extension();
            $path = $image->storeAs($destinationPath, $nom_file."_original.".$extension);            
            $img = Image::make($image->path());
            $destinationLongPath=storage_path("app/".$destinationPath);
            //pour le dev local windows
             if(strpos(env('APP_URL'),'127.0.0.1')) {
                $destinationPath=str_replace("/storage/app/","",$destinationPath);
                $destinationLongPath=storage_path("app/".$destinationPath);
             }
            $img->resize($logo_width, $logo_height, function ($const) {
                        //$const->aspectRatio();
                    })->save($destinationLongPath.'/'.$nom_file.".".$extension);
            //"/storage/etablissement/".$id_pad."/".
            $etablissement->tampon_url=$nom_file.".".$extension;
            $etablissement->save();
            $res=true;
        }


        $etablissement->save();
 
        return $etablissement;
    }

}