<?php namespace App\Http\Controllers;

use Auth\AuthController;
use App\User;
use App\Models\Filiere;
use App\Models\FiliereCategorie;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use View;
use App\Http\Requests\FiliereRequest;


class FilieresController extends Controller {

    private $menu='parametres';
    private $submenu='filieres';

    public function index($id_filiere_categorie="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter filieres")) return Redirect::route('home');

        $categorie ="";
        $categories = FiliereCategorie::orderby('nom','ASC')->pluck('nom','id')->toArray();
        if($id_filiere_categorie) {
            $categorie = FiliereCategorie::find($id_filiere_categorie);
            $filieres = Filiere::where('id_filiere_categorie','=',$id_filiere_categorie)->get();
            Session::put('id_filiere_categorie', $id_filiere_categorie); 

        } else {
            $id_filiere_categorie=Session::get('id_filiere_categorie' ); 
            if($id_filiere_categorie) $categorie = FiliereCategorie::find($id_filiere_categorie);
        }
        $filieres = "";
        if($categorie) $filieres = Filiere::where('id_filiere_categorie','=',$id_filiere_categorie)->get();

        
        return View::make('structures.filieres.index', [
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,
            'categories' => $categories,'categorie' => $categorie,
            'filieres' =>$filieres,            
        ]);
    }

    public function index_filtre($id_filiere_categorie="")
    {
        return $this->index($id_filiere_categorie);
    }

    public function create()
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter filieres")) return Redirect::route('home');

        if(!($user=Auth::user())) return Redirect::route( 'login' );
        $mode="create";

        $categories = FiliereCategorie::orderby('nom','ASC')->pluck('nom','id')->toArray();
        $id_filiere_categorie=Session::get('id_filiere_categorie' ); 

        return View::make('structures.filieres.create',[
                'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
                'categories' => $categories,'id_filiere_categorie' => $id_filiere_categorie
            ]);

    }

    public function store(FiliereRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("ajouter filieres")) return Redirect::route('home');

        $filiere = $this->setData($request);
        $msg="La filière ".$filiere->nom." a été créée";
        Session::flash('success', $msg); 
        return Redirect::to('/filieres');
    }
 
    public function edit($id,$mode="edit")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier filieres")) return Redirect::route('home');

        $filiere = Filiere::find($id);
        $categories = FiliereCategorie::orderby('nom','ASC')->pluck('nom','id')->toArray();
        $id_filiere_categorie=Session::get('id_filiere_categorie' ); 
        return View::make('structures.filieres.'.$mode, [ 
            'user' => $user,'menu' => $this->menu,'submenu' => $this->submenu,"mode" => $mode,
            'filiere' => $filiere,
            'categories' => $categories,'id_filiere_categorie' => $id_filiere_categorie
            ]);
    }
 
    public function update($id,FiliereRequest $request)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("modifier filieres")) return Redirect::route('home');

        $filiere = $this->setData($request,$id);
        $msg="La filière ".$filiere->nom." a été mise à jour";
        Session::flash('success', $msg); 
        return Redirect::to('/filieres');
    }
 

    public function show($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("consulter filieres")) return Redirect::route('home');

        return $this->edit($id,"show");
    }

    public function destroy($id)
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );
        if(!$user->hasRole('ADMINISTRATEUR')) if(!$user->can("supprimer filieres")) return Redirect::route('home');

        $filiere = Filiere::find($id);
        $nom=$filiere->nom;
        if(!$filiere->CanDelete) {
            $msg="La filière ".$nom." ne peut pas être supprimée";
        } else {
            Filiere::destroy($id);
            $msg="La filière ".$nom." a été supprimée";   
        }  
        Session::flash('success', $msg);      
        return Redirect::to('/filieres');
    }

    public function setData($request,$id="")
    {
        if(!($user=Auth::user())) return Redirect::route( 'login' );

        if($id=="") $filiere =  new Filiere;
        else $filiere = Filiere::find($id);

        $filiere->nom=($request->nom);
        $filiere->id_filiere_categorie=($request->id_filiere_categorie);
        $filiere->save();
 
        Session::put('id_filiere_categorie', $filiere->id_filiere_categorie); 
        return $filiere;
    }
}