<?php namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use DB;
use Illuminate\Support\Facades\Auth;

class Stage extends Model {
	
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
	protected $table = 'stages';

    public $t_referents_base = ["ENT_RESP","ENT_TUT","PROF_REF","CHEF_ETAB"];

    /* Dates */
    public function getDates()
    {
            return array('date_deb','date_fin');
    }


    public function getDateDebAttribute($value)
    {
        return ($this->attributes['date_deb']!=null)?date('d/m/Y', strtotime($this->attributes['date_deb'])):null;
    }

     public function getDateFinAttribute($value)
    {
        return ($this->attributes['date_fin']!=null)?date('d/m/Y', strtotime($this->attributes['date_fin'])):null;
    }


    public function getPeriodeAttribute()
    {
        $periode=$this->DateDeb." au ".$this->DateFin;
        return $periode;
    }


    public function getCategorie()
    {
        $categorie=Categorie::find($this->id_categorie);
        if(!$categorie) return "";
        return $categorie;
    }

    public function getCategorieNomAttribute()
    {
        $categorie=$this->getCategorie();
        if(!$categorie) return "";
        return $categorie->nom;
    }


    /* *************************************** */
    /*                ENTREPRISE               */
    /* *************************************** */

    public function getEntreprise()
    {
        $entreprise=Entreprise::find($this->id_entreprise);
        if(!$entreprise) return "";
        return $entreprise;
    }
    public function getEntrepriseNomAttribute()
    {
        $entreprise=$this->getEntreprise();
        if(!$entreprise) return "";
        return $entreprise->nom;
    }

    /* TUTEUR */
    public function getTuteur()
    {
        $contact=Contact::find($this->id_ent_tuteur);
        if(!$contact) return "";
        return $contact;
    }
    public function getTuteurNomCompletAttribute()
    {
        $contact=$this->getTuteur();
        if(!$contact) return "";
        return $contact->NomComplet;
    }
    public function getTuteurEmailAttribute()
    {
        $contact=Contact::find($this->id_ent_tuteur);
        if(!$contact) return "";
        return $contact->email;
    }
    public function getTuteurMobileAttribute()
    {
        $contact=Contact::find($this->id_ent_tuteur);
        if(!$contact) return "";
        return $contact->mobile;
    }

    /* Responsable */
    public function getResponsableEmailAttribute()
    {
        $contact=$this->getEntreprise()->getResponsable();
        if(!$contact) return "";
        return $contact->email;
    }
    
    /* ******* */



    /* *************************************** */
    /*                ETABLISSEMENT            */
    /* *************************************** */

    public function getEtablissement()
    {
        $eleve=$this->getEleve();
        if(!$eleve) return "";
        return $eleve->getEtablissement();
    }
  

    /* *************************************** */
    /*                PROFESSEURS              */
    /* *************************************** */
    /* Référent1 */
    public function getProfReferent()
    {
        $enseignant=Enseignant::find($this->id_enseignant);
        if(!$enseignant) return "";
        return $enseignant;
    }

    public function getNomReferent1Attribute()
    {
        $referent=$this->getProfReferent();
        if(!$referent) return "";
        return $referent->NomComplet;
    }

    /* Référent2 */
    public function getProfReferent2()
    {
        $enseignant=Enseignant::find($this->id_enseignant2);
        if(!$enseignant) return "";
        return $enseignant;
    }

    public function getNomReferent2Attribute()
    {
        $referent=$this->getProfReferent2();
        if(!$referent) return "";
        return $referent->NomComplet;
    }


    /* Référents tous */
    public function getProfsReferentsHTMLAttribute()
    {
        $lst="";
        $enseignant=$this->getProfReferent();
        if($enseignant) $lst="<b>".$enseignant->NomComplet."</b>";

        $enseignant2=$this->getProfReferent2();
        if($enseignant2) $lst.=(($lst=="")?"":"<br/>").$enseignant2->NomComplet;

        return $lst;
    }

    public function getNomReferentsHTMLAttribute()
    {
        $referent=$this->getProfReferent();
        $referent2=$this->getProfReferent2();
        $nom_referent1=($referent->NomComplet!="")?$referent->NomComplet." (1)":"";
        $nom_referent2=($referent2->NomComplet!="")?$referent2->NomComplet." (2)":"";
        $nom_referent=$nom_referent1;
        $nom_referent.=($nom_referent1!="")?"<br>":"";
        $nom_referent.=$nom_referent2;
        return $nom_referent;
    }


    /* *************************************** */
    /*                ELEVE                    */
    /* *************************************** */
    public function getEleve()
    {
        $eleve=Eleve::find($this->id_eleve);
        if(!$eleve) return "";
        return $eleve;
    }
    public function getEleveNomCompletAttribute()
    {
        $eleve=$this->getEleve();
        if(!$eleve) return "";
        return $eleve->NomComplet;
    }

    /* *************************************** */
    /*                CLASSE                   */
    /* *************************************** */
    public function getClasseNomCompletAttribute()
    {
        $eleve=$this->getEleve();
        if(!$eleve) return "";
        return $eleve->NomClasseLong;
    }


    /* *************************************** */
    /*                STATUT                   */
    /* *************************************** */
    public function setStatut()
    {
        //Si pas de statut et données incomplètes => INI
        if( (($this->statut=="") || ($this->statut=="ACC-PRE")) 
            && ($this->isDataEntrepriseOK())
            ) 
        {
            $this->statut="INI";
            return;
        }

        //Si INI mais données entreprises saisies => ACC-PRE
        if(($this->statut=="INI") && (!$this->isDataEntrepriseOK())) $this->statut="ACC-PRE";
        //Si ACC-PRE mais données entreprises saisies => ACC-PRE
       // if($this->statut=="ACC-PRE")

    }   

    /* *************************************** */
    /*                ENTREPRISE               */
    /* *************************************** */
    public function isDataEntrepriseOK()
    {
        $nb_err=0;
        $nb_err+=($this->id_entreprise==0); 
        $nb_err+=($this->id_ent_tuteur==0);
        $nb_err+=($this->id_enseignant==0); 
        $nb_err+=($this->id_categorie==0);
        return ($nb_err==0);
    }


    /* *************************************** */
    /*                STATUT                   */
    /* *************************************** */
     public function getAttestationEnCoursAttribute()
    {
        if($this->statut=="ATT-PRE") return true;
        if($this->statut=="ATT-SIP") return true;
        if($this->statut=="ATT-SIT") return true;
        if($this->statut=="TER") return true;
        else return false;
    }

    /* STATUT */
     public function getNomStatutAttribute()
    {
        $statuts=MyApp::STATUTS_STAGES;
        return $statuts[$this->statut];
    }


    /* Retourne vrai si toutes les données sont saisies */
    public function getSaisieCompleteAttribute()
    {
        if(!$this->id_entreprise) return false;
        if(!$this->id_ent_tuteur) return false;
        if(!$this->id_categorie) return false;
        if(!$this->id_enseignant) return false;
        if(!$this->horaires) return false;
        if(!$this->nbheures) return false;

        return true;
    }

    // Retour : vrai si suprpession possible */
    public function getCanDeleteAttribute()
    {
        $can_delete=1;
        //On peut sipprimer si :
        $nb=0;
        $nb+=Document::where("id_stage","=",$this->id)->count(); //Pas de documents associés
        return ($nb==0);
    }



    /* *************************************** */
    /*                DOCUMENTS                */
    /* *************************************** */
    public function getDocument($nomcourt_type)
    {
        $type_document=TypeDocument::where("nom_court","=",$nomcourt_type)->first();
        if(!$nomcourt_type) return "";
        $document=Document::where("id_stage","=",$this->id)
            ->where('id_type_document','=',$type_document->id)->first();
        
        return $document;
    }

    public function getDocuments()
    {
        $documents=Document::where("id_stage","=",$this->id)->orderby('nom','ASC')->get();
        return $documents;
    }

    public function getDocumentId($nomcourt_type)
    {
        $document=$this->getDocument($nomcourt_type);
        if(!$document) return "";
        
        return $document->id;
    }


    /* Retour : TypeDocument non encore générés pour ce stage ; O sinon */
    public function getDocToDOAttribute()
    {
        $documents=Document::select('id_type_document')
            ->where('id_stage','=',$this->id)->pluck('id_type_document')->toArray();

        $type_document=TypeDocument::whereNotIn('id',$documents)->get();
        if(!$type_document) return false;
        return $type_document;
    }

    /* Retour : ID du document correspondnat au nom court */
/*
    public function getIdDocument($nomcourt_type)
    {
        $document=$this->getDocuments($nomcourt_type)->first();
        if(!$document) return ""; 
        return $document->id;
    }
*/


    /* *************************************** */
    /*                TYPE STAGE               */
    /* *************************************** */
    /* Retourne le type de stage asscoiés à ce stage */
    public function getTypeStage() {
        $session=SessionStage::find($this->id_session);
        if(!$session) return "";
        $type_stage=TypeStage::find($session->id_type_stage);
        if(!$type_stage) return "";
        return $type_stage;
    }


    /* *************************************** */
    /*               MODELES                   */
    /* *************************************** */
    /* Retourne les modeles asscoiés à ce stage */
    public function getModeles() {
        $type_stage=$this->getTypeStage();
        if(!$type_stage) return "";
        $modeles=$type_stage->getModeles();
        if(!$modeles) return ""; 
        return $modeles;
    }

    /* *************************************** */
    /*               SIGNATURES                */
    /* *************************************** */
    public function getSignature($id_document,$id_type_signataire) {
        $signature=Signature::where('id_document','=',$id_document)
            ->where('id_type_signataire','=',$id_type_signataire)->first();
        if(!$signature) return "";
        return  $signature;
    }

    public function getConventionSignatureRespOK($nom_court_document) {
        $document=$this->getDocument($nom_court_document);
        if(!$document) return "";
        $type_signataire=TypeSignataire::where('nom_court','=','ENT_RESP')->first();
        if(!$type_signataire) return "";
        $signature=$this->getSignature($document->id,$type_signataire->id);

        if(!$signature) return "";
        return $signature->date;
    }


    /*
    Retourne les Types de signataires asscoiés à ce stage
    */
    public function getTypesSignataires($nomcourt_type_document) {
        $type_document=TypeDocument::where('nom_court','=',$nomcourt_type_document)->first();
        $trouve=false;
        $modeles=$this->getModeles();
        foreach($modeles as $modele) {
            if($nomcourt_type_document==$modele->NomCourtTypeDocument) $trouve=true;
        } 
        if(!$trouve) return "";
        return $modele->TypesSignataires;
    }

    /*
    Retourn le nom du signataire pour le nomcourt_type donné
    */
    /*
    public function getNomSignataires($nomcourt_type_document) {
        $t=array();
        $types_signataires=$this->getTypesSignataires($nomcourt_type_document); 
        if(!$types_signataires) return "";
        foreach($types_signataires as $type_signataire){
            if($type_signataire->nom_court=='ENT_RESP') {$nom=$this->getEntreprise()->NomComplet;break;}
            if($type_signataire->nom_court=='ENT_RESP') {$nom=$this->EntreprisResponsableNom;break;}
            if($type_signataire->nom_court=='ENT_TUT')  {$nom=$this->TuteurNom;break;}
            if($type_signataire->nom_court=='PROF_REF') {$nom=$this->NomEnseignant1;break;}
            if($type_signataire->nom_court=='PROF_REF2') {$nom=$this->NomEnseignant2;break;}
            if($type_signataire->nom_court=='CHEF_ETAB') {$nom=$this->NomChefEtablissement;break;}
            if($type_signataire->nom_court=='DDF') {$nom=$this->NomDDF;break;}
            if($type_signataire->nom_court=='ELEVE') {$nom=$this->NomCompletEleve;break;}
        }
        return $nom;
    }*/

    /*
    Retourn le nom du signataire pour le nomcourt_type donné
    */
    public function getNomDateHTMLSignataires($nomcourt_type_document) {
        $t=array();
        $types_signataires=$this->getTypesSignataires($nomcourt_type_document); 
        if(!$types_signataires) return "";
        $type_document=TypeDocument::where("nom_court","=",$nomcourt_type_document)->first();
        if(!$type_document) return "";
        $document=Document::where("id_stage","=",$this->id)
            ->where('id_type_document','=',$type_document->id)->orderby('nom','ASC')->first();
        if(!$document) return "";

        $lst_HTML="";
        $class_signature_ok="class='btn bg-gradient-success' style='width:135px;margin-bottom:3px;margin-right:7px;font-size:0.9em;padding:4px'";
        $class_signature_nok="class='btn bg-gradient-warning' style='width:135px;margin-bottom:3px;margin-right:7px;font-size:0.9em;padding:4px'";
        foreach($types_signataires as $type_signataire){
            $libelle="";
            $prefixe=$type_signataire->nom." : ";
            $signature=$this->getSignature($document->id,$type_signataire->id);

            if($signature) {
                $nom=str_replace(' ','&nbsp;',$signature->nom_signataire);
                $info_signature="&nbsp;Signé&nbsp;le&nbsp;"."<b>".$signature->DateJMA."</b>";
                $libelle="<span ".$class_signature_ok.">".$info_signature."</span>".$prefixe.$nom;
            }
            else {
                $nom="";
                if($type_signataire->nom_court=='ENT_RESP') 
                    $nom=isset($this->getEntreprise()->getResponsable()->NomComplet)?$this->getEntreprise()->getResponsable()->NomComplet:"";

                if($type_signataire->nom_court=='ENT_TUT')  
                    $nom=isset($this->getTuteur()->NomComplet)?$this->getTuteur()->NomComplet:"";

                if($type_signataire->nom_court=='PROF_REF') 
                    $nom=isset($this->getProfReferent()->NomComplet)?$this->getProfReferent()->NomComplet:"";

                if($type_signataire->nom_court=='PROF_REF2') 
                    $nom=isset($this->getProfReferent()->NomComplet)?$this->getProfReferent()->NomComplet:"";

                if($type_signataire->nom_court=='CHEF_ETAB') { 
                    $nom=$this->getEtablissement()->representant_nom;
                    $nom="toto";
                }

                if($type_signataire->nom_court=='DDF') {
                    $user_ddf=$type_signataire->getUserSignataire($this->id);
                    if($user_ddf) $nom=$user_ddf->name;
                }

                if($type_signataire->nom_court=='ELEVE') 
                    $nom=$this->getEleve()->NomComplet;

                if($nom!="") {
                    $nom=str_replace(' ','&nbsp;',$nom);
                    $info_signature="Doit&nbsp;signer";
                    $libelle="<span ".$class_signature_nok.">".$info_signature."</span>".$prefixe."<b>".$nom."</b>";
                }
            }
            
            $lst_HTML.=(($lst_HTML=="")?"":"<br/>").$libelle;
        }
        return $lst_HTML;
    }

    public function getDocumentsHTML($nomcourt_type)
    {
        $statut="";
        //$type_stage=TypeStage::find($session->id_type_stage);
        //$entreprise=$this->getEntreprise();
        //$responsable=$entreprise->getResponsable;
        //$tuteur=Contact::find($this->id_ent_tuteur);
        //$type_signataire_responsable=TypeSignataire::where("nom_court","=","ENT_RESP")->first();
        //$type_signataire_tuteur=TypeSignataire::where("nom_court","=","ENT_TUT")->first();
        //$documents=$this->getDocuments($nomcourt_type);

        return $this->getNomSignataires($nomcourt_type) ;
    }


    /* *************************************** */
    /*               RERERENTS                */
    /* *************************************** */
    /*
    Liste de tous les référents pour la avec leur statut et nom 
    */
    public function getReferentsHTML($mode="") {
        $referents=$this->t_referents_base; //Types de signataires sonsidérés
        $lst="";$sep="<br/>";
        $entreprise=$this->getEntreprise();
        $ent_responsable=$entreprise->getResponsable();
        $ent_tuteur=$this->getTuteur();
        $prof_referent=$this->getProfReferent();
        $prof_referent2=$this->getProfReferent2();
        $eleve=$this->getEleve();
        $etablissement=$this->getEtablissement();

        foreach($referents as $nom_court) {
            $nom="";
            $type_signataire=TypeSignataire::where('nom_court','=',$nom_court)->first();

            if($nom_court=='ENT_RESP') {
                $tel=(isset($ent_responsable->tel)?$ent_responsable->tel:"");
                $nom="<b>".(isset($ent_responsable->NomComplet)?$ent_responsable->NomComplet:"")."</b>";
                if($tel!="" && $mode!="ENT") $nom.=" - Tel: ".$tel;
            }

            if($nom_court=='ENT_TUT')  {
                $tel=(isset($ent_tuteur->tel)?$ent_tuteur->tel:"");
                $nom="<b>".(isset($ent_tuteur->NomComplet)?$ent_tuteur->NomComplet:"")."</b>";
                if($tel!="" && $mode!="ENT") $nom.=" - Tel: ".$tel;
            }

            if($nom_court=='PROF_REF') {
                $tel=(isset($prof_referent->tel)?$prof_referent->tel:"");
                $nom="<b>".(isset($prof_referent->NomComplet)?$prof_referent->NomComplet:"")."</b>";
                if($tel!="") $nom.=" - Tel: ".$tel;
            }

            if($nom_court=='PROF_REF2') {
                $tel=(isset($prof_referent->tel)?$prof_referent->tel:"");
                $nom="<b>".(isset($prof_referent->NomComplet)?$prof_referent->NomComplet:"")."</b>";
                if($tel!="") $nom.=" - Tel: ".$tel;
            }

            if($nom_court=='CHEF_ETAB') {
                $tel=$etablissement->tel;
                $nom="<b>".$etablissement->representant_nom."</b>";
                if($tel!="") $nom.=" - Tel: ".$tel;
            }

            if($nom_court=='DDF') {
                $tel=$etablissement->tel;
                $nom="<b>".$etablissement->NomDDF."</b>";
                if($tel!="") $nom.=" - Tel: ".$tel;
            }

            if($nom_court=='ELEVE') {
                $tel=$eleve->tel;
                $nom="<b>".$eleve->NomComplet."</b>";
                if($tel!="") $nom.=" - Tel: ".$tel;
            }

            $lst.=(($lst=="")?"":$sep).$type_signataire->nom." : ".$nom;
        }
        return $lst;
    }



    /* *************************************** */
    /*               EMAILS                    */
    /* *************************************** */
    public function getEmail($type_signataire) {
        $referents=$this->t_referents_base; //Types de signataires sonsidérés
        $entreprise=$this->getEntreprise();

        $email="";
        //Si user saisi dans type signataire
        $user_signataire=$type_signataire->getUserSignataire($this->id);
        if($user_signataire) return $user_signataire->email;

        //ChefEtab
        if($type_signataire->nom_court=='CHEF_ETAB') {
            $etablissement=$this->getEtablissement();
            if($etablissement) $email=$etablissement->email; 
        }

        //DDF
        if($type_signataire->nom_court=='DDF') {
            $etablissement=$this->getEtablissement();
            if($etablissement) $email=$etablissement->email;
        }

        //EmailResponsable
        if($type_signataire->nom_court=='ENT_RESP') {
            $entreprise=$this->getEntreprise();
            $responsable=$entreprise->getResponsable();
            if($responsable) $email=$responsable->email;
        }

        //EmailTuteur
        if($type_signataire->nom_court=='ENT_TUT') {
            $tuteur=Contact::find($this->id_ent_tuteur);
            if($tuteur) $email=$tuteur->email;
        }

        //Email PROF_REF
        if($type_signataire->nom_court=='PROF_REF') {
            $enseignant=$this->getProfReferent();
            if($enseignant) $email=$enseignant->email;
        }

        //Email CHEF_ETAB
        if($type_signataire->nom_court=='PROF_REF2') {
            $enseignant=$this->getProfReferent();
            if($enseignant) $email=$enseignant->email;
        }


        //Email ELEVE
        if($type_signataire->nom_court=='ELEVE') {
            $eleve=$this->getEleve();
            if($eleve) return $eleve->email;
        }

        return $email;
    }



}
