<?php namespace App\Models\Structures;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Auth\Authenticatable;


class Formation extends Model {
	/**
	 * The database table used by the model.
	 *
	 * @var string
	 */
    protected $connection = 'mysql2';
	protected $table = 'formations';

    public function getNomEtablissementCourtAttribute()
    {
        $etablissement = Etablissement::where('ENS_UAI','=',$this->uai)->first();
        if(!$etablissement) return "";
        $nom=$etablissement->ENS_LIEU;
        $nom=str_replace('Lycée','Ly.',$nom);
        return $nom;
    }

    public function getNomEtablissementAttribute()
    {
        $etablissement = Etablissement::where('ENS_UAI','=',$this->uai)->first();
        if(!$etablissement) return "";
        $nom=$etablissement->ENS_LIEU;
        return $nom;
    }

    public function getCommuneAttribute()
    {
        $etablissement = Etablissement::where('ENS_UAI','=',$this->uai)->first();
        if(!$etablissement) return "";
        $nom=$etablissement->ENS_CP." ".$etablissement->ENS_COMMUNE;
        return $nom;
    }

    public function getLatitudeAttribute()
    {
        $etablissement = Etablissement::where('ENS_UAI','=',$this->uai)->first();
        if(!$etablissement) return "";

        return $etablissement->ENS_LATITUDE ;
    }

    public function getLongitudeAttribute()
    {
        $etablissement = Etablissement::where('ENS_UAI','=',$this->uai)->first();
        if(!$etablissement) return "";

        return $etablissement->ENS_LONGITUDE ;
    }

}
