@extends('layouts.dash')
@section('title') Rôles @stop
@section('title_card',"Rôles")
@section('subtitle_card',"Liste complète")
@section('content')
    <div class="card">
        <div class="card-body">
            <table id="_table" width="100%" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width=30%'>Nom</th>
                        <th >Utilisateurs</th>
                        <th width='75px'>
                            @if($user->can("ajouter roles") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('roles/create') !!}" class="btn btn-sm btn-success">
                                <span class='ti-plus'></span>&nbsp;Nouveau Rôle</a> 
                            @endif
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($roles as $role)
                    <tr>
                        <td>
                            <a href="{!! url('roles/'.$role->id) !!}" >{!! $role->name !!}</a>
                        </td>
                        <td nowrap style=''>{!! $role->NomUsers !!}</td>  
                        <td nowrap>
                            @if($user->hasRole("ADMINISTRATEUR") || $user->can("supprimer roles"))
                                {{ html()->form('DELETE', url('/roles/'. $role->id))->open() }}   
                                {{ csrf_field() }}
                            @endif
                            <a href="./roles/{!! $role->id !!}/edit" class="btn btn-sm btn-info pull-left" style="margin-right: 3px;">
                                <span class='ti-pencil-alt'></span>
                            </a>
                            <button class="btn btn-sm btn-danger"><span class='ti-trash'></span></button>
                            @if($user->hasRole("ADMINISTRATEUR") || $user->can("supprimer roles"))
                                {{ html()->form()->close() }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection


@section('scripts')
    @include("forms.scripts_datatable")
@endsection


