@extends('layouts.dash')
{!! $with_navbar=false !!}
@section('title') Utilisateur @stop
@section('title_card',"Consultation d'un Utilisateur")

@section('content')
<div class="card">
    <!-- Right Panel -->
    <div id="right-panel" class="right-panel">
        @if ($errors)
            @foreach ($errors->all() as $error)
                <div class='bg-danger alert'>{!! $error !!}</div>
            @endforeach
        @endif 
        <div class="col-lg-max col-lg-offset-1 container-fluid"> 
        {{ html()->modelForm($user_sel)->attributes(['class' => 'form-horizontal'])->open() }}
            @include('acces.users.content')
        {{ html()->closeModelForm() }}
    </div>
</div>
@endsection


@section('styles')
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop

@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script> 
    <script>
        $(document).ready(function() {
            $(".email_pop").fancybox({
                //maxWidth    : '900px',
                //maxHeight   : '950px',
                fitToView   : false,
                //width       : '85%',
                //height      : '95%',
                autoSize    : true,
                //type        : 'iframe',
                autoScale   : false,
                closeClick  : true,
                openEffect  : "zoom",
                closeEffect : 'zoom',
                type: "iframe",
                beforeClose: function () {

                },
                afterClose: function () {
                    //location.reload();
                }
            });
        } );
    </script> 
@endsection