@extends('layouts.dash_map')

@section('content')
    <!-- ======= Featured Section ======= -->
    <section id="featured" class="featured2">
        <div class="container" style="">
            {{ html()->form('POST', url('/agenda'))->attributes(['id'=>'form_agenda'])->open() }}
                <div class="row agenda-box2" style="height:">
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-lg-12" align="right">
                                    <small>{!! count($formations) !!} Lycées</small>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-3">
                                <h4 >Région<small style='font-size:.6em;color:red'>&nbsp;obligatoire</small></h4>
                                <select id='sel_region' class="form-control" style="margin-bottom:30px">
                                    <option id='id_opt_region_0' value='0'></option>
                                    @foreach($regions as $region)
                                        <option {!! ($id_region==$region->id)?'selected':'' !!} id='id_opt_region_{!! $region->id !!}' value='{!! $region->id !!}'>{!! $region->nom !!}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if($departements)
                                <div class="col-lg-3">
                                    <h4 >Département</h4>
                                    <select id='sel_departement' class="form-control" style="margin-bottom:30px">
                                        <option id='id_opt_departement_0' value='0'></option>
                                        @foreach($departements as $departement)
                                            <option {!! ($id_departement==$departement->id)?'selected':'' !!} id='id_opt_departement_{!! $departement->id !!}' value='{!! $departement->id !!}'>{!! $departement->nom !!}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            <div class="col-lg-3">
                                <h4 >Niveau</h4>
                                <select id='sel_niveau' class="form-control" style="margin-bottom:30px">
                                    <option id='id_opt_niveau_0' value='0'></option>
                                    @foreach($niveaux as $niveau)
                                        <option {!! ($id_niveau==$niveau->id)?'selected':'' !!} title="{!! $niveau->nom !!}" id='id_opt_niveau_{!! $niveau->id !!}' value='{!! $niveau->id !!}'>{!! $niveau->nom !!}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-lg-3">
                                <h4>Domaine</h4>
                                <select id='sel_domaine' class="form-control" style="margin-bottom:30px">
                                    <option id='id_opt_domaine_0' value='0'></option>
                                    @foreach($domaines as $domaine)
                                        <option {!! ($id_domaine==$domaine->id)?'selected':'' !!} id='id_opt_domaine_{!! $domaine->id !!}' value='{!! $domaine->id !!}'>{!! $domaine->nom !!}</option>
                                    @endforeach
                                </select>
                            </div>


                        </div>
                        @if($isLimited>0)
                            <div align="center">La liste est limitée à {{ $isLimited}} sur {{ $total_result }} Formations.</div>
                        @else
                            <div align="center">{{ $total_result }} Formations correspondantes</div>
                        @endif
                    </div>
                </div>
            {{ html()->form()->close() }}

            <div class="row agenda-box" style="padding:0px;">
                <div class="row col-md-12">

                    @if($formations)
                        <div class="col-md-8">
                            @include("agendas.calendar")
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">Carte</h4>
                                </div>
                                <div class="card-body">
                                    <div id="map" style="width: 600px; height: 400px;"></div>
                                </div>
                                <div class="card-footer">
                                    <h4 class="card-title">Ma position:</h4>
                                    <p>Your Location: <span id="location">aa</span></p>
                                </div>
                            </div>
                        </div>
                    @else
                        <div align="center">Choisissez une région et un niveau pour accéder à la liste des formations</div>
                    @endif
                </div>
            </div>
        </div>
    </section><!-- End Featured Section -->


@endsection


@section('style')

@endsection



<!-- ======= SCRIPTS SECTION ======= -->
@section('scripts')
<script>
    /*
    $(document).ready(function(){
        if(navigator.geolocation){
            navigator.geolocation.getCurrentPosition(showLocation);
        }else{
            $('#location').html('Geolocation is not supported by this browser.');
        }
    });

    function showLocation(position){
        var latitude = position.coords.latitude;
        var longitude = position.coords.longitude;
        $("#location").html(longitude);
        $.ajax({
            type:'POST',
            url:"{!! url('getLocation') !!}",
            data:'latitude='+latitude+'&longitude='+longitude,
            success:function(msg){
                alert(msg);
                if(msg){

                   $("#location").html(msg);
                }else{
                    $("#location").html('Not Available');
                }
            }
        });
    }
    */
    </script>

<script>
    $(function () {
        var location_base={!!  $Base_GPS !!};
        var locations = {!! $t_GPS !!};
        var idFormations = {!! $t_IdFormations !!};
        var idEtablissements = {!! $t_IdEtablissements !!};
        var marker=[];
        var mode=1;

        const map = L.map('map').setView(location_base, 8);

        const tiles = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
            maxZoom: 19,
            attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
        }).addTo(map);


        function setMarkers() {
            for (var i = 0; i < locations.length; i++) {
                marker[i] = new L.marker([locations[i][1], locations[i][2]])
                    .bindPopup(locations[i][0])
                    .addTo(map);
            }
        }
        function unsetMarkers() {
            for (var i = 0; i < locations.length; i++) {
                if(mode) {
                    map.removeLayer(marker[i]);
                    $('.wp_'+idEtablissements[i]).attr("style","color:grey");
                }
                else {
                    map.addLayer(marker[i]);
                    $('.wp_'+idEtablissements[i]).attr("style","color:#e96b56");
                }
            }
        }


        $('.bt_waypoint').click(function(){
            var t = $(this).attr('id').substr(3);
            for (var i = 0; i < locations.length; i++) {
                if(idEtablissements[i]==t) {
                    if(map.hasLayer(marker[i])) {
                        map.removeLayer(marker[i]);
                        $('.wp_'+idEtablissements[i]).attr("style","color:grey");
                    }
                    else {
                        map.addLayer(marker[i]);
                        $('.wp_'+idEtablissements[i]).attr("style","color:#e96b56");
                    }
                }
            }

        })

        $('#bt_marker_all').click(function(){
            var mode = $('#mode_marker').attr('value');
            if(mode==1) {
                unsetMarkers();
                $('#mode_marker').attr('value',0);
                $('.wp_td').attr("style","color:grey");
            }
            else {
                setMarkers(marker);
                $('#mode_marker').attr('value',1);
                $('.wp_td').attr("style","color:#e96b56");
            }

        })

        setMarkers(marker);
        //const marker = L.marker([51.5, -0.09]).addTo(map)
        //	.bindPopup('<b>Hello world!</b><br />I am a popup.').openPopup();

        //const popup = L.popup()
        //	.setLatLng(location_base)
        //	.setContent('I am a standalone popup.')
        //	.openOn(map);

        //function onMapClick(e) {
        //	popup
        //		.setLatLng(e.latlng)
        //		.setContent(`Vous avez cliquez su la position ${e.latlng.toString()}`)
        //		.openOn(map);
        //}

	    //map.on('click', onMapClick);
    });
</script>

    <script>
        // requires jquery library
        $(function () {
            $('#sel_region').change(function() {reload();});
            $('#sel_domaine').change(function() {reload();});
            $('#sel_niveau').change(function() {reload();});
            $('#sel_departement').change(function() {reload();});

            function reload() {
                var region=$('#sel_region').val();
                var domaine=$('#sel_domaine').val();
                var niveau=$('#sel_niveau').val();
                var url ='{{ url("agenda_filtre") }}'+'/'+region+'/'+domaine+'/'+niveau;
                @if($departements)
                    var departement=$('#sel_departement').val();
                    url = url +'/'+departement;
                @endif
                window.location.href =url;
                return false;
            }
        });
    </script>

    @include("agendas.datatable")
@endsection

