
<html>ddd
    <head>
        <title>A Leaflet map!</title>
        <link media="all" type="text/css" rel="stylesheet" href="{{ url('leaflet/leaflet.css') }}">

        <!-- jQuery -->
        <script src="{{ url('leaflet/leaflet.js') }}"></script>
        <script src="{{ url('AdminLTE-master/plugins/jquery/jquery.min.js') }}"></script>

        <style>
            #map{ height: 100% }
        </style>
    </head>


    <body>

        <div id="map"></div>



        <script>
            $(document).ready(function() {
                // initialize the map
                var map = L.map('map').setView([42.35, -71.08], 13);

                // load a tile layer
                L.tileLayer('http://tiles.mapc.org/basemap/{z}/{x}/{y}.png',
                {
                    attribution: 'Tiles by <a href="http://mapc.org">MAPC</a>, Data by <a href="http://mass.gov/mgis">MassGIS</a>',
                    maxZoom: 17,
                    minZoom: 9
                }).addTo(map);

                // load GeoJSON from an external file
                $.getJSON("rodents.geojson",function(data){
                // add GeoJSON layer to the map once the file is loaded
                L.geoJson(data).addTo(map);
                });

            });

        </script>
    </body>
</html>
