@extends('layouts.dash_map')

@section('content')
    <!-- ======= Featured Section ======= -->
    <section id="featured" class="featured2">
        <div class="container" style="">
            {{ html()->form('POST', url('/agenda'))->attributes(['id'=>'form_agenda'])->open() }}
                <div class="row agenda-box2" style="height:">
                    <div class="col-lg-12">
                        <div class="row">
                            <div class="col-lg-12" align="right">
                                    <small>{!! count($formations) !!} Lycées</small>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-3">
                                <h4 >Région<small style='font-size:.6em;color:red'>&nbsp;obligatoire</small></h4>
                                <select id='sel_region' class="form-control" style="margin-bottom:30px">
                                    <option id='id_opt_region_0' value='0'></option>
                                    @foreach($regions as $region)
                                        <option {!! ($id_region==$region->id)?'selected':'' !!} id='id_opt_region_{!! $region->id !!}' value='{!! $region->id !!}'>{!! $region->nom !!}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if($departements)
                                <div class="col-lg-3">
                                    <h4 >Département</h4>
                                    <select id='sel_departement' class="form-control" style="margin-bottom:30px">
                                        <option id='id_opt_departement_0' value='0'></option>
                                        @foreach($departements as $departement)
                                            <option {!! ($id_departement==$departement->id)?'selected':'' !!} id='id_opt_departement_{!! $departement->id !!}' value='{!! $departement->id !!}'>{!! $departement->nom !!}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @endif
                            <div class="col-lg-3">
                                <h4 >Niveau</h4>
                                <select id='sel_niveau' class="form-control" style="margin-bottom:30px">
                                    <option id='id_opt_niveau_0' value='0'></option>
                                    @foreach($niveaux as $niveau)
                                        <option {!! ($id_niveau==$niveau->id)?'selected':'' !!} title="{!! $niveau->nom !!}" id='id_opt_niveau_{!! $niveau->id !!}' value='{!! $niveau->id !!}'>{!! $niveau->nom !!}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-lg-3">
                                <h4>Domaine</h4>
                                <select id='sel_domaine' class="form-control" style="margin-bottom:30px">
                                    <option id='id_opt_domaine_0' value='0'></option>
                                    @foreach($domaines as $domaine)
                                        <option {!! ($id_domaine==$domaine->id)?'selected':'' !!} id='id_opt_domaine_{!! $domaine->id !!}' value='{!! $domaine->id !!}'>{!! $domaine->nom !!}</option>
                                    @endforeach
                                </select>
                            </div>


                        </div>
                        @if($isLimited>0)
                            <div align="center">La liste est limitée à {{ $isLimited}} sur {{ $total_result }} Formations.</div>
                        @else
                            <div align="center">{{ $total_result }} Formations correspondantes</div>
                        @endif
                    </div>
                </div>
            {{ html()->form()->close() }}

            <div class="row agenda-box" style="padding:0px;">
                <div class="row col-md-12">

                    @if($formations)
                        <div class="col-md-8">
                            @include("agendas.calendar_bck4")
                        </div>
                        <div class="col-md-4">
                            <div id="map" style="width: 600px; height: 400px;"></div>

                        </div>
                    @else
                        <div align="center">Choisissez une région et un niveau pour accéder à la liste des formations</div>
                    @endif
                </div>
            </div>
        </div>
    </section><!-- End Featured Section -->


@endsection


@section('style')

@endsection



<!-- ======= SCRIPTS SECTION ======= -->
@section('scripts')
<script>
    var location_base={!!  $Base_GPS !!};

    var locations = {!! $t_GPS !!};

	const map = L.map('map').setView(location_base, 8);
    const myCustomColour = '#583470';
    var greenIcon = new L.Icon({
        iconUrl: 'https://raw.githubusercontent.com/pointhi/leaflet-color-markers/master/img/marker-icon-2x-green.png',
        shadowUrl: 'https://cdnjs.cloudflare.com/ajax/libs/leaflet/0.7.7/images/marker-shadow.png',
        iconSize: [25, 41],
        iconAnchor: [12, 41],
        popupAnchor: [1, -34],
        shadowSize: [41, 41]
    });

	const tiles = L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
		maxZoom: 19,
		attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
	}).addTo(map);

    for (var i = 0; i < locations.length; i++) {
        marker[i] = new L.marker(
            [locations[i][1], locations[i][2]], {icon: greenIcon})
            .bindPopup(locations[i][0])
            .on('click', function(e) { return "";})
            .addTo(map)
            ;
    }

    function setWaypoint() {
        setWaypoint()
        return false;
    }
	//const marker = L.marker([51.5, -0.09]).addTo(map)
	//	.bindPopup('<b>Hello world!</b><br />I am a popup.').openPopup();

	//const popup = L.popup()
	//	.setLatLng(location_base)
	//	.setContent('I am a standalone popup.')
	//	.openOn(map);

	//function onMapClick(e) {
	//	popup
	//		.setLatLng(e.latlng)
	//		.setContent(`Vous avez cliquez su la position ${e.latlng.toString()}`)
	//		.openOn(map);
	//}

	map.on('click', onMapClick);

</script>

    <script>
        // requires jquery library
        $(function () {
            $('#sel_region').change(function() {reload();});
            $('#sel_domaine').change(function() {reload();});
            $('#sel_niveau').change(function() {reload();});
            $('#sel_departement').change(function() {reload();});

            function reload() {
                var region=$('#sel_region').val();
                var domaine=$('#sel_domaine').val();
                var niveau=$('#sel_niveau').val();
                var url ='{{ url("agenda_filtre") }}'+'/'+region+'/'+domaine+'/'+niveau;
                @if($departements)
                    var departement=$('#sel_departement').val();
                    url = url +'/'+departement;
                @endif
                window.location.href =url;
                return false;
            }
        });
    </script>

    <script>
        $(function () {
            $("#_table").DataTable({
                fixedColumns: {
                    left: 2
                },
                "paging": true,
                "lengthChange": false,
                "searching": true,
                "ordering": false,
                "info": false,
                "responsive": false,
                "autoWidth": true,
                "scrollCollapse": false,
                deferRender:    false,
                iDisplayLength:20,
                //"scrollX": true,
                //"scrollY": 600,

            oLanguage: {
                    "sLengthMenu": 'Lignes par page <select>'+
                    '<option value="25">25</option>'+
                    '<option value="50">50</option>'+
                    '<option value="100">100</option>'+
                    '<option value="-1">Tous</option>'+
                    '</select> ',
                    "sZeroRecords": "Aucune ligne",
                    "sInfo": "Affichage de _START_ &agrave; _END_ sur _TOTAL_ lignes",
                    "sInfoEmpty": "Showing 0 to 0 of 0 records",
                    "sInfoFiltered": "(sur un total de _MAX_ lignes)",
                    "oPaginate": {"sPrevious": "Pr&eacute;c&eacute;dente","sNext": "Suivante"
                        ,"sFirst": "Premi&egrave;re","sLast": "Derni&egrave;re"},
                        "sSearch":"Chercher",

                },
            })
        });
    </script>
@endsection

