@extends('layouts.dash')

@section('title') Sessions @stop
@section('title_card',"Sessions")
@section('subtitle_card',"Liste")


@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
            <a href="{!! url('sessions') !!}" class="btn btn-success  btn-sm">
                <i class='fa fa-list'></i>&nbsp;&nbsp;Liste des Sessions</a> 
        </div>
        <div class="card-body">
            <div class="text-muted">
                Cliquez sur la session en couleur pour accéder au détail
            </div>
            <table id="table_stage" class=" table-hover table-striped  table-bordered" >
                <thead>
                    <tr>
                        <th rowspan="2" style="text-align:center">Classes</th>
                        <th colspan="53" style="text-align:center">Occupation des stages par semaine sur {!! "2023" !!}</th>
                    </tr>
                    <tr>
                        @foreach($semaines as $semaine)
                            @php $t=explode("|",$semaine); @endphp
                            <th title="{!! $t[1].' au '.$t[2] !!}" class="cell_th cells" >
                                {!! str_pad($t[0],2,"0",STR_PAD_LEFT) !!}
                            </th>
                        @endforeach
                    </tr>
                </thead>
            @foreach($classes as $classe)
                @php
                    $nb_groupe=1;
                    if($classe->groupe==1)$nb_groupe=2;
                @endphp
                @for($i=0;$i<$nb_groupe;$i++)
                <tr id='tr_week'>
                    <td width="1px" nowrap style="padding:5px">
                        {!! $classe->nom_court !!}
                        @if($nb_groupe>1)
                            {!! " - Grp ".$i !!}
                        @endif
                    </td>
                    @foreach($semaines as $semaine)
                        @php 
                            $t=explode("|",$semaine); 
                            $session=$classe->getSessionWeek($t[0],$i);
                            $style='';$title='';
                            if($session)  {
                                if($session->color==null || $session->color=="#000000") $session->color="red";
                                $style='background-color:'.$session->color;
                                $title=$session->detail;
                            }

                        @endphp
                        <td title="{!! $title !!}" id="week_{!! $classe->id.'_'.$i.'_'.$t[0].(($session)?'_'.$session->id:'') !!}" class=" cell_td cells" width="1px" style="{!! $style !!}" value="">
                            
                        </td>
                    @endforeach
                        <td>
                            <button  id="{!! url('sessions_create/'.$classe->id.'/'.$i) !!}" class="add_session_pop btn btn-sm btn-success">
                                <span class='fa fa-plus'></span>
                            </button>
                        </td>
                </tr>
                @endfor
            @endforeach 
            </table>
        </div>
    </div>
@endsection

@section('styles')
    <style>
        .cell_th {
            font-size:0.7em;

        }
        .cell_td {
            font-size:0.7em;
            padding:1px;
            margin:1px;
        }
        .cells {
            padding:1px;
            margin:1px;
            width:30px;
            text-align:center; 
        }
    </style>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox.css') }}">
    <link media="all" type="text/css" rel="stylesheet" href="{{ url('css/jquery.fancybox-buttons.css') }}">
@stop


@section('scripts0')
    <script src="{{ url('js/jquery.fancybox.js') }}"></script> 
    <script>
    $(document).ready(function() {
        $(".add_session_pop").click(function() {
            set_session(this.id);
        });

        function set_session(url) {
            $.fancybox({
                fitToView   : false,
                autoSize    : true,
                autoScale   : false,
                closeClick  : true,
                openEffect  : "zoom",
                closeEffect : 'zoom',
                type: "iframe",
                href: url,
                beforeOpen: function () {
                },
                afterClose: function () {
                }
            });
        }


        $("td.cell_td").click(function() { 
            var val=this.id;
            var t=val.split('_');
            var nbelt=t.length;
            if(nbelt==4) {
                if(confirm("Voulez-vous ajouter une session de stage ?")) {
                    var url="{!! url('sessions_create') !!}"+'/'+t[1]+'/'+t[2]+'/'+t[3];
                    set_session(url)
                }
                return false;
            }

            var url="{!! url('sessions_show') !!}"+'/'+t[4];
            set_session(url)
        } );
    });
    </script>
@endsection