@extends('layouts.dash')

@section('title') Classes @stop
@section('title_card',"Classes")
@section('subtitle_card',"Liste")

@section('content')
    @if (Session::has('message'))
        <div class="alert alert-warning">{!! Session::get('message') !!}</div>
    @endif
    @if (Session::has('success'))
        <div class="alert alert-success">{!! \Session::get('success') !!}</div>
    @endif
    @if ($errors)
        @foreach ($errors->all() as $error)
            <div class='bg-danger alert'>{!! $error !!}</div>
        @endforeach
    @endif
    <div class="card">
        <div class="card-header">
        </div>
        <div class="card-body">
            <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th width='10%'>Nom&nbsp;Court</th>
                        <th width='10%'>Niveau</th>
                        <th width='10%'>Filière</th>
                        <th width='20%'>Professeur&nbsp;Ref.</th>
                        <th width='10%'>Nb&nbsp;Elèves</th>
                        <th width='1px' nowrap>
                            @if($user->can("ajouter diplomes") || $user->hasRole("ADMINISTRATEUR"))
                            <a href="{!! url('classes/create') !!}" class="btn btn-sm btn-success">
                               <span class='fa fa-plus'></span>&nbsp;Nouvelle<br/>classe</a>   
                            @endif
                        </th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($classes as $classe)
                    <tr>
                        <td><a href="{!! url('classes/'.$classe->id) !!}">{!! $classe->nom !!}</a></td>
                        <td nowrap>{!! $classe->nom_court !!}</td>
                        <td nowrap>{!! $classe->NomNiveau !!}</td>
                        <td>{!! $classe->NomFiliere !!}</td>
                        <td>{!! $classe->NomPP !!}</td>
                        <td  align="center">{!! $classe->NbEleves !!}</td>
                        <td align="center" >
                            @if($classe->CanDelete)
                                {{ html()->form('DELETE', url('/classes/'. $classe->id))->open() }}   
                                {{ csrf_field() }}
                            @endif
                                <a title="Consulter" href="{!! url('/classes/'.$classe->id) !!}" class="btn btn-info btn-sm">
                                    <span class='fa fa-eye'></span>
                                </a> 
                             @if($classe->CanDelete)
                                <button class="btn btn-sm btn-danger"><span class='fa fa-trash'></span></button>
                                {{ html()->form()->close() }}
                            @endif
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection

@section('scripts')
    @include("forms.scripts_datatable")
@endsection