

<?php $__env->startSection('title'); ?> Enseignants <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Enseignants"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-body">
            <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <!-- <th width='1%'>id</th> -->
                        <th>Nom</th>
                        <th width='5%'>Tel</th>
                        <th width='10%'>Email</th>
                        <th width='1%'>NbClasses</th>
                        <th width='1%'>Classes</th>
                        <th width='1%'>Référent</th>
                        <th width='1px'>
                            <?php if($user->can("ajouter enseignants") || $user->hasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('enseignants/create'); ?>" class="btn btn-sm btn-success">
                                Ajouter un enseignant</a>  
                            <?php endif; ?> 
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $enseignants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enseignant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class=''>
                        <!-- <td style='color:grey'><?php echo $enseignant->id; ?></td> -->
                        <td nowrap><a href="<?php echo url('enseignants/'.$enseignant->id); ?>"><?php echo $enseignant->NomComplet; ?></a></td>
                        <td nowrap><?php echo $enseignant->telHTML; ?></td>
                        <td nowrap><?php echo $enseignant->email; ?></td>
                        <td align="center"><?php echo $enseignant->NbClasse; ?></td>
                        <td nowrap><?php echo $enseignant->ListeClasse; ?></td>
                        <td nowrap>
                            <?php if($enseignant->ReferentNbInfo!=""): ?>
                                <button type="button" 
                                class="btn btn-outline-info" 
                                style='' 
                                data-toggle="modal" data-target="#detail_referent"">
                                <?php echo $enseignant->ReferentNbInfo; ?>

                                </button>

                                <div class="modal fade" id="detail_referent" tabindex="-1" role="dialog" aria-labelledby="smallmodalLabel" aria-hidden="true">
                                    <div class="modal-dialog modal-lg" role="document">
                                        <div class="modal-content  bg-info">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="smallmodalLabel">
                                                    <?php echo $enseignant->NomComplet; ?><br/>référent pour :</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <p><?php echo $enseignant->ReferentListeEleves; ?></p>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </td>
                        <td nowrap >
                            <?php if($enseignant->CanDelete): ?>
                                <?php echo e(html()->form('DELETE', url('/enseignants/'. $enseignant->id))->open()); ?>   
                                <?php echo e(csrf_field()); ?>

                            <?php endif; ?>
                            <a title="Consulter" href="<?php echo url('/enseignants/'.$enseignant->id); ?>" class="btn btn-info btn-sm">
                                <span class='fa fa-eye'></span>
                            </a> 
                            <?php if($enseignant->CanDelete): ?>
                                <button class="btn btn-sm btn-danger"><i title="supprimer" class="fas fa-trash"></i></button>
                                <?php echo e(html()->form()->close()); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\gpfmp_etablissement\resources\views/structures/enseignants/index.blade.php ENDPATH**/ ?>