

<?php $__env->startSection('title'); ?> Classes <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Classes"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
        </div>
        <div class="card-body">
            <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th width='10%'>Nom&nbsp;Court</th>
                        <th width='10%'>Niveau</th>
                        <th width='10%'>Filière</th>
                        <th width='20%'>Professeur&nbsp;Ref.</th>
                        <th width='10%'>Nb&nbsp;Elèves</th>
                        <th width='1px' nowrap>
                            <?php if($user->can("ajouter diplomes") || $user->hasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('classes/create'); ?>" class="btn btn-sm btn-success">
                               <span class='fa fa-plus'></span>&nbsp;Nouvelle<br/>classe</a>   
                            <?php endif; ?>
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><a href="<?php echo url('classes/'.$classe->id); ?>"><?php echo $classe->nom; ?></a></td>
                        <td nowrap><?php echo $classe->nom_court; ?></td>
                        <td nowrap><?php echo $classe->NomNiveau; ?></td>
                        <td><?php echo $classe->NomFiliere; ?></td>
                        <td><?php echo $classe->NomPP; ?></td>
                        <td  align="center"><?php echo $classe->NbEleves; ?></td>
                        <td align="center" >
                            <?php if($classe->CanDelete): ?>
                                <?php echo e(html()->form('DELETE', url('/classes/'. $classe->id))->open()); ?>   
                                <?php echo e(csrf_field()); ?>

                            <?php endif; ?>
                                <a title="Consulter" href="<?php echo url('/classes/'.$classe->id); ?>" class="btn btn-info btn-sm">
                                    <span class='fa fa-eye'></span>
                                </a> 
                             <?php if($classe->CanDelete): ?>
                                <button class="btn btn-sm btn-danger"><span class='fa fa-trash'></span></button>
                                <?php echo e(html()->form()->close()); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\gpfmp_etablissement\resources\views/structures/classes/index.blade.php ENDPATH**/ ?>