

<?php $__env->startSection('title'); ?> Sessions <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Sessions"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>


<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <a href="<?php echo url('sessions'); ?>" class="btn btn-success  btn-sm">
                <i class='fa fa-list'></i>&nbsp;&nbsp;Liste des Sessions</a> 
        </div>
        <div class="card-body">
            <div class="text-muted">
                Cliquez sur la session en couleur pour accéder au détail
            </div>
            <table id="table_stage" class=" table-hover table-striped  table-bordered" >
                <thead>
                    <tr>
                        <th rowspan="2" style="text-align:center">Classes</th>
                        <th colspan="53" style="text-align:center">Occupation des stages par semaine sur <?php echo "2023"; ?></th>
                    </tr>
                    <tr>
                        <?php $__currentLoopData = $semaines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semaine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $t=explode("|",$semaine); ?>
                            <th title="<?php echo $t[1].' au '.$t[2]; ?>" class="cell_th cells" >
                                <?php echo str_pad($t[0],2,"0",STR_PAD_LEFT); ?>

                            </th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tr>
                </thead>
            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $nb_groupe=1;
                    if($classe->groupe==1)$nb_groupe=2;
                ?>
                <?php for($i=0;$i<$nb_groupe;$i++): ?>
                <tr id='tr_week'>
                    <td width="1px" nowrap style="padding:5px">
                        <?php echo $classe->nom_court; ?>

                        <?php if($nb_groupe>1): ?>
                            <?php echo " - Grp ".$i; ?>

                        <?php endif; ?>
                    </td>
                    <?php $__currentLoopData = $semaines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semaine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $t=explode("|",$semaine); 
                            $session=$classe->getSessionWeek($t[0],$i);
                            $style='';$title='';
                            if($session)  {
                                if($session->color==null || $session->color=="#000000") $session->color="red";
                                $style='background-color:'.$session->color;
                                $title=$session->detail;
                            }

                        ?>
                        <td title="<?php echo $title; ?>" id="week_<?php echo $classe->id.'_'.$i.'_'.$t[0].(($session)?'_'.$session->id:''); ?>" class=" cell_td cells" width="1px" style="<?php echo $style; ?>" value="">
                            
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <td>
                            <button  id="<?php echo url('sessions_create/'.$classe->id.'/'.$i); ?>" class="add_session_pop btn btn-sm btn-success">
                                <span class='fa fa-plus'></span>
                            </button>
                        </td>
                </tr>
                <?php endfor; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
    <style>
        .cell_th {
            font-size:0.7em;

        }
        .cell_td {
            font-size:0.7em;
            padding:1px;
            margin:1px;
        }
        .cells {
            padding:1px;
            margin:1px;
            width:30px;
            text-align:center; 
        }
    </style>
    <!-- FancyBox -->
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox.css')); ?>">
    <link media="all" type="text/css" rel="stylesheet" href="<?php echo e(url('css/jquery.fancybox-buttons.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts0'); ?>
    <script src="<?php echo e(url('js/jquery.fancybox.js')); ?>"></script> 
    <script>
    $(document).ready(function() {
        $(".add_session_pop").click(function() {
            set_session(this.id);
        });

        function set_session(url) {
            $.fancybox({
                fitToView   : false,
                autoSize    : true,
                autoScale   : false,
                closeClick  : true,
                openEffect  : "zoom",
                closeEffect : 'zoom',
                type: "iframe",
                href: url,
                beforeOpen: function () {
                },
                afterClose: function () {
                }
            });
        }


        $("td.cell_td").click(function() { 
            var val=this.id;
            var t=val.split('_');
            var nbelt=t.length;
            if(nbelt==4) {
                if(confirm("Voulez-vous ajouter une session de stage ?")) {
                    var url="<?php echo url('sessions_create'); ?>"+'/'+t[1]+'/'+t[2]+'/'+t[3];
                    set_session(url)
                }
                return false;
            }

            var url="<?php echo url('sessions_show'); ?>"+'/'+t[4];
            set_session(url)
        } );
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\entreprise.topstage.fr\resources\views/stages/sessions/index_calendar.blade.php ENDPATH**/ ?>