

<?php $__env->startSection('title'); ?> Sessions <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Sessions"); ?>
<?php $__env->startSection('subtitle_card',"Liste"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <a href="<?php echo url('sessions_calendar'); ?>" class="btn btn-success btn-sm">
                <i class='fa fa-calendar'></i>&nbsp;&nbsp;Agenda
            </a> 
        </div>
        <div class="card-body">
            <div class="form-group">
                <div class="row">
                    <div class="col-md-4">
                        <label>Classe</label>
                        <?php echo html()->select('classe')->options($classes)->value($classe?$classe->id:'')
                            ->placeholder('Choisir une catégorie')
                            ->attributes(['id'=>'classes','class' => 'form-control','onchange'=>'select_classe()']); ?> 
                        <script>
                            $('#classes').selectmenu('refresh');
                            function select_classe() {
                                var select = document.getElementById('classes');
                                var selected = [...select.selectedOptions].map(option => option.value);
                                var url="" ; 
                                if(selected=="") url="<?php echo url('sessions_list/0'); ?>";
                                else url="<?php echo url('sessions_list/'); ?>/"+selected;
                                location.href=url;
                            }
                        </script>
                    </div> 
                </div>
            </div>

            <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th width='10%'>Type de stage</th>
                        <th width='1%'>Début</th>
                        <th width='1%'>Fin</th>
                        <th width='1%'>Durée</th>
                        <th>Classe</th>
                        <th width='10%'>NbElèves</th>
                        <th width='10%'>Stages</th>
                        <th width='10%'>Statut</th>
                        <th width='100px'>
                            <?php if($user->can("ajouter sessions") || $user->hasRole("ADMINISTRATEUR")): ?>
                            <a href="<?php echo url('sessions/create'); ?>" class="btn btn-success  btn-sm">
                                Ajouter une&nbsp;Session</a>   
                            <?php endif; ?>
                        </th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $sessions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class=''>
                        <td><?php echo $session->nom; ?></td>
                        <td><?php echo $session->NomTypeStage; ?></td>
                        <td ><?php echo $session->date_deb; ?></td>
                        <td ><?php echo $session->date_fin; ?></td>
                        <td nowrap><?php echo $session->duree." jours"; ?></td>
                        <td nowrap><?php echo $session->nom_classe; ?></td>
                        <td nowrap><?php echo $session->nb_eleves; ?></td>
                        <td><?php echo $session->nb_stages; ?></td>
                        <td><?php echo $session->statut; ?></td>
                        <td nowrap>
                            <?php if(($session->statut!='TER')&&($menu!="sessions terminées")): ?>
                                <a href="<?php echo url('sessions_generation/'.$session->id); ?>" 
                                    class="btn btn-warning btn-sm" style="margin: 3px;margin-left: 0px;">
                                   Gérer les Stagiaires
                                </a>

                                <a href="<?php echo url('sessions/'.$session->id.'/edit'); ?>" class="btn btn-info btn-sm pull-left" style="margin-right: 3px;">
                                    Modifier la session
                                </a>
                            <?php endif; ?>

                            <?php if($session->CanDelete): ?>
                                <?php echo e(html()->form('DELETE', url('/sessions/'. $session->id))->open()); ?>   
                                <?php echo e(csrf_field()); ?>

                            <?php endif; ?>
                                <button class="btn btn-danger">
                                    <span class='ti-trash'></span>
                                </button>
                            <?php if($session->CanDelete): ?>
                                <?php echo e(html()->form()->close()); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>

            </table>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\gpfmp_etablissement\resources\views/stages/sessions/index.blade.php ENDPATH**/ ?>