

<?php $__env->startSection('title'); ?> Elèves <?php $__env->stopSection(); ?>
<?php $__env->startSection('title_card',"Structures"); ?>
<?php $__env->startSection('subtitle_card',"Elèves"); ?>

<?php $__env->startSection('content'); ?>
    <?php if(Session::has('message')): ?>
        <div class="alert alert-warning"><?php echo Session::get('message'); ?></div>
    <?php endif; ?>
    <?php if(Session::has('success')): ?>
        <div class="alert alert-success"><?php echo \Session::get('success'); ?></div>
    <?php endif; ?>
    <?php if($errors): ?>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class='bg-danger alert'><?php echo $error; ?></div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-md-6">
                    <label>Classe</label>
                    <?php echo html()->select('select_id_classe')->options($classes)->value(($classe)?$classe->id:'')
                        ->placeholder('Choisir une Classe')
                        ->attributes(['id'=>'select_id_classe','class' => 'form-control','onchange'=>'select_filtre()']); ?> 
                </div>
            </div>

            <script>
                function select_filtre() {
                    var select_id_classe = document.getElementById('select_id_classe');
                    var select_id_classe = [...select_id_classe.selectedOptions].map(option => option.value);
                    var url="" ; 
                    if(select_id_classe=="") select_id_classe=0;
                    url="<?php echo url('eleves_list/'); ?>/"+select_id_classe;
                    location.href=url;
                }
            </script>
        </div>
        <?php if($classe): ?>
            <div class="card-body">
                <table id="_table" class="table table-bordered table-hover dataTable dtr-inline" role="grid">
                    <thead>
                        <tr>
                            <th>Nom</th>
                            <th width='1px'>DateNaiss.</th>
                            <th width='1px'>Email</th>
                            <th width='1px'>
                                <?php if($user->can("ajouter eleves") || $user->hasRole("ADMINISTRATEUR")): ?>
                                <a href="<?php echo url('eleves/create'); ?>" class="btn btn-sm btn-success">
                                    Nouvel élève</a>  
                                <?php endif; ?> 
                            </th>
                        </tr>
                    </thead>
         
                    <tbody>
                        <?php $__currentLoopData = $eleves; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eleve): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr class=''>
                            <td><a href="<?php echo url('eleves/'.$eleve->id); ?>"><?php echo $eleve->nomcomplet; ?></a></td>
                            <td nowrap><?php echo $eleve->DateNaissance; ?></td>
                            <td nowrap><?php echo $eleve->email; ?></td> 
                            <td nowrap>
                                <?php if($eleve->CanDelete): ?>
                                    <?php echo e(html()->form('DELETE', url('/eleves/'. $eleve->id))->open()); ?>   
                                    <?php echo e(csrf_field()); ?>

                                <?php endif; ?>
                                <a title="Consulter" href="<?php echo url('eleves/'.$eleve->id); ?>" class="btn btn-sm btn-info">
                                    <span class='fa fa-eye'></span>
                                </a>
                                <?php if($eleve->CanDelete): ?>
                                    <button  title="Supprimer" class="btn btn-danger btn-sm"><span class='fa fa-trash'></span></button>
                                    <?php echo e(html()->form()->close()); ?>

                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <?php echo $__env->make("forms.scripts_datatable", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
      $(function () {
        //Initialize Select2 Elements
        $('.select2').select2()

       })

        function select_classe() {
            //var classes=$('#classes').val();
            var select = document.getElementById('classes');
            var selected = [...select.selectedOptions].map(option => option.value);
            var url="" ; 
            if(selected=="") url="<?php echo url('eleves_list/0'); ?>";
            else url="<?php echo url('eleves_list/'); ?>/"+selected;
            location.href=url;

        }

        function select_groupe() {
            var select_groupe = document.getElementById('groupes');
            var selected_groupe = [...select_groupe.selectedOptions].map(option => option.value);
            var select_classe = document.getElementById('classes');
            var selected_classe = [...select_classe.selectedOptions].map(option => option.value);
            var url="" ; 
            if(selected_classe=="") url="<?php echo url('eleves_list/0'); ?>";
            if(select_groupe=="") url="<?php echo url('eleves_list'); ?>/"+selected_classe;
            else url="<?php echo url('eleves_list/'); ?>/"+selected_classe+"/"+selected_groupe;
            location.href=url;

        }
    </script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.dash', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\GPFMP\gpfmp_etablissement\resources\views/structures/eleves/index.blade.php ENDPATH**/ ?>