<style>
.table-scroll {
    position:relative;
    max-width:600px;
    margin:auto;
    overflow:hidden;
    border:1px solid #000;
}
.table-wrap {
    width:100%;
    overflow:auto;
}
.table-scroll table {
    width:100%;
    margin:auto;
    border-collapse:separate;
    border-spacing:0;
}
.table-scroll th, .table-scroll td {
    padding:5px 10px;
    border:1px solid #000;
    background:#fff;
    white-space:nowrap;
    vertical-align:top;
}
.table-scroll thead, .table-scroll tfoot {
    background:#f9f9f9;
}
.clone {
    position:absolute;
    top:0;
    left:0;
    pointer-events:none;
}
.clone th, .clone td {
    visibility:hidden
}
.clone td, .clone th {
    border-color:transparent
}
.clone tbody th {
    visibility:visible;
    color:red;
}
.clone .fixed-side {
    border:1px solid #000;
    background:#eee;
    visibility:visible;
}
.clone thead, .clone tfoot{background:transparent;}
</style>



<p>See <a href="https://codepen.io/paulobrien/pen/LBrMxa" target="blank">position Sticky version </a>with no JS</p>

<div class="row">
  <div class="col-12">
    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Sessions de stage</h3>
      </div>
      <div class="card-body">
        <ul class="pagination pagination-month justify-content-center">
            <li class="page-item"><a class="page-link" href="#">«</a></li>
            <?php foreach($t_mois as $mois) { ?>
                <li class="page-item" >
                    <a class="page-link" href="#" style="<?php echo e(in_array($mois, $page)?'background-color: rgba(var(--bs-body-color-rgb), 0.08);':''); ?>">
                        <p class="page-month"><?php echo $mois ?></p>
                        <p class="page-year"><?php echo date('Y') ?></p>
                    </a>
                </li>
            <?php } ?>
            <li class="page-item"><a class="page-link" href="#">»</a></li>
        </ul>


<div id="table-scroll" class="table-scroll">
  <div class="table-wrap">
    <table class="main-table">
      <thead>
        <tr>
            <th rowspan="3" class="fixed-side" scope="col">Etablissement</th>
            <th rowspan="3" scope="col" class="fixed-side" scope="col">CLasse</th>
            <th scope="col" colspan="52" style="text-align:center">Occupation des stages par semaine sur <?php echo "2023"; ?></th>
        </tr>

                <tr>
                    <?php $__currentLoopData = $semaines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semaine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php 
                        $t_dates=App\Models\MyApp::week2day(intVal($semaine));
                        $date_deb=str_replace("-","/",substr($t_dates[0],5,5));
                        $date_fin=str_replace("-","/",substr($t_dates[1],5,5));
                    ?>
                        <th scope="col" class="date_agenda">&nbsp;<?php echo $date_deb; ?> au <?php echo $date_fin; ?></th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <tr>
                    <?php $__currentLoopData = $semaines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semaine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $t=explode("|",$semaine); ?>

                        <th scope="col" title="<?php echo $t[1].' au '.$t[2]; ?>" class="th_agenda" >
                            <?php echo str_pad($t[0],2,"0",STR_PAD_LEFT); ?>

                        </th>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
      </thead>
      <tbody>
            <?php $__currentLoopData = $classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $classe): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $nb_groupe=1;
                    if($classe->groupe==1)$nb_groupe=2;
                    if(in_array($mois, $page)) {$semaine_min=1;$semaine_max=30;}
                    else 
                ?>
                <?php for($i=0;$i<$nb_groupe;$i++): ?>
                <tr class="td_agenda" id='tr_week'>
                    <td class="fixed-side"><?php echo $classe->NomEtablissement." - ".$classe->nom_court; ?></td>
                    <td class="fixed-side"><?php echo $classe->NomDiplome; ?></td>
                    <?php $__currentLoopData = $semaines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $semaine): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php 
                            $t=explode("|",$semaine); 
                            $session=$classe->getSessionWeek($t[0],$i);
                            $style='';$title='';
                            if($session)  {
                                if($session->color==null || $session->color=="#000000") $session->color="red";
                                $style='background-color:'.$session->color;
                                $title=$session->detail;
                            }

                        ?>
                        <td title="<?php echo $title; ?>" id="week_<?php echo $classe->id.'_'.$i.'_'.$t[0].(($session)?'_'.$session->id:''); ?>" 
                            class="td_agenda week_page_<?php echo e($t[0]); ?>" width="1px" style="<?php echo $style; ?>" value="">
                            
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
                <?php endfor; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
      </tbody>
    </table>
  </div>
</div>






      </div> <!-- bodu card -->
    </div>
  </div>
</div>

<?php /**PATH /var/www/html/entreprise.gpfmp.fr/resources/views/agendas/calendar_bck.blade.php ENDPATH**/ ?>