<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;

use App\Models\User;
use DB;
use View;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Auth;
use App\Models\Role2;
use App\Http\Requests\ProfilRequest;

class ChangeProfilController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Confirm Password Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password confirmations and
    | uses a simple trait to include the behavior. You're free to explore
    | this trait and override any functions that require customization.
    |
    */

    /**
     * Where to redirect users when the intended url fails.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }


    public function newprofil()
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );

        $users_list=array();
        $res_list=array();
        if(Session::get('origine_id')) {
            $origine_user=User::where('id','=',Session::get('origine_id'))->first();
            if($origine_user->hasRole('ADMINISTRATEUR') || $origine_user->hasRole('DANE')) {
                $users_list=User::orderby("name")->get();
                foreach($users_list as $user_list) {
                    $user_enc=User::find($user_list->id);
                    $roles='  ('.$user_enc->getRoles(";").')';
                    if(!$user_enc->hasrole('ADMINISTRATEUR') && ($origine_user->id!=$user_list->id) ) {
                        $res_list[$user_list->id]=$user_list->name.$roles;
                    }
                    if($origine_user->id!=$user_list->id) {
                        $roles='  ('.$origine_user->getRoles(";").')';
                        $res_list[$origine_user->id]=$origine_user->name.$roles." * ";
                    }
                }
                return View::make('auth.change_profil', ['users_list' => $res_list,'user' => $user]);
            }
        }
        return;
    }

    public function changeprofil(ProfilRequest $request)
    {
        $user = Auth::user();
        if(!$user) return Redirect::route( 'login' );
        $user_id=$user->id;
        $origine_user=User::where('id','=',Session::get('origine_id'))->first();
        if($origine_user->hasRole("ADMINISTRATEUR") || $origine_user->hasRole("ADMINISTRATEUR FONCTIONNEL")
                || $origine_user->hasRole("DANE")) {
            $new_user_id=$request->user_id;
            $new_user=User::find($new_user_id);  
            if($new_user) {
                Auth::logout();
                Auth::setUser($new_user);
                $request->email=$new_user->email;
                $request->password=$new_user->password;
                Auth::login($new_user, $request->has('remember'));
                //Auth::login($new_user);
                /*
                $user = Auth::user();  
                Session::put('id', $new_user->id);
                Session::put('id_origine', $user_id);
                */
                return Redirect::to('/home');

            }
        }
       return ;
    }
}
