<?php namespace App\Http\Requests;
 
use Illuminate\Foundation\Http\FormRequest;
 
class ClasseRequest extends FormRequest {
    public function rules() {
        return [
            'nom' => 'required|max:100',
            'nom_court' => 'required|max:20',
            'id_filiere' => 'required',
            'id_niveau' => 'required',
            'prof' => 'max:100',
            'prof_tel' => 'max:6',
            'prof_email' => 'max:100',
            'id_modele_conv' => '',
            'id_modele_att' => '',
        ];
    }
 

     public function attributes() {
        return [
            'nom' => 'Nom de la classe',
            'nom_court' => 'Nom abrégé de la classe',
            'id_filiere' => 'Filière',
            'id_niveau' => 'Niveau',
            'prof' => 'Nom du professeur principal',
            'prof_tel' => 'Téléphone du professeur principal',
            'prof_email' => 'Email du professeur principal',
            'id_modele_conv' => 'Modèle de convention',
            'id_modele_att' => 'Modèle d\'attestation',
        ];
    }


    public function authorize() {
        return true;
    }
}